/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.operator.crossover;

import com.google.inject.Inject;
import org.opt4j.common.random.Rand;
import org.opt4j.operator.crossover.CrossoverDoubleElementwise;
import org.opt4j.operator.normalize.NormalizeDouble;
import org.opt4j.optimizer.ea.Pair;
import org.opt4j.start.Constant;

public class CrossoverDoubleBLX
extends CrossoverDoubleElementwise {
    protected final double alpha;

    @Inject
    public CrossoverDoubleBLX(@Constant(value="alpha", namespace=CrossoverDoubleBLX.class) @Constant(value="alpha", namespace=CrossoverDoubleBLX.class) double alpha, NormalizeDouble normalize, Rand random) {
        super(normalize, random);
        this.alpha = alpha;
    }

    @Override
    public Pair<Double> crossover(double x, double y) {
        double lo = Math.min(x, y);
        double hi = Math.max(x, y);
        double o1 = this.next(lo, hi);
        double o2 = this.next(lo, hi);
        return new Pair<Double>(o1, o2);
    }

    protected double next(double lo, double hi) {
        double u = this.random.nextDouble();
        double gamma = (1.0 + 2.0 * this.alpha) * u - this.alpha;
        double o = lo + gamma * (hi - lo);
        return o;
    }
}

