/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.operator.crossover;

import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.opt4j.common.random.Rand;
import org.opt4j.operator.crossover.CrossoverDoubleElementwise;
import org.opt4j.operator.normalize.NormalizeDouble;
import org.opt4j.optimizer.ea.Pair;
import org.opt4j.start.Constant;

public class CrossoverDoubleSBX
extends CrossoverDoubleElementwise {
    protected double nu;

    @Inject
    public CrossoverDoubleSBX(@Constant(value="nu", namespace=CrossoverDoubleSBX.class) @Constant(value="nu", namespace=CrossoverDoubleSBX.class) double nu, NormalizeDouble normalize, Rand random) {
        super(normalize, random);
        this.nu = nu;
    }

    @Override
    public Pair<Double> crossover(double x, double y) {
        double u = this.random.nextDouble();
        double beta = 0.5 <= u ? Math.pow(2.0 * u, 1.0 / (this.nu + 1.0)) : Math.pow(1.0 / (2.0 - 2.0 * u), 1.0 / (this.nu + 1.0));
        double o1 = 0.5 * ((1.0 + beta) * x + (1.0 - beta) * y);
        double o2 = 0.5 * ((1.0 - beta) * x + (1.0 + beta) * y);
        if (this.random.nextDouble() < 0.5) {
            double tmp = o1;
            o1 = o2;
            o2 = tmp;
        }
        return new Pair<Double>(o1, o2);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @BindingAnnotation
    protected static @interface Nu {
    }
}

