/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.operator.crossover;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.opt4j.core.Genotype;
import org.opt4j.genotype.CompositeGenotype;
import org.opt4j.operator.AbstractGenericOperator;
import org.opt4j.operator.crossover.Crossover;
import org.opt4j.operator.crossover.CrossoverBoolean;
import org.opt4j.operator.crossover.CrossoverDouble;
import org.opt4j.operator.crossover.CrossoverInteger;
import org.opt4j.operator.crossover.CrossoverPermutation;
import org.opt4j.optimizer.ea.Pair;

@Singleton
public class CrossoverGenericImplementation
extends AbstractGenericOperator<Crossover<Genotype>, Crossover<?>>
implements Crossover<Genotype> {
    @Inject
    protected CrossoverGenericImplementation() {
        super(CrossoverBoolean.class, CrossoverDouble.class, CrossoverInteger.class, CrossoverPermutation.class);
    }

    @Override
    public Pair<Genotype> crossover(Genotype parent1, Genotype parent2) {
        Crossover crossover = (Crossover)this.getOperator(parent1);
        if (crossover == null) {
            return this.crossoverComposite((CompositeGenotype)parent1, (CompositeGenotype)parent2);
        }
        return crossover.crossover(parent1, parent2);
    }

    protected Pair<Genotype> crossoverComposite(CompositeGenotype<?, ?> p1, CompositeGenotype<?, ?> p2) {
        CompositeGenotype o1 = (CompositeGenotype)p1.newInstance();
        CompositeGenotype o2 = (CompositeGenotype)p2.newInstance();
        for (Object key : p1.keySet()) {
            Genotype g1 = (Genotype)p1.get(key);
            Genotype g2 = (Genotype)p2.get(key);
            Pair<Genotype> genotype = this.crossover(g1, g2);
            o1.put(key, genotype.getFirst());
            o2.put(key, genotype.getSecond());
        }
        Pair<Genotype> offspring = new Pair<Genotype>(o1, o2);
        return offspring;
    }
}

