/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.optimizer.ea;

import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualStateListener;
import org.opt4j.core.Objective;
import org.opt4j.core.Objectives;
import org.opt4j.core.Value;

@Singleton
public class Normalizer
implements IndividualStateListener {
    private final Map<Objective, Double> minValues = new HashMap<Objective, Double>();
    private final Map<Objective, Double> maxValues = new HashMap<Objective, Double>();

    public Objectives normalize(Objectives objectives) {
        Objectives normalized = new Objectives();
        for (Map.Entry<Objective, Value<?>> entry : objectives) {
            Objective objective = entry.getKey();
            double oldvalue = Normalizer.toMinProblem(entry.getKey(), entry.getValue());
            double newvalue = 1.0;
            if (oldvalue != Double.MAX_VALUE) {
                Double min = this.minValues.get(objective);
                Double max = this.maxValues.get(objective);
                assert (min != null);
                assert (max != null);
                newvalue = (oldvalue - min) / (max - min);
            }
            normalized.add(objective, newvalue);
        }
        return normalized;
    }

    @Override
    public void inidividualStateChanged(Individual individual) {
        if (individual.isEvaluated()) {
            for (Map.Entry<Objective, Value<?>> entry : individual.getObjectives()) {
                Objective objective = entry.getKey();
                double value = Normalizer.toMinProblem(entry.getKey(), entry.getValue());
                if (this.minValues.get(objective) == null || value < this.minValues.get(objective)) {
                    this.minValues.put(objective, value);
                }
                if (this.maxValues.get(objective) != null && !(value > this.maxValues.get(objective))) continue;
                this.maxValues.put(objective, value);
            }
        }
    }

    public static final double toMinProblem(Objective objective, Value<?> value) {
        Double v = value.getDouble();
        Double result = null;
        result = v == null ? Double.valueOf(Double.MAX_VALUE) : (objective.getSign() == Objective.Sign.MAX ? Double.valueOf(-v.doubleValue()) : v);
        assert (result != null);
        return result;
    }
}

