/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.optimizer.mopso;

import com.google.inject.Inject;
import org.opt4j.common.random.Rand;
import org.opt4j.core.optimizer.Iteration;
import org.opt4j.operator.normalize.NormalizeDouble;
import org.opt4j.optimizer.mopso.MutateDoubleUniform;
import org.opt4j.start.Constant;

public class MutateDoubleNonUniform
extends MutateDoubleUniform {
    protected final Iteration iteration;

    @Inject
    public MutateDoubleNonUniform(Rand random, NormalizeDouble normalize, Iteration iteration, @Constant(value="perturbation", namespace=MutateDoubleNonUniform.class) @Constant(value="perturbation", namespace=MutateDoubleNonUniform.class) double perturbation) {
        super(random, normalize, perturbation);
        this.iteration = iteration;
    }

    @Override
    protected double mutateElement(double x, double lb, double ub, double p) {
        if (this.random.nextDouble() < p) {
            double tau = this.random.nextBoolean() ? 1 : -1;
            x += tau * this.delta(this.perturbation);
        }
        return x;
    }

    protected double delta(double perturbation) {
        double r = this.random.nextDouble();
        double actIter = this.iteration.value();
        double maxIter = this.iteration.max();
        double ratio = actIter / maxIter;
        ratio = Math.min(ratio, 1.0);
        double y = Math.pow(1.0 - ratio, perturbation);
        return 1.0 * (1.0 - Math.pow(r, y));
    }
}

