/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.optimizer.sa;

import com.google.inject.Inject;
import java.util.Random;
import org.opt4j.common.random.Rand;
import org.opt4j.core.Genotype;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualFactory;
import org.opt4j.core.Objectives;
import org.opt4j.core.optimizer.AbstractOptimizer;
import org.opt4j.core.optimizer.Archive;
import org.opt4j.core.optimizer.Control;
import org.opt4j.core.optimizer.IndividualCompleter;
import org.opt4j.core.optimizer.Iteration;
import org.opt4j.core.optimizer.Population;
import org.opt4j.core.optimizer.StopException;
import org.opt4j.core.optimizer.TerminationException;
import org.opt4j.operator.copy.Copy;
import org.opt4j.operator.neighbor.Neighbor;
import org.opt4j.optimizer.sa.CoolingSchedule;

public class SimulatedAnnealing
extends AbstractOptimizer {
    protected final Random random;
    protected final Neighbor<Genotype> neighbor;
    protected final Copy<Genotype> copy;
    protected final CoolingSchedule coolingSchedule;
    private final IndividualFactory individualFactory;

    @Inject
    public SimulatedAnnealing(Population population, Archive archive, IndividualFactory individualFactory, IndividualCompleter completer, Control control, Rand random, Neighbor<Genotype> neighbor, Copy<Genotype> copy, Iteration iteration, CoolingSchedule coolingSchedule) {
        super(population, archive, completer, control, iteration);
        this.random = random;
        this.neighbor = neighbor;
        this.copy = copy;
        this.coolingSchedule = coolingSchedule;
        this.individualFactory = individualFactory;
    }

    @Override
    public void optimize() throws TerminationException, StopException {
        Individual x = this.individualFactory.create();
        Individual y = null;
        this.population.add(x);
        this.completer.complete(this.population);
        this.archive.update(x);
        this.nextIteration();
        double fx = this.f(x);
        while (this.iteration.value() < this.iteration.max()) {
            Genotype g = this.copy.copy(x.getGenotype());
            this.neighbor.neighbor(g);
            y = this.individualFactory.create(g);
            this.completer.complete(y);
            this.archive.update(y);
            double fy = this.f(y);
            boolean sw = false;
            if (fy <= fx) {
                sw = true;
            } else {
                double a = (fx - fy) / this.coolingSchedule.getTemperature(this.iteration.value(), this.iteration.max());
                double e = Math.exp(a);
                if (this.random.nextDouble() < e) {
                    sw = true;
                }
            }
            if (sw) {
                this.population.remove(x);
                this.population.add(y);
                fx = fy;
                x = y;
            }
            this.nextIteration();
        }
    }

    protected double f(Individual individual) {
        Objectives objectives = individual.getObjectives();
        double sum = 0.0;
        double[] dArray = objectives.array();
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            sum += d;
            ++n2;
        }
        return sum;
    }
}

