/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.viewer;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualSet;
import org.opt4j.core.IndividualSetListener;

class SynchronizedIndividualSet
implements Set<Individual>,
IndividualSetListener {
    private final Set<Individual> set = new HashSet<Individual>();
    private final Object mutex;
    protected final Set<IndividualSetListener> listeners = new CopyOnWriteArraySet<IndividualSetListener>();

    public void addListener(IndividualSetListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IndividualSetListener listener) {
        this.listeners.remove(listener);
    }

    public SynchronizedIndividualSet(IndividualSet collection) {
        this.mutex = this;
        collection.addListener(this);
        while (true) {
            try {
                this.set.addAll(collection);
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                this.set.clear();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.mutex;
        synchronized (object) {
            return this.set.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.mutex;
        synchronized (object) {
            return this.set.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        Object object = this.mutex;
        synchronized (object) {
            return this.set.contains(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Individual> iterator() {
        Object object = this.mutex;
        synchronized (object) {
            return this.set.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Object object = this.mutex;
        synchronized (object) {
            return this.set.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        Object object = this.mutex;
        synchronized (object) {
            return this.set.toArray(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Individual e) {
        Object object = this.mutex;
        synchronized (object) {
            return this.set.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        Object object = this.mutex;
        synchronized (object) {
            return this.set.remove(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        Object object = this.mutex;
        synchronized (object) {
            return this.set.containsAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends Individual> c) {
        Object object = this.mutex;
        synchronized (object) {
            return this.set.addAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        Object object = this.mutex;
        synchronized (object) {
            return this.set.retainAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        Object object = this.mutex;
        synchronized (object) {
            return c.removeAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.mutex;
        synchronized (object) {
            this.set.clear();
        }
    }

    @Override
    public void individualAdded(IndividualSet collection, Individual individual) {
        this.add(individual);
        for (IndividualSetListener listener : this.listeners) {
            listener.individualAdded(collection, individual);
        }
    }

    @Override
    public void individualRemoved(IndividualSet collection, Individual individual) {
        this.remove(individual);
    }
}

