/*
 * generated by Xtext 2.12.0
 */
package org.palladiosimulator.commons.stoex.formatting2

import com.google.inject.Inject
import de.uka.ipd.sdq.probfunction.BoxedPDF
import de.uka.ipd.sdq.probfunction.ProbabilityMassFunction
import de.uka.ipd.sdq.probfunction.Sample
import de.uka.ipd.sdq.stoex.BooleanOperatorExpression
import de.uka.ipd.sdq.stoex.CompareExpression
import de.uka.ipd.sdq.stoex.FunctionLiteral
import de.uka.ipd.sdq.stoex.IfElseExpression
import de.uka.ipd.sdq.stoex.NamespaceReference
import de.uka.ipd.sdq.stoex.NegativeExpression
import de.uka.ipd.sdq.stoex.NotExpression
import de.uka.ipd.sdq.stoex.Parenthesis
import de.uka.ipd.sdq.stoex.PowerExpression
import de.uka.ipd.sdq.stoex.ProbabilityFunctionLiteral
import de.uka.ipd.sdq.stoex.ProductExpression
import de.uka.ipd.sdq.stoex.TermExpression
import de.uka.ipd.sdq.stoex.Variable
import org.eclipse.xtext.formatting2.AbstractFormatter2
import org.eclipse.xtext.formatting2.IFormattableDocument
import org.palladiosimulator.commons.stoex.services.StoexGrammarAccess
import de.uka.ipd.sdq.probfunction.StringSample
import de.uka.ipd.sdq.probfunction.DoubleSample
import de.uka.ipd.sdq.probfunction.IntSample
import de.uka.ipd.sdq.probfunction.BoolSample

class StoexFormatter extends AbstractFormatter2 {
	
	@Inject extension StoexGrammarAccess

	def dispatch void format(IfElseExpression ifElseExpression, extension IFormattableDocument document) {
		ifElseExpression.regionFor.keyword(ifelseExprAccess.questionMarkKeyword_1_1).prepend[oneSpace].append[oneSpace]
		ifElseExpression.regionFor.keyword(ifelseExprAccess.colonKeyword_1_3).prepend[oneSpace].append[oneSpace]
	}

	def dispatch void format(BooleanOperatorExpression booleanOperatorExpression, extension IFormattableDocument document) {
		booleanOperatorExpression.getLeft.format.append[oneSpace]
		booleanOperatorExpression.getRight.format.prepend[oneSpace]
	}
	
	def dispatch void format(CompareExpression compareExpression, extension IFormattableDocument document) {
		compareExpression.left.format.append[oneSpace]
		compareExpression.right.format.prepend[oneSpace]
	}
	
	def dispatch void format(NegativeExpression negativeExpression, extension IFormattableDocument document) {
		negativeExpression.regionFor.keyword(negativeExpressionAccess.hyphenMinusKeyword_0).append[oneSpace]
		negativeExpression.prepend[noSpace].append[noSpace]
	}
	
	def dispatch void format(NotExpression notExpression, extension IFormattableDocument document) {
		notExpression.regionFor.keyword(notExpressionAccess.NOTKeyword_0).append[oneSpace]
		notExpression.prepend[noSpace].append[noSpace]
	}
	
	def dispatch void format(PowerExpression powerExpression, extension IFormattableDocument document) {
		powerExpression.regionFor.keyword(powExprAccess.circumflexAccentKeyword_1_1).prepend[oneSpace].append[oneSpace]
		powerExpression.base.format
		powerExpression.exponent.format
		powerExpression.prepend[noSpace; lowPriority].append[noSpace; lowPriority]
	}
	
	def dispatch void format(ProductExpression productExpression, extension IFormattableDocument document) {
		productExpression.left.format.append[oneSpace]
		productExpression.right.format.prepend[oneSpace]
		productExpression.prepend[noSpace; lowPriority].append[noSpace; lowPriority]
	}
	
	def dispatch void format(TermExpression termExpression, extension IFormattableDocument document) {
		termExpression.left.format.append[oneSpace]
		termExpression.right.format.prepend[oneSpace]
		termExpression.prepend[noSpace; lowPriority].append[noSpace; lowPriority]
	}
	
	/*
	def dispatch void format(UnitPower unitPower, extension IFormattableDocument document) {
		unitPower.regionFor.keyword(unitPowAccess.circumflexAccentKeyword_1_1).prepend[oneSpace].append[oneSpace]
		unitPower.regionFor.keyword(unitPowAccess.leftParenthesisKeyword_0_1_0).append[oneSpace]
		unitPower.regionFor.keyword(unitPowAccess.rightParenthesisKeyword_0_1_2).prepend[oneSpace]
	}
	*/
	
	def dispatch void format(ProbabilityMassFunction<Sample<?>> probabilityMassFunction, extension IFormattableDocument document) {
		probabilityMassFunction.samples.forEach[format]
		probabilityMassFunction.regionFor.keyword(probabilityMassFunctionAccess.leftParenthesisKeyword_2_1_0).prepend[noSpace].append[noSpace]
		probabilityMassFunction.regionFor.keyword(probabilityMassFunctionAccess.leftParenthesisKeyword_3_1_0).prepend[noSpace].append[noSpace]
		probabilityMassFunction.regionFor.keyword(probabilityMassFunctionAccess.leftSquareBracketKeyword_0_1).prepend[noSpace].append[noSpace]
		//probabilityMassFunction.regionFor.keyword(probabilityMassFunctionAccess.leftSquareBracketKeyword_0_4_0).prepend[noSpace].append[noSpace]
		probabilityMassFunction.regionFor.keyword(probabilityMassFunctionAccess.leftSquareBracketKeyword_1_1).prepend[noSpace].append[noSpace]
		//probabilityMassFunction.regionFor.keyword(probabilityMassFunctionAccess.leftSquareBracketKeyword_1_4_0).prepend[noSpace].append[noSpace]
		probabilityMassFunction.regionFor.keyword(probabilityMassFunctionAccess.leftSquareBracketKeyword_2_2).prepend[noSpace].append[noSpace]
		probabilityMassFunction.regionFor.keyword(probabilityMassFunctionAccess.leftSquareBracketKeyword_3_2).prepend[noSpace].append[noSpace]
		probabilityMassFunction.regionFor.keyword(probabilityMassFunctionAccess.rightParenthesisKeyword_2_1_2).prepend[noSpace].append[noSpace]
		probabilityMassFunction.regionFor.keyword(probabilityMassFunctionAccess.rightParenthesisKeyword_3_1_2).prepend[noSpace].append[noSpace]
		probabilityMassFunction.regionFor.keyword(probabilityMassFunctionAccess.rightSquareBracketKeyword_0_3).prepend[noSpace].append[noSpace]
		//probabilityMassFunction.regionFor.keyword(probabilityMassFunctionAccess.rightSquareBracketKeyword_0_4_2).prepend[noSpace].append[noSpace]
		probabilityMassFunction.regionFor.keyword(probabilityMassFunctionAccess.rightSquareBracketKeyword_1_3).prepend[noSpace].append[noSpace]
		//probabilityMassFunction.regionFor.keyword(probabilityMassFunctionAccess.rightSquareBracketKeyword_1_4_2).prepend[noSpace].append[noSpace]
		probabilityMassFunction.regionFor.keyword(probabilityMassFunctionAccess.rightSquareBracketKeyword_2_4).prepend[noSpace].append[noSpace]
		probabilityMassFunction.regionFor.keyword(probabilityMassFunctionAccess.rightSquareBracketKeyword_3_4).prepend[noSpace].append[noSpace]
		
		probabilityMassFunction.regionFor.keyword(probabilityMassFunctionAccess.intPMFKeyword_0_0).prepend[noSpace].append[noSpace]
		probabilityMassFunction.regionFor.keyword(probabilityMassFunctionAccess.doublePMFKeyword_1_0).prepend[noSpace].append[noSpace]
		probabilityMassFunction.regionFor.keyword(probabilityMassFunctionAccess.enumPMFKeyword_2_0).prepend[noSpace].append[noSpace]
		probabilityMassFunction.regionFor.keyword(probabilityMassFunctionAccess.boolPMFKeyword_3_0).prepend[noSpace].append[noSpace]
	}
	
	def dispatch void format(Sample<?> sample, extension IFormattableDocument document) {
		sample.prepend[noSpace].append[noSpace]
	}

    def dispatch void format(IntSample sample, extension IFormattableDocument document) {
        _format(sample as Sample<?>, document)
        sample.regionFor.keyword(numeric_int_sampleAccess.leftParenthesisKeyword_0).append[noSpace]
        sample.regionFor.keyword(numeric_int_sampleAccess.rightParenthesisKeyword_4).prepend[noSpace]
        sample.regionFor.keyword(numeric_int_sampleAccess.semicolonKeyword_2).prepend[noSpace].append[noSpace]
    }

    def dispatch void format(DoubleSample sample, extension IFormattableDocument document) {
        _format(sample as Sample<?>, document)
        sample.regionFor.keyword(numeric_real_sampleAccess.leftParenthesisKeyword_0).append[noSpace]
        sample.regionFor.keyword(numeric_real_sampleAccess.rightParenthesisKeyword_4).prepend[noSpace]
        sample.regionFor.keyword(numeric_real_sampleAccess.semicolonKeyword_2).prepend[noSpace].append[noSpace]
    }
    
    def dispatch void format(StringSample sample, extension IFormattableDocument document) {
        _format(sample as Sample<?>, document)
        sample.regionFor.keyword(stringsampleAccess.leftParenthesisKeyword_0).append[noSpace]
        sample.regionFor.keyword(stringsampleAccess.rightParenthesisKeyword_4).prepend[noSpace]
        sample.regionFor.keyword(stringsampleAccess.semicolonKeyword_2).prepend[noSpace].append[noSpace]
    }
    
    def dispatch void format(BoolSample sample, extension IFormattableDocument document) {
        _format(sample as Sample<?>, document)
        sample.regionFor.keyword(boolsampleAccess.leftParenthesisKeyword_0).append[noSpace]
        sample.regionFor.keyword(boolsampleAccess.rightParenthesisKeyword_4).prepend[noSpace]
        sample.regionFor.keyword(boolsampleAccess.semicolonKeyword_2).prepend[noSpace].append[noSpace]
    }
	
	def dispatch void format(BoxedPDF boxedPDF, extension IFormattableDocument document) {
		boxedPDF.regionFor.keyword(boxedPDFAccess.doublePDFKeyword_0).prepend[noSpace; lowPriority].append[noSpace; lowPriority]
		boxedPDF.regionFor.keyword(boxedPDFAccess.leftSquareBracketKeyword_1).prepend[noSpace].append[noSpace]
		//boxedPDF.regionFor.keyword(boxedPDFAccess.leftSquareBracketKeyword_4_0).prepend[noSpace].append[noSpace]
		
		boxedPDF.regionFor.keyword(boxedPDFAccess.rightSquareBracketKeyword_3).prepend[noSpace].append[noSpace]
		//boxedPDF.regionFor.keyword(boxedPDFAccess.rightSquareBracketKeyword_4_2).prepend[noSpace].append[noSpace]
	}
	
	/*
	def dispatch void format(UnitMultiplication unitMultiplication, extension IFormattableDocument document) {
		unitMultiplication.regionFor.keyword(unitMultiAccess.asteriskKeyword_1_1).prepend[oneSpace].append[oneSpace]
	}
	
	def dispatch void format(UnitDivision unitDivision, extension IFormattableDocument document) {
		unitDivision.regionFor.keyword(unitDivAccess.solidusKeyword_1_1).prepend[oneSpace].append[oneSpace]
	}
	*/
	
	def dispatch void format(NamespaceReference namespaceReference, extension IFormattableDocument document) {
		namespaceReference.regionFor.keyword(namespaceReferenceAccess.fullStopKeyword_2).prepend[noSpace].append[noSpace]
		namespaceReference.innerReference_NamespaceReference.format
	}
	
	def dispatch void format(Variable variable, extension IFormattableDocument document) {
		variable.id_Variable.format
	}
	
	def dispatch void format(FunctionLiteral functionLiteral, extension IFormattableDocument document) {
		functionLiteral.regionFor.keyword(functionLiteralAccess.leftParenthesisKeyword_1).append[noSpace]
		functionLiteral.regionFor.keyword(functionLiteralAccess.rightParenthesisKeyword_3).prepend[noSpace]
		functionLiteral.regionFor.keyword(functionLiteralAccess.commaKeyword_2_1_0).prepend[oneSpace].append[oneSpace]
		
		functionLiteral.parameters_FunctionLiteral.forEach[format]
	}
	
	def dispatch void format(Parenthesis parenthesis, extension IFormattableDocument document) {
		parenthesis.regionFor.keyword(parenthesisAccess.leftParenthesisKeyword_0).append[noSpace; lowPriority]
		parenthesis.regionFor.keyword(parenthesisAccess.rightParenthesisKeyword_2).append[noSpace; lowPriority]
		parenthesis.innerExpression.format
	}
	
	def dispatch void format(ProbabilityFunctionLiteral probabilityFunctionLiteral, extension IFormattableDocument document) {
		probabilityFunctionLiteral.function_ProbabilityFunctionLiteral.format
	}
	
}
