/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.commons.ui.launch;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.core.databinding.observable.sideeffect.ISideEffect;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.palladiosimulator.commons.ui.launch.ObservableLaunchConfigurationAttributeFactory;

public class ObservableLaunchConfigurationAdapter
implements ObservableLaunchConfigurationAttributeFactory {
    protected final Map<String, Consumer<ILaunchConfigurationWorkingCopy>> lcUpdates = new HashMap<String, Consumer<ILaunchConfigurationWorkingCopy>>();
    protected final Map<String, Consumer<ILaunchConfiguration>> mUpdates = new HashMap<String, Consumer<ILaunchConfiguration>>();
    protected final Map<String, Consumer<ILaunchConfigurationWorkingCopy>> defaults = new HashMap<String, Consumer<ILaunchConfigurationWorkingCopy>>();
    protected final Map<String, IObservableValue<?>> observables = new HashMap();
    private ISideEffect dirtyNotificationEffect;
    private Runnable dirtyNotification;
    private volatile boolean isInitialization = false;

    public void notifyWhenDirty(Runnable dirtyNotification) {
        this.dirtyNotification = dirtyNotification;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        if (this.dirtyNotificationEffect != null) {
            this.dirtyNotificationEffect.dispose();
        }
        this.mUpdates.values().forEach(c -> c.accept(configuration));
        this.isInitialization = true;
        this.dirtyNotificationEffect = ISideEffect.create(() -> {
            this.observables.values().forEach(IObservableValue::getValue);
            if (this.dirtyNotification != null && !this.isInitialization) {
                this.dirtyNotification.run();
            }
        });
        this.isInitialization = false;
    }

    public void performApply(ILaunchConfigurationWorkingCopy workingCopy) {
        this.lcUpdates.values().forEach(c -> c.accept(workingCopy));
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        this.defaults.values().forEach(c -> c.accept(configuration));
    }

    @Override
    public IObservableValue<String> createStringAttribute(String id, String defaultValue) {
        return this.createObservableAttribute(id, defaultValue, ILaunchConfigurationWorkingCopy::setAttribute, ILaunchConfiguration::getAttribute);
    }

    @Override
    public IObservableValue<Integer> createIntegerAttribute(String id, int defaultValue) {
        return this.createObservableAttribute(id, defaultValue, ILaunchConfigurationWorkingCopy::setAttribute, ILaunchConfiguration::getAttribute);
    }

    @Override
    public IObservableValue<Boolean> createBooleanAttribute(String id, boolean defaultValue) {
        return this.createObservableAttribute(id, defaultValue, ILaunchConfigurationWorkingCopy::setAttribute, ILaunchConfiguration::getAttribute);
    }

    @Override
    public <T> IObservableValue<T> createFromStringAttribute(String id, T defaultValue, Function<String, T> fromLCConverter, Function<T, String> toLCConverter) {
        ObservableLaunchConfigurationAttributeFactory.AttributeSetter<Object> setter = (lc, i, val) -> lc.setAttribute(i, (String)toLCConverter.apply(val));
        ObservableLaunchConfigurationAttributeFactory.AttributeExtractor<Object> getter = (lc, i, val) -> fromLCConverter.apply(lc.getAttribute(i, (String)toLCConverter.apply(val)));
        return this.createObservableAttribute(id, defaultValue, setter, getter);
    }

    @Override
    public <T> IObservableValue<T> createObservableAttribute(String id, T defaultValue, ObservableLaunchConfigurationAttributeFactory.AttributeSetter<T> setter, ObservableLaunchConfigurationAttributeFactory.AttributeExtractor<T> getter) {
        WritableValue result = new WritableValue(defaultValue, null);
        result.addChangeListener(ev -> this.lcUpdates.put(id, wc -> setter.apply((ILaunchConfigurationWorkingCopy)wc, id, result.getValue())));
        this.mUpdates.put(id, lc -> {
            Object value = defaultValue;
            try {
                value = getter.apply((ILaunchConfiguration)lc, id, defaultValue);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            result.setValue(value);
        });
        this.defaults.put(id, lc -> setter.apply((ILaunchConfigurationWorkingCopy)lc, id, defaultValue));
        this.observables.put(id, (IObservableValue<?>)result);
        result.addDisposeListener(ev -> {
            this.lcUpdates.remove(id);
            this.mUpdates.remove(id);
            this.defaults.remove(id);
            this.observables.remove(id);
        });
        return result;
    }
}

