/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.usagemodel.structure.components;

import java.util.ArrayList;
import java.util.List;
import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.shared.components.VariableUsageCreator;
import org.palladiosimulator.generator.fluent.usagemodel.structure.UsageModelCreator;
import org.palladiosimulator.generator.fluent.usagemodel.structure.UsageModelEntity;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.usagemodel.UsagemodelFactory;
import org.palladiosimulator.pcm.usagemodel.UserData;

public class UserDataCreator
extends UsageModelEntity {
    private AssemblyContext assemblyContext;
    private final List<VariableUsage> variableUsage;

    public UserDataCreator(UsageModelCreator usgModelCreator, AssemblyContext context) {
        this.usageModelCreator = usgModelCreator;
        this.variableUsage = new ArrayList<VariableUsage>();
        this.withAssemblyContext(context);
    }

    public UserDataCreator addToUserData(VariableUsageCreator variable) {
        IllegalArgumentException.throwIfNull(variable, "The given Variable must not be null");
        this.variableUsage.add(variable.build());
        return this;
    }

    private UserDataCreator withAssemblyContext(AssemblyContext context) {
        IllegalArgumentException.throwIfNull(context, "The given AssemblyContext must not be null.");
        this.assemblyContext = context;
        return this;
    }

    public UserData build() {
        UserData usrData = UsagemodelFactory.eINSTANCE.createUserData();
        if (this.assemblyContext != null) {
            usrData.setAssemblyContext_userData(this.assemblyContext);
        }
        usrData.getUserDataParameterUsages_UserData().addAll(this.variableUsage);
        return usrData;
    }
}

