/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.mdsdprofiles.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.modelversioning.emfprofile.Extension;
import org.modelversioning.emfprofile.Profile;
import org.modelversioning.emfprofile.Stereotype;
import org.modelversioning.emfprofileapplication.EMFProfileApplicationPackage;
import org.modelversioning.emfprofileapplication.ProfileApplication;
import org.modelversioning.emfprofileapplication.ProfileImport;
import org.modelversioning.emfprofileapplication.StereotypeApplication;
import org.palladiosimulator.commons.emfutils.EMFLoadHelper;
import org.palladiosimulator.mdsdprofiles.api.ProfileAPI;
import org.palladiosimulator.mdsdprofiles.notifier.MDSDProfilesNotifier;

public class StereotypeAPI {
    private static final List<Integer> EXLUDED_PARAMETER_FEATURE_IDS = Arrays.asList(0, 1, 2);

    public static void applyStereotype(EObject stereotypedElement, Stereotype stereotype) {
        if (!ProfileAPI.hasProfileApplication(stereotypedElement.eResource())) {
            throw new RuntimeException("ApplyStereotype failed: No profile application found!");
        }
        if (!StereotypeAPI.isStereotypeApplicable(stereotypedElement, stereotype)) {
            throw new RuntimeException("ApplyStereotype failed: \"" + stereotype.getName() + "\" is not applicable to \"" + stereotypedElement.getClass().getName() + "\"!");
        }
        if (StereotypeAPI.isStereotypeApplied(stereotypedElement, stereotype)) {
            throw new RuntimeException("ApplyStereotype failed: \"" + stereotype.getName() + "\" already applied to \"" + stereotypedElement.getClass().getName() + "\"!");
        }
        ProfileApplication profileApplication = StereotypeAPI.getProfileApplication(stereotypedElement);
        StereotypeApplication newStereotypeApplication = (StereotypeApplication)stereotype.getEPackage().getEFactoryInstance().create((EClass)stereotype);
        newStereotypeApplication.setAppliedTo(stereotypedElement);
        newStereotypeApplication.setExtension((Extension)stereotype.getApplicableExtensions(stereotypedElement).get(0));
        profileApplication.getStereotypeApplications().add((Object)newStereotypeApplication);
        stereotypedElement.eNotify((Notification)new MDSDProfilesNotifier((Notifier)stereotypedElement, 1002, stereotype));
    }

    public static void applyStereotype(EObject stereotypedElement, String stereotypeName) {
        EList<Stereotype> applicableStereotypes = StereotypeAPI.getApplicableStereotypes(stereotypedElement, stereotypeName);
        if (applicableStereotypes.size() != 1) {
            throw new RuntimeException("ApplyStereotype based on name failed: name \"" + stereotypeName + "\" not uniquely found (" + applicableStereotypes.size() + " times)!");
        }
        StereotypeAPI.applyStereotype(stereotypedElement, (Stereotype)applicableStereotypes.get(0));
    }

    public static boolean updateStereotypeApplications(EObject stereotypedElement, EList<Stereotype> stereotypesToBeApplied) {
        EList<Stereotype> appliedStereotypes = StereotypeAPI.getAppliedStereotypes(stereotypedElement);
        LinkedList<Stereotype> unchanged = new LinkedList<Stereotype>();
        LinkedList<Stereotype> additions = new LinkedList<Stereotype>();
        for (Stereotype stereotype : stereotypesToBeApplied) {
            if (appliedStereotypes.contains(stereotype)) {
                unchanged.add(stereotype);
                continue;
            }
            additions.add(stereotype);
        }
        boolean changed = false;
        for (Stereotype stereotype : appliedStereotypes) {
            if (unchanged.contains(stereotype)) continue;
            StereotypeAPI.unapplyStereotype(stereotypedElement, stereotype);
            changed = true;
        }
        for (Stereotype stereotype : additions) {
            StereotypeAPI.applyStereotype(stereotypedElement, stereotype);
            changed = true;
        }
        return changed;
    }

    public static void setTaggedValue(EObject stereotypedElement, Object newValue, String stereotypeName, String taggedValueName) {
        EList<StereotypeApplication> stereotypeApplications = StereotypeAPI.getStereotypeApplications(stereotypedElement, stereotypeName);
        StereotypeApplication stereotypeApplication = (StereotypeApplication)stereotypeApplications.get(0);
        EStructuralFeature taggedValue = stereotypeApplication.getStereotype().getTaggedValue(taggedValueName);
        stereotypeApplication.eSet(taggedValue, newValue);
        stereotypedElement.eNotify((Notification)new MDSDProfilesNotifier((Notifier)stereotypedElement, 1004, new MDSDProfilesNotifier.TaggedValueTuple(stereotypeName, taggedValueName, newValue)));
    }

    public static boolean isStereotypeApplicable(EObject stereotypedElement, Stereotype stereotype) {
        if (StereotypeAPI.isStereotypeApplied(stereotypedElement, stereotype)) {
            return false;
        }
        for (ProfileImport profileImport : StereotypeAPI.getProfileImports(stereotypedElement)) {
            for (Stereotype applicableStereotype : profileImport.getProfile().getApplicableStereotypes(stereotypedElement.eClass())) {
                if (!EMFLoadHelper.getResourceURI((EObject)applicableStereotype).equals(EMFLoadHelper.getResourceURI((EObject)stereotype))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isStereotypeApplicable(EObject stereotypedElement, String stereotypeName) {
        if (StereotypeAPI.getApplicableStereotypes(stereotypedElement, stereotypeName).size() != 1) {
            throw new RuntimeException("ApplyStereotype based on name failed: name \"" + stereotypeName + "\" not (uniquely) found!");
        }
        return StereotypeAPI.isStereotypeApplicable(stereotypedElement, (Stereotype)StereotypeAPI.getApplicableStereotypes(stereotypedElement, stereotypeName).get(0));
    }

    public static boolean isStereotypeApplied(EObject stereotypedElement, Stereotype stereotype) {
        try {
            StereotypeAPI.getStereotypeApplication(stereotypedElement, stereotype);
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    public static boolean isStereotypeApplied(EObject stereotypedElement, String stereotype) {
        return !StereotypeAPI.getStereotypeApplications(stereotypedElement, stereotype).isEmpty();
    }

    public static boolean hasStereotypeApplications(EObject stereotypedElement) {
        return !new StereotypeApplicationCrossReferencer(stereotypedElement).findStereotypeApplications().isEmpty();
    }

    public static boolean hasAppliedStereotype(Set<? extends EObject> setOfElements, String stereotypeName) {
        for (EObject eObject : setOfElements) {
            if (!StereotypeAPI.isStereotypeApplied(eObject, stereotypeName)) continue;
            return true;
        }
        return false;
    }

    public static EList<Stereotype> getApplicableStereotypes(EObject stereotypedElement) {
        BasicEList applicableStereotypes = new BasicEList();
        for (ProfileImport profileImport : StereotypeAPI.getProfileImports(stereotypedElement)) {
            applicableStereotypes.addAll((Collection)profileImport.getProfile().getApplicableStereotypes(stereotypedElement.eClass()));
        }
        return applicableStereotypes;
    }

    public static EList<Stereotype> getApplicableStereotypes(EObject stereotypedElement, Profile profile) {
        BasicEList filteredStereotypes = new BasicEList();
        for (Stereotype stereotype : StereotypeAPI.getApplicableStereotypes(stereotypedElement)) {
            if (!stereotype.getProfile().getNsURI().equals(profile.getNsURI())) continue;
            filteredStereotypes.add((Object)stereotype);
        }
        return filteredStereotypes;
    }

    public static EList<Stereotype> getApplicableStereotypes(EObject stereotypedElement, String stereotypeName) {
        BasicEList filteredStereotypes = new BasicEList();
        for (Stereotype stereotype : StereotypeAPI.getApplicableStereotypes(stereotypedElement)) {
            if (!stereotype.getName().equals(stereotypeName)) continue;
            filteredStereotypes.add((Object)stereotype);
        }
        return filteredStereotypes;
    }

    public static EList<StereotypeApplication> getStereotypeApplications(EObject stereotypedElement) {
        return new StereotypeApplicationCrossReferencer(stereotypedElement).findStereotypeApplications();
    }

    public static EList<StereotypeApplication> getStereotypeApplications(EObject stereotypedElement, Profile profile) {
        BasicEList filteredStereotypeApplications = new BasicEList();
        for (StereotypeApplication stereotypeApplication : StereotypeAPI.getStereotypeApplications(stereotypedElement)) {
            if (!stereotypeApplication.getStereotype().getProfile().getNsURI().equals(profile.getNsURI())) continue;
            filteredStereotypeApplications.add((Object)stereotypeApplication);
        }
        return filteredStereotypeApplications;
    }

    public static EList<StereotypeApplication> getStereotypeApplications(EObject stereotypedElement, String stereotype) {
        BasicEList filteredStereotypeApplications = new BasicEList();
        for (StereotypeApplication stereotypeApplication : StereotypeAPI.getStereotypeApplications(stereotypedElement)) {
            if (!stereotypeApplication.getStereotype().getName().equals(stereotype)) continue;
            filteredStereotypeApplications.add((Object)stereotypeApplication);
        }
        return filteredStereotypeApplications;
    }

    public static StereotypeApplication getStereotypeApplication(EObject stereotypedElement, Stereotype stereotype) {
        for (StereotypeApplication stereotypeApplication : StereotypeAPI.getStereotypeApplications(stereotypedElement)) {
            if (!EMFLoadHelper.getResourceURI((EObject)stereotypeApplication.getStereotype()).equals(EMFLoadHelper.getResourceURI((EObject)stereotype))) continue;
            return stereotypeApplication;
        }
        throw new RuntimeException("GetStereotypeApplication failed: Stereotype \"" + stereotype.getName() + "\" has not been applied to \"" + stereotypedElement.getClass().getName() + "\"!");
    }

    public static EList<Stereotype> getAppliedStereotypes(EObject stereotypedElement) {
        BasicEList appliedStereotypes = new BasicEList();
        for (StereotypeApplication stereotypeApplication : StereotypeAPI.getStereotypeApplications(stereotypedElement)) {
            appliedStereotypes.add((Object)stereotypeApplication.getStereotype());
        }
        return appliedStereotypes;
    }

    public static <DATA_TYPE> DATA_TYPE getTaggedValue(EObject stereotypedElement, String taggedValueName, String stereotypeName) {
        EList<StereotypeApplication> pcmEntityStereotypeApplications = StereotypeAPI.getStereotypeApplications(stereotypedElement, stereotypeName);
        StereotypeApplication stereotypeApplication = (StereotypeApplication)pcmEntityStereotypeApplications.get(0);
        Stereotype stereotype = stereotypeApplication.getStereotype();
        EStructuralFeature taggedValue = stereotype.getTaggedValue(taggedValueName);
        return (DATA_TYPE)stereotypeApplication.eGet(taggedValue);
    }

    public static <DATA_TYPE> Optional<DATA_TYPE> getTaggedValueSafe(EObject stereotypedElement, String taggedValueName, String stereotypeName) {
        if (stereotypedElement == null || taggedValueName == null || stereotypeName == null) {
            return Optional.empty();
        }
        if (!StereotypeAPI.hasStereotypeApplications(stereotypedElement) || !StereotypeAPI.isStereotypeApplied(stereotypedElement, stereotypeName)) {
            return Optional.empty();
        }
        try {
            StereotypeApplication stereotypeApplication = (StereotypeApplication)StereotypeAPI.getStereotypeApplications(stereotypedElement, stereotypeName).get(0);
            EStructuralFeature taggedValue = stereotypeApplication.getStereotype().getTaggedValue(taggedValueName);
            return Optional.ofNullable(stereotypeApplication.eGet(taggedValue));
        }
        catch (RuntimeException e) {
            return Optional.empty();
        }
    }

    public static void unapplyStereotype(EObject stereotypedElement, Stereotype stereotype) {
        if (!StereotypeAPI.isStereotypeApplied(stereotypedElement, stereotype)) {
            throw new RuntimeException("UnapplyStereotype failed: No application found for Stereotype \"" + stereotype.getName() + "\"!");
        }
        StereotypeApplication stereotypeApplication = StereotypeAPI.getStereotypeApplication(stereotypedElement, stereotype);
        stereotypeApplication.getProfileApplication().getStereotypeApplications().remove((Object)stereotypeApplication);
        stereotypedElement.eNotify((Notification)new MDSDProfilesNotifier((Notifier)stereotypedElement, 1003, stereotype));
    }

    public static void unapplyStereotype(EObject stereotypedElement, String stereotypeName) {
        EList<StereotypeApplication> stereotypeApplications = StereotypeAPI.getStereotypeApplications(stereotypedElement, stereotypeName);
        if (stereotypeApplications.size() != 1) {
            throw new RuntimeException("UnapplyStereotype failed: Stereotype identification by name found " + stereotypeApplications.size() + " fitting stereotypes!");
        }
        StereotypeAPI.unapplyStereotype(stereotypedElement, ((StereotypeApplication)stereotypeApplications.get(0)).getStereotype());
    }

    public static Collection<EStructuralFeature> getParameters(Stereotype stereotype) {
        LinkedList<EStructuralFeature> parameterFeatures = new LinkedList<EStructuralFeature>();
        for (EStructuralFeature eStructuralFeature : stereotype.getEAllStructuralFeatures()) {
            if (EXLUDED_PARAMETER_FEATURE_IDS.contains(eStructuralFeature.getFeatureID())) continue;
            parameterFeatures.add(eStructuralFeature);
        }
        return parameterFeatures;
    }

    public static EStructuralFeature getParameter(Stereotype stereotype, String parameterName) {
        for (EStructuralFeature parameterFeature : StereotypeAPI.getParameters(stereotype)) {
            if (!parameterFeature.getName().equals(parameterName)) continue;
            return parameterFeature;
        }
        throw new RuntimeException("The parameter with name \"" + parameterName + "\" does not exist on the Stereotype \"" + stereotype + "\"");
    }

    private static ProfileApplication getProfileApplication(EObject stereotypedElement) {
        return ProfileAPI.getProfileApplication(stereotypedElement.eResource());
    }

    private static EList<ProfileImport> getProfileImports(EObject stereotypedElement) {
        return StereotypeAPI.getProfileApplication(stereotypedElement).getImportedProfiles();
    }

    private static final class StereotypeApplicationCrossReferencer
    extends EcoreUtil.UsageCrossReferencer {
        private static final EClass STEREOTYPE_APPLICATION_ECLASS = EMFProfileApplicationPackage.eINSTANCE.getStereotypeApplication();
        private static final EClass PROFILE_APPLICATION_ECLASS = EMFProfileApplicationPackage.eINSTANCE.getProfileApplication();
        private static final EReference STEREOTYPE_APPLICATION_APPLIED_TO_EREFERENCE = EMFProfileApplicationPackage.eINSTANCE.getStereotypeApplication_AppliedTo();
        private static final long serialVersionUID = -5714219655560791971L;
        private final EObject referencedObject;

        private StereotypeApplicationCrossReferencer(EObject referencedObject) {
            super(referencedObject.eResource());
            this.referencedObject = referencedObject;
        }

        protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedObject) {
            return this.referencedObject == crossReferencedObject && eReference == STEREOTYPE_APPLICATION_APPLIED_TO_EREFERENCE;
        }

        protected boolean containment(EObject eObject) {
            return eObject.eClass() == PROFILE_APPLICATION_ECLASS || STEREOTYPE_APPLICATION_ECLASS.isSuperTypeOf(eObject.eClass());
        }

        public Collection<EStructuralFeature.Setting> findUsage(EObject eObject) {
            return super.findUsage(eObject);
        }

        public EList<StereotypeApplication> findStereotypeApplications() {
            BasicEList stereotypeApplications = new BasicEList();
            for (EStructuralFeature.Setting setting : this.findUsage(this.referencedObject)) {
                stereotypeApplications.add((Object)((StereotypeApplication)setting.getEObject()));
            }
            return stereotypeApplications;
        }
    }
}

