/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.mdsdprofiles.ui.handlers;

import java.util.LinkedList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.modelversioning.emfprofile.Stereotype;
import org.palladiosimulator.mdsdprofiles.api.ProfileAPI;
import org.palladiosimulator.mdsdprofiles.api.StereotypeAPI;
import org.palladiosimulator.mdsdprofiles.ui.commands.UpdateStereotypeElementsCommand;
import org.palladiosimulator.mdsdprofiles.ui.handlers.AbstractApplyUnapplyHandler;

public class StereotypeApplyUnapplyHandler
extends AbstractApplyUnapplyHandler {
    @Override
    protected void applyUnapplyStateChanged(ExecutionEvent event) throws ExecutionException {
        EObject stereotypedElement = (EObject)StereotypeApplyUnapplyHandler.getTargetElement(event);
        if (!ProfileAPI.hasProfileApplication((Resource)stereotypedElement.eResource())) {
            Status status = new Status(4, "org.palladiosimulator.mdsdprofiles.ui", 0, "No MDSD Profile applied", null);
            ErrorDialog.openError((Shell)HandlerUtil.getActiveShellChecked((ExecutionEvent)event), (String)"MDSD Profiles: Error", (String)"To apply stereotypes, at least one MDSD Profile has to be applied first to the root node", (IStatus)status);
            return;
        }
        EList choiceOfValues = StereotypeAPI.getApplicableStereotypes((EObject)stereotypedElement);
        LinkedList<Stereotype> currentValues = new LinkedList<Stereotype>();
        for (Stereotype applicableStereotype : choiceOfValues) {
            if (!StereotypeAPI.isStereotypeApplied((EObject)stereotypedElement, (Stereotype)applicableStereotype)) continue;
            currentValues.add(applicableStereotype);
        }
        EList updatedStereotypes = StereotypeApplyUnapplyHandler.getUpdatedProfileElementsFromDialog(event, stereotypedElement, currentValues, choiceOfValues, "Select Profile to be applied");
        if (updatedStereotypes != null) {
            UpdateStereotypeElementsCommand command = UpdateStereotypeElementsCommand.create(stereotypedElement, updatedStereotypes);
            StereotypeApplyUnapplyHandler.getEditingDomainFor(stereotypedElement).getCommandStack().execute((Command)command);
        }
    }
}

