/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementsui.abstractviewer;

import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.parsley.viewers.ViewerFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.palladiosimulator.measurementsui.abstractviewer.SaveableComponentViewer;
import org.palladiosimulator.measurementsui.abstractviewer.listener.MeasurementTreeDoubleClickListener;

public abstract class MeasurementsTreeViewer
extends SaveableComponentViewer {
    protected TreeViewer treeViewer;
    protected ViewerFactory treeFactory;

    public MeasurementsTreeViewer(Composite parent, MDirtyable dirty, ECommandService commandService, EObject modelRepository) {
        super(parent, dirty, commandService, modelRepository);
        this.treeViewer.expandToLevel(2);
    }

    public void addMouseListener() {
        this.treeViewer.getTree().addMouseListener((MouseListener)new MeasurementTreeDoubleClickListener(this.treeViewer));
    }

    @Override
    public StructuredViewer getViewer() {
        return this.treeViewer;
    }

    @Override
    public void addSelectionListener(ESelectionService selectionService) {
        this.treeViewer.addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            selectionService.setSelection((Object)(selection.size() == 1 ? selection.getFirstElement() : selection.toArray()));
        });
    }

    @Override
    protected void initParsley(Composite parent) {
        this.treeViewer = new TreeViewer(parent);
        this.treeFactory = (ViewerFactory)this.injector.getInstance(ViewerFactory.class);
        this.update(this.modelRepository);
    }

    @Override
    public void update(EObject modelRepository) {
        this.setModelRepository(modelRepository);
        Object[] expandedElements = this.treeViewer.getExpandedElements();
        this.initEditingDomain();
        this.getModelRepository().ifPresent(modelRepositoryOfOptional -> {
            Resource resource = this.resource = this.updateResource((EObject)modelRepositoryOfOptional);
        });
        this.treeFactory.initialize((StructuredViewer)this.treeViewer, (Object)this.resource);
        this.treeViewer.setAutoExpandLevel(1);
        this.treeViewer.setExpandedElements(expandedElements);
        if (this.treeViewer.getExpandedElements().length == 0) {
            this.treeViewer.expandToLevel(2);
        }
        this.treeViewer.refresh();
    }

    @Override
    public void update() {
        this.treeViewer.refresh();
    }
}

