/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementsui.wizard.pages;

import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.palladiosimulator.measurementsui.wizard.handlers.editingsupport.ProcessingTypeDropDownEditingSupport;
import org.palladiosimulator.measurementsui.wizard.handlers.editingsupport.ProcessingTypePropertyEditingSupport;
import org.palladiosimulator.measurementsui.wizard.handlers.labelprovider.ProcessingTypeSelectionLabelProvider;
import org.palladiosimulator.measurementsui.wizard.viewer.ProcessingTypeSelectionViewer;
import org.palladiosimulator.measurementsui.wizardmodel.pages.ProcessingTypeSelectionWizardModel;

public class ProcessingTypeSelectionWizardPage
extends WizardPage {
    private static final String COLUMN_TEXT_METRIC_DESCRIPTION = "Metric Description";
    private static final String COLUMN_TEXT_PROCESSING_TYPE = "Processing Type";
    private static final String COLUMN_TEXT_PROPERTY1 = "Property Value 1";
    private static final String COLUMN_TEXT_PROPERTY2 = "Property Value 2";
    private ProcessingTypeSelectionWizardModel processingTypeSelectionWizardModel;

    public ProcessingTypeSelectionWizardPage(ProcessingTypeSelectionWizardModel processingTypeSelectionWizardModel) {
        super("wizardPage");
        this.processingTypeSelectionWizardModel = processingTypeSelectionWizardModel;
        this.setTitle(processingTypeSelectionWizardModel.getTitleText());
        this.setDescription(processingTypeSelectionWizardModel.getInfoText());
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 4);
        FillLayout fillLayoutParentContainer = new FillLayout();
        container.setLayout((Layout)fillLayoutParentContainer);
        this.setControl((Control)container);
        ProcessingTypeSelectionViewer measurementSpecificationViewer = new ProcessingTypeSelectionViewer(container, this.processingTypeSelectionWizardModel.getUsedMetricsMonitor());
        TableViewer tableViewer = (TableViewer)measurementSpecificationViewer.getViewer();
        tableViewer.setLabelProvider((IBaseLabelProvider)new ProcessingTypeSelectionLabelProvider(this.processingTypeSelectionWizardModel));
        this.setColumnsText(tableViewer);
        this.setEditingSupports(tableViewer);
    }

    private void setEditingSupports(TableViewer tableViewer) {
        TableViewerColumn[] tableViewerColumns = this.getTableViewerColumns(tableViewer);
        tableViewerColumns[1].setEditingSupport((EditingSupport)new ProcessingTypeDropDownEditingSupport(tableViewerColumns[1].getViewer(), tableViewer, this.processingTypeSelectionWizardModel));
        tableViewerColumns[2].setEditingSupport((EditingSupport)new ProcessingTypePropertyEditingSupport(tableViewerColumns[2].getViewer(), tableViewer, this.processingTypeSelectionWizardModel, 0));
        tableViewerColumns[3].setEditingSupport((EditingSupport)new ProcessingTypePropertyEditingSupport(tableViewerColumns[3].getViewer(), tableViewer, this.processingTypeSelectionWizardModel, 1));
    }

    private void setColumnsText(TableViewer tableViewer) {
        tableViewer.getTable().getColumn(0).setText(COLUMN_TEXT_METRIC_DESCRIPTION);
        tableViewer.getTable().getColumn(1).setText(COLUMN_TEXT_PROCESSING_TYPE);
        tableViewer.getTable().getColumn(2).setText(COLUMN_TEXT_PROPERTY1);
        tableViewer.getTable().getColumn(3).setText(COLUMN_TEXT_PROPERTY2);
    }

    private TableViewerColumn[] getTableViewerColumns(TableViewer tableViewer) {
        TableColumn[] columns = tableViewer.getTable().getColumns();
        TableViewerColumn[] viewerColumns = new TableViewerColumn[columns.length];
        int i = 0;
        while (i < columns.length) {
            TableColumn tableColumn = columns[i];
            viewerColumns[i] = (TableViewerColumn)tableColumn.getData("org.eclipse.jface.columnViewer");
            ++i;
        }
        return viewerColumns;
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public void performHelp() {
        Program.launch((String)"https://sdqweb.ipd.kit.edu/wiki/SimuLizar_Usability_Extension#Processing_Type_Selection_Page");
    }
}

