/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.monitorrepository.statisticalcharacterization;

import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.measure.Measure;
import javax.measure.quantity.Duration;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;
import org.jscience.physics.amount.Amount;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.metricspec.NumericalBaseMetricDescription;
import org.palladiosimulator.monitorrepository.statisticalcharacterization.StatisticalCharacterizationAggregator;

public class HarmonicMeanAggregator
extends StatisticalCharacterizationAggregator {
    public HarmonicMeanAggregator(NumericalBaseMetricDescription expectedWindowMetric) {
        super(expectedWindowMetric);
    }

    @Override
    protected Measure<Double, Quantity> calculateStatisticalCharaterizationDiscrete(Iterable<MeasuringValue> windowData) {
        double arithmeticMeanOfInverses = StreamSupport.stream(windowData.spliterator(), false).collect(Collectors.averagingDouble(measurement -> 1.0 / this.obtainDataValueFromMeasurement((MeasuringValue)measurement)));
        return Measure.valueOf((double)(arithmeticMeanOfInverses == Double.NaN || arithmeticMeanOfInverses == 0.0 ? 0.0 : 1.0 / arithmeticMeanOfInverses), super.getDataDefaultUnit());
    }

    @Override
    protected Measure<Double, Quantity> calculateStatisticalCharacterizationContinuous(Iterable<MeasuringValue> windowData) {
        Measure harmonicMean = Measure.valueOf((double)0.0, super.getDataDefaultUnit());
        Iterator<MeasuringValue> iterator = windowData.iterator();
        if (iterator.hasNext()) {
            Amount area = Amount.valueOf((double)0.0, (Unit)Duration.UNIT.divide(super.getDataDefaultUnit()));
            MeasuringValue currentMeasurement = iterator.next();
            Optional<Object> nextMeasurement = null;
            do {
                nextMeasurement = iterator.hasNext() ? Optional.of(iterator.next()) : Optional.empty();
                area = area.plus(this.obtainCurrentMeasurementValidityLength(currentMeasurement, nextMeasurement).divide(this.obtainDataFromMeasurement(currentMeasurement)));
                if (!nextMeasurement.isPresent()) continue;
                currentMeasurement = nextMeasurement.get();
            } while (nextMeasurement.isPresent());
            Amount harmonicMeanAmount = super.getIntervalLength().divide(area);
            harmonicMean = Measure.valueOf((double)harmonicMeanAmount.doubleValue(super.getDataDefaultUnit()), super.getDataDefaultUnit());
        }
        return harmonicMean;
    }
}

