/**
 */
package org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification;

import org.eclipse.emf.common.util.EList;

import org.palladiosimulator.pcm.confidentiality.context.policy.Policy;

import org.palladiosimulator.pcm.confidentiality.context.system.UsageSpecification;

import org.palladiosimulator.pcm.core.entity.Entity;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Vulnerability</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.Vulnerability#getAttackVector <em>Attack Vector</em>}</li>
 *   <li>{@link org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.Vulnerability#getAttackComplexity <em>Attack Complexity</em>}</li>
 *   <li>{@link org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.Vulnerability#getPrivileges <em>Privileges</em>}</li>
 *   <li>{@link org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.Vulnerability#getUserInteraction <em>User Interaction</em>}</li>
 *   <li>{@link org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.Vulnerability#getRequiredCredentials <em>Required Credentials</em>}</li>
 *   <li>{@link org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.Vulnerability#getConfidentialityImpact <em>Confidentiality Impact</em>}</li>
 *   <li>{@link org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.Vulnerability#getIntegrityImpact <em>Integrity Impact</em>}</li>
 *   <li>{@link org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.Vulnerability#getAvailabilityImpact <em>Availability Impact</em>}</li>
 *   <li>{@link org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.Vulnerability#getGainedAttributes <em>Gained Attributes</em>}</li>
 *   <li>{@link org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.Vulnerability#isTakeOver <em>Take Over</em>}</li>
 *   <li>{@link org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.Vulnerability#getRole <em>Role</em>}</li>
 * </ul>
 *
 * @see org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.AttackSpecificationPackage#getVulnerability()
 * @model abstract="true"
 * @generated
 */
public interface Vulnerability extends Entity
{
	/**
	 * Returns the value of the '<em><b>Attack Vector</b></em>' attribute.
	 * The default value is <code>"Network"</code>.
	 * The literals are from the enumeration {@link org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.AttackVector}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Attack Vector</em>' attribute.
	 * @see org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.AttackVector
	 * @see #setAttackVector(AttackVector)
	 * @see org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.AttackSpecificationPackage#getVulnerability_AttackVector()
	 * @model default="Network" required="true"
	 * @generated
	 */
	AttackVector getAttackVector();

	/**
	 * Sets the value of the '{@link org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.Vulnerability#getAttackVector <em>Attack Vector</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Attack Vector</em>' attribute.
	 * @see org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.AttackVector
	 * @see #getAttackVector()
	 * @generated
	 */
	void setAttackVector(AttackVector value);

	/**
	 * Returns the value of the '<em><b>Attack Complexity</b></em>' attribute.
	 * The default value is <code>"Low"</code>.
	 * The literals are from the enumeration {@link org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.AttackComplexity}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Attack Complexity</em>' attribute.
	 * @see org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.AttackComplexity
	 * @see #setAttackComplexity(AttackComplexity)
	 * @see org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.AttackSpecificationPackage#getVulnerability_AttackComplexity()
	 * @model default="Low" required="true"
	 * @generated
	 */
	AttackComplexity getAttackComplexity();

	/**
	 * Sets the value of the '{@link org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.Vulnerability#getAttackComplexity <em>Attack Complexity</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Attack Complexity</em>' attribute.
	 * @see org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.AttackComplexity
	 * @see #getAttackComplexity()
	 * @generated
	 */
	void setAttackComplexity(AttackComplexity value);

	/**
	 * Returns the value of the '<em><b>Privileges</b></em>' attribute.
	 * The default value is <code>"None"</code>.
	 * The literals are from the enumeration {@link org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.Privileges}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Privileges</em>' attribute.
	 * @see org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.Privileges
	 * @see #setPrivileges(Privileges)
	 * @see org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.AttackSpecificationPackage#getVulnerability_Privileges()
	 * @model default="None" required="true"
	 * @generated
	 */
	Privileges getPrivileges();

	/**
	 * Sets the value of the '{@link org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.Vulnerability#getPrivileges <em>Privileges</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Privileges</em>' attribute.
	 * @see org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.Privileges
	 * @see #getPrivileges()
	 * @generated
	 */
	void setPrivileges(Privileges value);

	/**
	 * Returns the value of the '<em><b>User Interaction</b></em>' attribute.
	 * The default value is <code>"None"</code>.
	 * The literals are from the enumeration {@link org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.UserInteraction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>User Interaction</em>' attribute.
	 * @see org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.UserInteraction
	 * @see #setUserInteraction(UserInteraction)
	 * @see org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.AttackSpecificationPackage#getVulnerability_UserInteraction()
	 * @model default="None" required="true"
	 * @generated
	 */
	UserInteraction getUserInteraction();

	/**
	 * Sets the value of the '{@link org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.Vulnerability#getUserInteraction <em>User Interaction</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>User Interaction</em>' attribute.
	 * @see org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.UserInteraction
	 * @see #getUserInteraction()
	 * @generated
	 */
	void setUserInteraction(UserInteraction value);

	/**
	 * Returns the value of the '<em><b>Required Credentials</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Required Credentials</em>' reference.
	 * @see #setRequiredCredentials(Policy)
	 * @see org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.AttackSpecificationPackage#getVulnerability_RequiredCredentials()
	 * @model
	 * @generated
	 */
	Policy getRequiredCredentials();

	/**
	 * Sets the value of the '{@link org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.Vulnerability#getRequiredCredentials <em>Required Credentials</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Required Credentials</em>' reference.
	 * @see #getRequiredCredentials()
	 * @generated
	 */
	void setRequiredCredentials(Policy value);

	/**
	 * Returns the value of the '<em><b>Confidentiality Impact</b></em>' attribute.
	 * The default value is <code>"None"</code>.
	 * The literals are from the enumeration {@link org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.ConfidentialityImpact}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Confidentiality Impact</em>' attribute.
	 * @see org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.ConfidentialityImpact
	 * @see #setConfidentialityImpact(ConfidentialityImpact)
	 * @see org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.AttackSpecificationPackage#getVulnerability_ConfidentialityImpact()
	 * @model default="None" required="true"
	 * @generated
	 */
	ConfidentialityImpact getConfidentialityImpact();

	/**
	 * Sets the value of the '{@link org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.Vulnerability#getConfidentialityImpact <em>Confidentiality Impact</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Confidentiality Impact</em>' attribute.
	 * @see org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.ConfidentialityImpact
	 * @see #getConfidentialityImpact()
	 * @generated
	 */
	void setConfidentialityImpact(ConfidentialityImpact value);

	/**
	 * Returns the value of the '<em><b>Integrity Impact</b></em>' attribute.
	 * The default value is <code>"None"</code>.
	 * The literals are from the enumeration {@link org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.IntegrityImpact}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Integrity Impact</em>' attribute.
	 * @see org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.IntegrityImpact
	 * @see #setIntegrityImpact(IntegrityImpact)
	 * @see org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.AttackSpecificationPackage#getVulnerability_IntegrityImpact()
	 * @model default="None" required="true"
	 * @generated
	 */
	IntegrityImpact getIntegrityImpact();

	/**
	 * Sets the value of the '{@link org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.Vulnerability#getIntegrityImpact <em>Integrity Impact</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Integrity Impact</em>' attribute.
	 * @see org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.IntegrityImpact
	 * @see #getIntegrityImpact()
	 * @generated
	 */
	void setIntegrityImpact(IntegrityImpact value);

	/**
	 * Returns the value of the '<em><b>Availability Impact</b></em>' attribute.
	 * The default value is <code>"None"</code>.
	 * The literals are from the enumeration {@link org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.AvailabilityImpact}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Availability Impact</em>' attribute.
	 * @see org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.AvailabilityImpact
	 * @see #setAvailabilityImpact(AvailabilityImpact)
	 * @see org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.AttackSpecificationPackage#getVulnerability_AvailabilityImpact()
	 * @model default="None" required="true"
	 * @generated
	 */
	AvailabilityImpact getAvailabilityImpact();

	/**
	 * Sets the value of the '{@link org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.Vulnerability#getAvailabilityImpact <em>Availability Impact</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Availability Impact</em>' attribute.
	 * @see org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.AvailabilityImpact
	 * @see #getAvailabilityImpact()
	 * @generated
	 */
	void setAvailabilityImpact(AvailabilityImpact value);

	/**
	 * Returns the value of the '<em><b>Gained Attributes</b></em>' reference list.
	 * The list contents are of type {@link org.palladiosimulator.pcm.confidentiality.context.system.UsageSpecification}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Gained Attributes</em>' reference list.
	 * @see org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.AttackSpecificationPackage#getVulnerability_GainedAttributes()
	 * @model
	 * @generated
	 */
	EList<UsageSpecification> getGainedAttributes();

	/**
	 * Returns the value of the '<em><b>Take Over</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Take Over</em>' attribute.
	 * @see #setTakeOver(boolean)
	 * @see org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.AttackSpecificationPackage#getVulnerability_TakeOver()
	 * @model
	 * @generated
	 */
	boolean isTakeOver();

	/**
	 * Sets the value of the '{@link org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.Vulnerability#isTakeOver <em>Take Over</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Take Over</em>' attribute.
	 * @see #isTakeOver()
	 * @generated
	 */
	void setTakeOver(boolean value);

	/**
	 * Returns the value of the '<em><b>Role</b></em>' containment reference list.
	 * The list contents are of type {@link org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.Role}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Role</em>' containment reference list.
	 * @see org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.AttackSpecificationPackage#getVulnerability_Role()
	 * @model containment="true"
	 * @generated
	 */
	EList<Role> getRole();

} // Vulnerability
