/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.pcm.confidentiality.context.helper;

import de.uka.ipd.sdq.identifier.Identifier;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.palladiosimulator.pcm.confidentiality.context.system.SystemFactory;
import org.palladiosimulator.pcm.confidentiality.context.system.UsageSpecification;
import org.palladiosimulator.pcm.confidentiality.context.systemcontext.Attribute;
import org.palladiosimulator.pcm.confidentiality.context.systemcontext.AttributeValue;
import org.palladiosimulator.pcm.confidentiality.context.systemcontext.DataTypes;
import org.palladiosimulator.pcm.confidentiality.context.systemcontext.EnvironmentSubject;
import org.palladiosimulator.pcm.confidentiality.context.systemcontext.SimpleAttribute;
import org.palladiosimulator.pcm.confidentiality.context.systemcontext.SystemEntityAttribute;
import org.palladiosimulator.pcm.confidentiality.context.systemcontext.SystemcontextFactory;
import org.palladiosimulator.pcm.confidentiality.context.systemcontext.XMLAttribute;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.repository.Signature;

public class PolicyHelper {
    private PolicyHelper() {
        assert (false);
    }

    public static void createRequestAttributes(Deque<? extends Entity> requestedEntity, List<? extends UsageSpecification> requestorContext, List<UsageSpecification> listSubject, List<UsageSpecification> listEnvironment, List<UsageSpecification> listResource, List<UsageSpecification> listXML) {
        for (UsageSpecification usageSpecification : requestorContext) {
            Attribute attribute = usageSpecification.getAttribute();
            if (attribute instanceof EnvironmentSubject) {
                EnvironmentSubject environment = (EnvironmentSubject)attribute;
                if (environment.isEnvironment()) {
                    listEnvironment.add(usageSpecification);
                    continue;
                }
                listSubject.add(usageSpecification);
                continue;
            }
            if (attribute instanceof SystemEntityAttribute) {
                SystemEntityAttribute systemEntity = (SystemEntityAttribute)attribute;
                if (EcoreUtil.equals((EObject)systemEntity.getModelEntity(), (EObject)((EObject)requestedEntity.getFirst()))) {
                    listResource.add(usageSpecification);
                    continue;
                }
                listEnvironment.add(usageSpecification);
                continue;
            }
            if (!(attribute instanceof XMLAttribute)) continue;
            listXML.add(usageSpecification);
        }
        listResource.add(PolicyHelper.createResourceUsageSpecification(requestedEntity));
    }

    public static void createRequestAttributes(Signature signature, Deque<? extends Entity> component, List<? extends UsageSpecification> requestorContext, List<UsageSpecification> listSubject, List<UsageSpecification> listEnvironment, List<UsageSpecification> listResource, List<UsageSpecification> listAction, List<UsageSpecification> listXML) {
        PolicyHelper.createRequestAttributes(component, requestorContext, listSubject, listEnvironment, listResource, listXML);
        listAction.add(PolicyHelper.createActionUsageSpecification(signature));
    }

    private static UsageSpecification createResourceUsageSpecification(Deque<? extends Entity> component) {
        UsageSpecification usage = SystemFactory.eINSTANCE.createUsageSpecification();
        SimpleAttribute attribute = SystemcontextFactory.eINSTANCE.createSimpleAttribute();
        AttributeValue value = SystemcontextFactory.eINSTANCE.createAttributeValue();
        attribute.setId("urn:oasis:names:tc:xacml:1.0:resource:resource-id");
        value.setType(DataTypes.STRING);
        String valueString = component.stream().map(Identifier::getId).collect(Collectors.joining(" ", "", " " + component.getLast().getEntityName())).strip();
        value.getValues().add(valueString);
        attribute.getAttributevalue().add(value);
        usage.setEntityName(component.getLast().getEntityName());
        usage.setAttribute(attribute);
        usage.setAttributevalue(value);
        return usage;
    }

    private static UsageSpecification createActionUsageSpecification(Signature signature) {
        UsageSpecification usage = SystemFactory.eINSTANCE.createUsageSpecification();
        SimpleAttribute attribute = SystemcontextFactory.eINSTANCE.createSimpleAttribute();
        AttributeValue value = SystemcontextFactory.eINSTANCE.createAttributeValue();
        attribute.setId("urn:oasis:names:tc:xacml:1.0:action:action-id");
        value.setType(DataTypes.STRING);
        value.getValues().add(signature.getId());
        attribute.getAttributevalue().add(value);
        usage.setAttribute(attribute);
        usage.setAttributevalue(value);
        return usage;
    }
}

