/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.pcm.reliability.util;

import de.uka.ipd.sdq.identifier.Identifier;
import de.uka.ipd.sdq.identifier.util.IdentifierValidator;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.palladiosimulator.pcm.reliability.ExternalFailureOccurrenceDescription;
import org.palladiosimulator.pcm.reliability.FailureOccurrenceDescription;
import org.palladiosimulator.pcm.reliability.FailureType;
import org.palladiosimulator.pcm.reliability.HardwareInducedFailureType;
import org.palladiosimulator.pcm.reliability.InternalFailureOccurrenceDescription;
import org.palladiosimulator.pcm.reliability.NetworkInducedFailureType;
import org.palladiosimulator.pcm.reliability.ReliabilityPackage;
import org.palladiosimulator.pcm.reliability.ResourceTimeoutFailureType;
import org.palladiosimulator.pcm.reliability.SoftwareInducedFailureType;

public class ReliabilityValidator
extends EObjectValidator {
    public static final String copyright = "Copyright 2005-2017 by palladiosimulator.org";
    public static final ReliabilityValidator INSTANCE = new ReliabilityValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.palladiosimulator.pcm.reliability";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected IdentifierValidator identifierValidator = IdentifierValidator.INSTANCE;
    protected static final String FAILURE_OCCURRENCE_DESCRIPTION__ENSURE_VALID_FAILURE_PROBABILITY_RANGE__EEXPRESSION = "(self.failureProbability.oclAsType(Real) <= 1.0) and (self.failureProbability.oclAsType(Real) >= 0.0)";
    protected static final String HARDWARE_INDUCED_FAILURE_TYPE__HARDWARE_INDUCED_FAILURE_TYPE_HAS_PROCESSING_RESOURCE_TYPE__EEXPRESSION = "( self.processingResourceType__HardwareInducedFailureType <> null ) and ( not ( self.processingResourceType__HardwareInducedFailureType.oclIsTypeOf( pcm::resourcetype::CommunicationLinkResourceType ) ) )";
    protected static final String INTERNAL_FAILURE_OCCURRENCE_DESCRIPTION__NO_RESOURCE_TIMEOUT_FAILURE_ALLOWED_FOR_INTERNAL_FAILURE_OCCURRENCE_DESCRIPTION__EEXPRESSION = "not self.softwareInducedFailureType__InternalFailureOccurrenceDescription.oclIsTypeOf(ResourceTimeoutFailureType)";
    protected static final String NETWORK_INDUCED_FAILURE_TYPE__NETWORK_INDUCED_FAILURE_TYPE_HAS_COMMUNICATION_LINK_RESOURCE_TYPE__EEXPRESSION = "self.communicationLinkResourceType__NetworkInducedFailureType <> null";
    protected static final String EXTERNAL_FAILURE_OCCURRENCE_DESCRIPTION__NO_RESOURCE_TIMEOUT_FAILURE_ALLOWED_FOR_EXTERNAL_FAILURE_OCCURRENCE_DESCRIPTION__EEXPRESSION = "not self.failureType__ExternalFailureOccurrenceDescription.oclIsTypeOf(ResourceTimeoutFailureType)";

    protected EPackage getEPackage() {
        return ReliabilityPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateFailureOccurrenceDescription((FailureOccurrenceDescription)value, diagnostics, context);
            }
            case 1: {
                return this.validateHardwareInducedFailureType((HardwareInducedFailureType)value, diagnostics, context);
            }
            case 2: {
                return this.validateSoftwareInducedFailureType((SoftwareInducedFailureType)value, diagnostics, context);
            }
            case 3: {
                return this.validateInternalFailureOccurrenceDescription((InternalFailureOccurrenceDescription)value, diagnostics, context);
            }
            case 4: {
                return this.validateNetworkInducedFailureType((NetworkInducedFailureType)value, diagnostics, context);
            }
            case 5: {
                return this.validateExternalFailureOccurrenceDescription((ExternalFailureOccurrenceDescription)value, diagnostics, context);
            }
            case 6: {
                return this.validateResourceTimeoutFailureType((ResourceTimeoutFailureType)value, diagnostics, context);
            }
            case 7: {
                return this.validateFailureType((FailureType)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateFailureOccurrenceDescription(FailureOccurrenceDescription failureOccurrenceDescription, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(failureOccurrenceDescription, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(failureOccurrenceDescription, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(failureOccurrenceDescription, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(failureOccurrenceDescription, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(failureOccurrenceDescription, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(failureOccurrenceDescription, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(failureOccurrenceDescription, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(failureOccurrenceDescription, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(failureOccurrenceDescription, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFailureOccurrenceDescription_ensureValidFailureProbabilityRange(failureOccurrenceDescription, diagnostics, context);
        }
        return result;
    }

    public boolean validateFailureOccurrenceDescription_ensureValidFailureProbabilityRange(FailureOccurrenceDescription failureOccurrenceDescription, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ReliabilityPackage.Literals.FAILURE_OCCURRENCE_DESCRIPTION, failureOccurrenceDescription, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "ensureValidFailureProbabilityRange", FAILURE_OCCURRENCE_DESCRIPTION__ENSURE_VALID_FAILURE_PROBABILITY_RANGE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateHardwareInducedFailureType(HardwareInducedFailureType hardwareInducedFailureType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(hardwareInducedFailureType, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(hardwareInducedFailureType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(hardwareInducedFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(hardwareInducedFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(hardwareInducedFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(hardwareInducedFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(hardwareInducedFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(hardwareInducedFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(hardwareInducedFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)hardwareInducedFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateHardwareInducedFailureType_hardwareInducedFailureTypeHasProcessingResourceType(hardwareInducedFailureType, diagnostics, context);
        }
        return result;
    }

    public boolean validateHardwareInducedFailureType_hardwareInducedFailureTypeHasProcessingResourceType(HardwareInducedFailureType hardwareInducedFailureType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ReliabilityPackage.Literals.HARDWARE_INDUCED_FAILURE_TYPE, hardwareInducedFailureType, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "hardwareInducedFailureTypeHasProcessingResourceType", HARDWARE_INDUCED_FAILURE_TYPE__HARDWARE_INDUCED_FAILURE_TYPE_HAS_PROCESSING_RESOURCE_TYPE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateSoftwareInducedFailureType(SoftwareInducedFailureType softwareInducedFailureType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(softwareInducedFailureType, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(softwareInducedFailureType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(softwareInducedFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(softwareInducedFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(softwareInducedFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(softwareInducedFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(softwareInducedFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(softwareInducedFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(softwareInducedFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)softwareInducedFailureType, diagnostics, context);
        }
        return result;
    }

    public boolean validateInternalFailureOccurrenceDescription(InternalFailureOccurrenceDescription internalFailureOccurrenceDescription, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(internalFailureOccurrenceDescription, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(internalFailureOccurrenceDescription, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(internalFailureOccurrenceDescription, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(internalFailureOccurrenceDescription, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(internalFailureOccurrenceDescription, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(internalFailureOccurrenceDescription, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(internalFailureOccurrenceDescription, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(internalFailureOccurrenceDescription, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(internalFailureOccurrenceDescription, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFailureOccurrenceDescription_ensureValidFailureProbabilityRange(internalFailureOccurrenceDescription, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateInternalFailureOccurrenceDescription_noResourceTimeoutFailureAllowedForInternalFailureOccurrenceDescription(internalFailureOccurrenceDescription, diagnostics, context);
        }
        return result;
    }

    public boolean validateInternalFailureOccurrenceDescription_noResourceTimeoutFailureAllowedForInternalFailureOccurrenceDescription(InternalFailureOccurrenceDescription internalFailureOccurrenceDescription, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ReliabilityPackage.Literals.INTERNAL_FAILURE_OCCURRENCE_DESCRIPTION, internalFailureOccurrenceDescription, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "noResourceTimeoutFailureAllowedForInternalFailureOccurrenceDescription", INTERNAL_FAILURE_OCCURRENCE_DESCRIPTION__NO_RESOURCE_TIMEOUT_FAILURE_ALLOWED_FOR_INTERNAL_FAILURE_OCCURRENCE_DESCRIPTION__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateNetworkInducedFailureType(NetworkInducedFailureType networkInducedFailureType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(networkInducedFailureType, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(networkInducedFailureType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(networkInducedFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(networkInducedFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(networkInducedFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(networkInducedFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(networkInducedFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(networkInducedFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(networkInducedFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)networkInducedFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNetworkInducedFailureType_networkInducedFailureTypeHasCommunicationLinkResourceType(networkInducedFailureType, diagnostics, context);
        }
        return result;
    }

    public boolean validateNetworkInducedFailureType_networkInducedFailureTypeHasCommunicationLinkResourceType(NetworkInducedFailureType networkInducedFailureType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ReliabilityPackage.Literals.NETWORK_INDUCED_FAILURE_TYPE, networkInducedFailureType, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "networkInducedFailureTypeHasCommunicationLinkResourceType", NETWORK_INDUCED_FAILURE_TYPE__NETWORK_INDUCED_FAILURE_TYPE_HAS_COMMUNICATION_LINK_RESOURCE_TYPE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateExternalFailureOccurrenceDescription(ExternalFailureOccurrenceDescription externalFailureOccurrenceDescription, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(externalFailureOccurrenceDescription, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(externalFailureOccurrenceDescription, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(externalFailureOccurrenceDescription, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(externalFailureOccurrenceDescription, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(externalFailureOccurrenceDescription, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(externalFailureOccurrenceDescription, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(externalFailureOccurrenceDescription, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(externalFailureOccurrenceDescription, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(externalFailureOccurrenceDescription, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFailureOccurrenceDescription_ensureValidFailureProbabilityRange(externalFailureOccurrenceDescription, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateExternalFailureOccurrenceDescription_noResourceTimeoutFailureAllowedForExternalFailureOccurrenceDescription(externalFailureOccurrenceDescription, diagnostics, context);
        }
        return result;
    }

    public boolean validateExternalFailureOccurrenceDescription_noResourceTimeoutFailureAllowedForExternalFailureOccurrenceDescription(ExternalFailureOccurrenceDescription externalFailureOccurrenceDescription, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ReliabilityPackage.Literals.EXTERNAL_FAILURE_OCCURRENCE_DESCRIPTION, externalFailureOccurrenceDescription, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "noResourceTimeoutFailureAllowedForExternalFailureOccurrenceDescription", EXTERNAL_FAILURE_OCCURRENCE_DESCRIPTION__NO_RESOURCE_TIMEOUT_FAILURE_ALLOWED_FOR_EXTERNAL_FAILURE_OCCURRENCE_DESCRIPTION__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateResourceTimeoutFailureType(ResourceTimeoutFailureType resourceTimeoutFailureType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(resourceTimeoutFailureType, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(resourceTimeoutFailureType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(resourceTimeoutFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(resourceTimeoutFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(resourceTimeoutFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(resourceTimeoutFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(resourceTimeoutFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(resourceTimeoutFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(resourceTimeoutFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)resourceTimeoutFailureType, diagnostics, context);
        }
        return result;
    }

    public boolean validateFailureType(FailureType failureType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(failureType, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(failureType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(failureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(failureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(failureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(failureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(failureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(failureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(failureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)failureType, diagnostics, context);
        }
        return result;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

