/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.probeframework.probes;

import java.util.LinkedList;
import java.util.List;
import javax.measure.quantity.Quantity;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.measureprovider.IMeasureProvider;
import org.palladiosimulator.measurementframework.measureprovider.MeasurementListMeasureProvider;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.probeframework.measurement.ProbeMeasurement;
import org.palladiosimulator.probeframework.measurement.RequestContext;
import org.palladiosimulator.probeframework.probes.EventProbe;
import org.palladiosimulator.probeframework.probes.TriggeredProbe;
import org.palladiosimulator.probeframework.probes.listener.IProbeListener;

public class EventProbeList
extends EventProbe<EventProbe<?>>
implements IProbeListener {
    private final List<TriggeredProbe> subsumedProbes;

    public <EventSourceType, V, Q extends Quantity> EventProbeList(MetricDescription metricSetDescription, EventProbe<?> eventProbe, List<TriggeredProbe> subsumedProbes) {
        super(metricSetDescription, eventProbe);
        this.subsumedProbes = subsumedProbes;
    }

    @Override
    public void newProbeMeasurementAvailable(ProbeMeasurement measurement) {
        LinkedList<MeasuringValue> eventAndChildMeasurements = new LinkedList<MeasuringValue>();
        if (!(measurement.getMeasureProvider() instanceof MeasuringValue)) {
            throw new IllegalArgumentException("Event measure providers have to be measurements");
        }
        eventAndChildMeasurements.add((MeasuringValue)measurement.getMeasureProvider());
        for (TriggeredProbe childProbe : this.subsumedProbes) {
            IMeasureProvider subsumedMeasureProvider = childProbe.doMeasure(RequestContext.EMPTY_REQUEST_CONTEXT).getMeasureProvider();
            if (!(subsumedMeasureProvider instanceof MeasuringValue)) {
                throw new IllegalArgumentException("Subsumed measure providers have to be measurements");
            }
            eventAndChildMeasurements.add((MeasuringValue)subsumedMeasureProvider);
        }
        MeasurementListMeasureProvider measureProvider = new MeasurementListMeasureProvider(eventAndChildMeasurements);
        this.notifyMeasurementSourceListener(new ProbeMeasurement((IMeasureProvider)measureProvider, this, RequestContext.EMPTY_REQUEST_CONTEXT));
    }

    @Override
    protected void registerListener() {
        ((EventProbe)this.eventSource).addObserver(this);
    }
}

