/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.probeframework.probes;

import de.uka.ipd.sdq.identifier.Identifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.measureprovider.IMeasureProvider;
import org.palladiosimulator.measurementframework.measureprovider.MeasurementListMeasureProvider;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.probeframework.measurement.ProbeMeasurement;
import org.palladiosimulator.probeframework.measurement.RequestContext;
import org.palladiosimulator.probeframework.probes.Probe;
import org.palladiosimulator.probeframework.probes.TriggeredProbe;
import org.palladiosimulator.probeframework.probes.listener.IProbeListener;

public class SupplementaryMeasurementAttachingProbe
extends Probe
implements IProbeListener {
    private List<TriggeredProbe> supplementaryProbes;
    private long primaryPosition = 0L;

    public SupplementaryMeasurementAttachingProbe(MetricSetDescription metricDesciption, Probe primaryProbe, List<TriggeredProbe> supplementaryProbes) {
        super((MetricDescription)metricDesciption);
        this.supplementaryProbes = supplementaryProbes;
        if (!metricDesciption.getSubsumedMetrics().stream().map(Identifier::getId).anyMatch(id -> primaryProbe.getMetricDesciption().getId().equals(id))) {
            throw new IllegalArgumentException("The metric of the primary probe needs to be contained in the resulting metric set description");
        }
        if (metricDesciption.getSubsumedMetrics().size() != supplementaryProbes.size() + 1) {
            throw new IllegalArgumentException("Expected " + (metricDesciption.getSubsumedMetrics().size() - 1) + " supplementary probes to be provided, got " + supplementaryProbes.size() + ".");
        }
        this.primaryPosition = metricDesciption.getSubsumedMetrics().stream().takeWhile(desc -> !desc.getId().equals(primaryProbe.getMetricDesciption().getId())).count();
        primaryProbe.addObserver(this);
    }

    @Override
    public void newProbeMeasurementAvailable(ProbeMeasurement probeMeasurement) {
        RequestContext context = probeMeasurement.getProbeAndContext().getRequestContext();
        int size = ((MetricSetDescription)this.getMetricDesciption()).getSubsumedMetrics().size();
        ArrayList<MeasuringValue> childMeasurements = new ArrayList<MeasuringValue>(size);
        Iterator<TriggeredProbe> supplIter = this.supplementaryProbes.iterator();
        int i = 0;
        while (i < size) {
            IMeasureProvider mp;
            ProbeMeasurement pm = probeMeasurement;
            if ((long)i != this.primaryPosition) {
                pm = supplIter.next().doMeasure(probeMeasurement.getProbeAndContext().getRequestContext());
            }
            if (!((mp = pm.getMeasureProvider()) instanceof MeasuringValue)) {
                throw new IllegalArgumentException("Subsumed measure providers have to be measurements");
            }
            childMeasurements.add((MeasuringValue)mp);
            ++i;
        }
        MeasurementListMeasureProvider measureProvider = new MeasurementListMeasureProvider(childMeasurements);
        this.notifyMeasurementSourceListener(new ProbeMeasurement((IMeasureProvider)measureProvider, this, context));
    }
}

