package org.palladiosimulator.protocom.tech.iiop.repository;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.palladiosimulator.pcm.repository.InfrastructureProvidedRole;
import org.palladiosimulator.pcm.repository.InfrastructureSignature;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.protocom.lang.java.IJMethod;
import org.palladiosimulator.protocom.lang.java.impl.JMethod;
import org.palladiosimulator.protocom.lang.java.util.JavaNames;
import org.palladiosimulator.protocom.lang.java.util.PcmCommons;
import org.palladiosimulator.protocom.tech.iiop.JavaEEIIOPInterface;

@SuppressWarnings("all")
public class JavaEEIIOPOperationInterface extends JavaEEIIOPInterface<ProvidedRole> {
  public JavaEEIIOPOperationInterface(final ProvidedRole entity) {
    super(entity);
  }

  @Override
  public Collection<? extends IJMethod> methods() {
    return this.providedRoleMethods(this.pcmEntity);
  }

  protected List<JMethod> _providedRoleMethods(final OperationProvidedRole role) {
    final Function1<OperationSignature, JMethod> _function = (OperationSignature it) -> {
      return new JMethod().withName(JavaNames.javaSignature(it)).withReturnType(PcmCommons.stackframeType()).withParameters(PcmCommons.stackContextParameterList());
    };
    return ListExtensions.<OperationSignature, JMethod>map(role.getProvidedInterface__OperationProvidedRole().getSignatures__OperationInterface(), _function);
  }

  protected List<JMethod> _providedRoleMethods(final InfrastructureProvidedRole role) {
    final Function1<InfrastructureSignature, JMethod> _function = (InfrastructureSignature it) -> {
      return new JMethod().withName(JavaNames.javaSignature(it)).withReturnType(PcmCommons.stackframeType()).withParameters(PcmCommons.stackContextParameterList()).withImplementation("return null;");
    };
    return ListExtensions.<InfrastructureSignature, JMethod>map(role.getProvidedInterface__InfrastructureProvidedRole().getInfrastructureSignatures__InfrastructureInterface(), _function);
  }

  public List<JMethod> providedRoleMethods(final ProvidedRole role) {
    if (role instanceof InfrastructureProvidedRole) {
      return _providedRoleMethods((InfrastructureProvidedRole)role);
    } else if (role instanceof OperationProvidedRole) {
      return _providedRoleMethods((OperationProvidedRole)role);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(role).toString());
    }
  }
}
