package org.palladiosimulator.protocom.tech.rmi.repository;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.palladiosimulator.pcm.repository.InfrastructureProvidedRole;
import org.palladiosimulator.pcm.repository.InfrastructureSignature;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.protocom.lang.java.IJField;
import org.palladiosimulator.protocom.lang.java.IJMethod;
import org.palladiosimulator.protocom.lang.java.impl.JField;
import org.palladiosimulator.protocom.lang.java.impl.JMethod;
import org.palladiosimulator.protocom.lang.java.util.JavaConstants;
import org.palladiosimulator.protocom.lang.java.util.JavaNames;
import org.palladiosimulator.protocom.lang.java.util.PcmCommons;
import org.palladiosimulator.protocom.tech.rmi.PojoClass;

/**
 * @author Thomas Zolynski, Sebastian Lehrig
 */
@SuppressWarnings("all")
public class PojoComposedStructurePortClass extends PojoClass<ProvidedRole> {
  public PojoComposedStructurePortClass(final ProvidedRole pcmEntity) {
    super(pcmEntity);
  }

  @Override
  public String superClass() {
    return JavaConstants.RMI_REMOTE_OBJECT_CLASS;
  }

  @Override
  public Collection<? extends IJField> fields() {
    JField _withType = new JField().withName("myCompositeComponent").withType(JavaNames.fqnInterface(this.pcmEntity.getProvidingEntity_ProvidedRole()));
    JField _withType_1 = new JField().withName("myInnerPort").withType(JavaNames.fqn(((OperationProvidedRole) this.pcmEntity).getProvidedInterface__OperationProvidedRole()));
    return Collections.<IJField>unmodifiableList(CollectionLiterals.<IJField>newArrayList(_withType, _withType_1));
  }

  @Override
  public String packageName() {
    return JavaNames.fqnPortPackage(this.pcmEntity);
  }

  @Override
  public String compilationUnitName() {
    return JavaNames.portClassName(this.pcmEntity);
  }

  @Override
  public Collection<String> interfaces() {
    String _fqnInterface = JavaNames.fqnInterface(this.pcmEntity.getProvidingEntity_ProvidedRole());
    String _plus = ("org.palladiosimulator.protocom.framework.java.se.port.IPerformancePrototypePort<" + _fqnInterface);
    String _plus_1 = (_plus + ">");
    String _fqn = JavaNames.fqn(((OperationProvidedRole) this.pcmEntity).getProvidedInterface__OperationProvidedRole());
    return Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_plus_1, _fqn, JavaConstants.RMI_REMOTE_INTERFACE, JavaConstants.SERIALIZABLE_INTERFACE));
  }

  @Override
  public Collection<? extends IJMethod> constructors() {
    JMethod _jMethod = new JMethod();
    String _fqn = JavaNames.fqn(((OperationProvidedRole) this.pcmEntity).getProvidedInterface__OperationProvidedRole());
    String _plus = (_fqn + " myInnerPort, ");
    String _fqnInterface = JavaNames.fqnInterface(this.pcmEntity.getProvidingEntity_ProvidedRole());
    String _plus_1 = (_plus + _fqnInterface);
    String _plus_2 = (_plus_1 + " myComponent, String assemblyContext");
    JMethod _withThrows = _jMethod.withParameters(_plus_2).withThrows(JavaConstants.RMI_REMOTE_EXCEPTION);
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("this.myInnerPort = myInnerPort;");
    _builder.newLine();
    _builder.append("this.myCompositeComponent = myComponent;");
    _builder.newLine();
    _builder.append("org.palladiosimulator.protocom.framework.java.se.registry.RmiRegistry.registerPort(org.palladiosimulator.protocom.framework.java.se.registry.RmiRegistry.getRemoteAddress(),");
    _builder.newLine();
    _builder.append("org.palladiosimulator.protocom.framework.java.se.registry.RmiRegistry.getRegistryPort(), this, \"");
    String _portClassName = JavaNames.portClassName(this.pcmEntity);
    _builder.append(_portClassName);
    _builder.append("_\" + assemblyContext);");
    _builder.newLineIfNotEmpty();
    JMethod _withImplementation = _withThrows.withImplementation(_builder.toString());
    return Collections.<IJMethod>unmodifiableList(CollectionLiterals.<IJMethod>newArrayList(_withImplementation));
  }

  @Override
  public Collection<? extends IJMethod> methods() {
    LinkedList<JMethod> _xblockexpression = null;
    {
      final LinkedList<JMethod> results = CollectionLiterals.<JMethod>newLinkedList();
      List<JMethod> _providedRoleMethods = this.providedRoleMethods(this.pcmEntity);
      Iterables.<JMethod>addAll(results, _providedRoleMethods);
      JMethod _withImplementation = new JMethod().withName("setContext").withParameters("Object myContext").withThrows(JavaConstants.RMI_REMOTE_EXCEPTION).withImplementation("myCompositeComponent.setContext(myContext);");
      JMethod _withImplementation_1 = new JMethod().withName("setComponentFrame").withParameters(PcmCommons.stackframeParameterList()).withThrows(JavaConstants.RMI_REMOTE_EXCEPTION).withImplementation("");
      JMethod _withImplementation_2 = new JMethod().withName("getComponent").withReturnType(JavaNames.fqnInterface(this.pcmEntity.getProvidingEntity_ProvidedRole())).withThrows(JavaConstants.RMI_REMOTE_EXCEPTION).withImplementation("return myCompositeComponent;");
      Iterables.<JMethod>addAll(results, Collections.<JMethod>unmodifiableList(CollectionLiterals.<JMethod>newArrayList(_withImplementation, _withImplementation_1, _withImplementation_2)));
      _xblockexpression = results;
    }
    return _xblockexpression;
  }

  @Override
  public String filePath() {
    String _fqnToDirectoryPath = JavaNames.fqnToDirectoryPath(JavaNames.fqnPortPackage(this.pcmEntity));
    String _plus = ("/src/" + _fqnToDirectoryPath);
    String _plus_1 = (_plus + "/");
    String _portClassName = JavaNames.portClassName(this.pcmEntity);
    String _plus_2 = (_plus_1 + _portClassName);
    return (_plus_2 + ".java");
  }

  protected List<JMethod> _providedRoleMethods(final OperationProvidedRole role) {
    final Function1<OperationSignature, JMethod> _function = (OperationSignature it) -> {
      JMethod _withParameters = new JMethod().withName(JavaNames.javaSignature(it)).withReturnType(PcmCommons.stackframeType()).withParameters(PcmCommons.stackContextParameterList());
      String _javaSignature = JavaNames.javaSignature(it);
      String _plus = ("return myInnerPort." + _javaSignature);
      String _plus_1 = (_plus + "(ctx);");
      return _withParameters.withImplementation(_plus_1).withThrows(JavaConstants.RMI_REMOTE_EXCEPTION);
    };
    return ListExtensions.<OperationSignature, JMethod>map(role.getProvidedInterface__OperationProvidedRole().getSignatures__OperationInterface(), _function);
  }

  protected List<JMethod> _providedRoleMethods(final InfrastructureProvidedRole role) {
    final Function1<InfrastructureSignature, JMethod> _function = (InfrastructureSignature it) -> {
      return new JMethod().withName(JavaNames.javaSignature(it)).withReturnType(PcmCommons.stackframeType()).withParameters(PcmCommons.stackContextParameterList()).withImplementation("return null;").withThrows(JavaConstants.RMI_REMOTE_EXCEPTION);
    };
    return ListExtensions.<InfrastructureSignature, JMethod>map(role.getProvidedInterface__InfrastructureProvidedRole().getInfrastructureSignatures__InfrastructureInterface(), _function);
  }

  public List<JMethod> providedRoleMethods(final ProvidedRole role) {
    if (role instanceof InfrastructureProvidedRole) {
      return _providedRoleMethods((InfrastructureProvidedRole)role);
    } else if (role instanceof OperationProvidedRole) {
      return _providedRoleMethods((OperationProvidedRole)role);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(role).toString());
    }
  }
}
