/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.reliability.solver.reporting;

import java.util.ArrayList;
import java.util.List;
import org.palladiosimulator.reliability.solver.reporting.ImpactAnalysisFailureType;

public class ImpactAnalysisFailureProbabilityAggregation {
    private List<String> entityIdentifiers;
    private List<String> entityNameParts;
    ImpactAnalysisFailureType failureAggregationType;
    private double failureProbability;

    public ImpactAnalysisFailureProbabilityAggregation(ImpactAnalysisFailureType failureAggregationType, List<String> entityIdentifiers, List<String> entityNameParts, double failureProbability) {
        this.failureAggregationType = failureAggregationType;
        this.entityIdentifiers = new ArrayList<String>(entityIdentifiers.size());
        for (String identifier : entityIdentifiers) {
            this.entityIdentifiers.add(identifier);
        }
        this.entityNameParts = new ArrayList<String>(entityNameParts);
        this.failureProbability = failureProbability;
    }

    public void addToFailureProbabilityBy(double failureProbability) {
        this.failureProbability += failureProbability;
    }

    public boolean compareToIdentifier(ImpactAnalysisFailureType otherEntityType, List<String> otherEntityIdentifiers) {
        if (this.failureAggregationType == otherEntityType && this.entityIdentifiers.size() == otherEntityIdentifiers.size()) {
            int i = 0;
            while (i < this.entityIdentifiers.size()) {
                if (!this.entityIdentifiers.get(i).equals(otherEntityIdentifiers.get(i))) {
                    return false;
                }
                ++i;
            }
        } else {
            return false;
        }
        return true;
    }

    public List<String> getEntityIdentifiers() {
        return this.entityIdentifiers;
    }

    public List<String> getEntityNameParts() {
        return this.entityNameParts;
    }

    public double getFailureProbability() {
        return this.failureProbability;
    }

    public ImpactAnalysisFailureType getType() {
        return this.failureAggregationType;
    }

    public void setEntityIdentifiers(List<String> entityIdentifiers) {
        this.entityIdentifiers = entityIdentifiers;
    }

    public void setEntityNameParts(List<String> entityNameParts) {
        this.entityNameParts = entityNameParts;
    }

    public void setFailureProbability(double failureProbability) {
        this.failureProbability = failureProbability;
    }

    public void setType(ImpactAnalysisFailureType failureAggregationType) {
        this.failureAggregationType = failureAggregationType;
    }
}

