/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.reliability.solver.sensitivity;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.usagemodel.Branch;
import org.palladiosimulator.pcm.usagemodel.BranchTransition;
import org.palladiosimulator.pcm.usagemodel.UsagemodelFactory;
import org.palladiosimulator.reliability.sensitivity.DoubleParameterVariation;
import org.palladiosimulator.reliability.sensitivity.SensitivityParameterVariation;
import org.palladiosimulator.reliability.solver.sensitivity.MarkovSensitivity;

public class UsageBranchSensitivity
extends MarkovSensitivity {
    private double baseValue;
    private String behaviourId;
    private String branchId;
    private BranchTransition transition = null;

    public UsageBranchSensitivity(String name, String branchId, String behaviourId, DoubleParameterVariation variation) {
        super(name, (SensitivityParameterVariation)variation);
        this.branchId = branchId;
        this.behaviourId = behaviourId;
    }

    @Override
    protected boolean alterModel() {
        if (this.transition == null) {
            return false;
        }
        this.transition.setBranchProbability(this.calculator.calculateCurrentDoubleValue(this.getDoubleVariation(), this.getCurrentStepNumber(), this.baseValue));
        return true;
    }

    @Override
    protected void extractSensitivityInformation() {
        if (this.getModel().getUsageModel() == null) {
            LOGGER.error((Object)"No PCM UsageModel found.");
            return;
        }
        Branch branch = null;
        EList branches = this.helper.getElements((EObject)this.getModel().getUsageModel(), UsagemodelFactory.eINSTANCE.createBranch().eClass());
        for (EObject object : branches) {
            if (!((Branch)object).getId().equals(this.branchId)) continue;
            branch = (Branch)object;
            break;
        }
        if (branch == null) {
            LOGGER.error((Object)("No Branch with ID \"" + this.branchId + "\" found."));
            return;
        }
        for (BranchTransition branchTransition : branch.getBranchTransitions_Branch()) {
            if (!branchTransition.getBranchedBehaviour_BranchTransition().getId().equals(this.behaviourId)) continue;
            this.transition = branchTransition;
            this.baseValue = branchTransition.getBranchProbability();
            return;
        }
        if (this.transition == null) {
            LOGGER.error((Object)("No BranchTransition with associated behaviour ID \"" + this.behaviourId + "\" found."));
        }
    }

    @Override
    protected List<List<String>> getLogHeadingsMulti() {
        ArrayList<List<String>> resultList = new ArrayList<List<String>>();
        ArrayList<String> headings = new ArrayList<String>();
        headings.add("Branch Name");
        headings.add("Branch ID");
        headings.add("Scenario Behaviour Name");
        headings.add("Scenario Behaviour ID");
        headings.add("Branch Probability");
        resultList.add(headings);
        return resultList;
    }

    @Override
    protected List<String> getLogSingleResultsMulti() {
        ArrayList<String> resultList = new ArrayList<String>();
        resultList.add(this.transition.getBranch_BranchTransition().getEntityName());
        resultList.add(this.branchId);
        resultList.add(this.transition.getBranchedBehaviour_BranchTransition().getEntityName());
        resultList.add(this.behaviourId);
        resultList.add(this.calculator.getCurrentLogEntry((SensitivityParameterVariation)this.getDoubleVariation(), this.getCurrentStepNumber()));
        return resultList;
    }
}

