/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.core.gui;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.palladiosimulator.retriever.core.gui.ServiceConfigurationManager;
import org.palladiosimulator.retriever.core.gui.TreeEditListener;
import org.palladiosimulator.retriever.services.Service;
import org.palladiosimulator.retriever.services.ServiceConfiguration;

public class ServiceConfigurationView<T extends Service>
extends ServiceConfigurationManager<T> {
    private static final int SERVICE_CONFIGURATION_VALUE_COLUMN = 1;
    private final Map<String, Map<String, TreeItem>> configTreeItems = new HashMap<String, Map<String, TreeItem>>();
    private final Map<String, Button> serviceCheckboxes = new HashMap<String, Button>();
    private final ModifyListener modifyListener;

    public ServiceConfigurationView(ServiceConfiguration<T> serviceConfiguration, ModifyListener modifyListener) {
        super(serviceConfiguration);
        this.modifyListener = modifyListener;
    }

    public void createControl(Composite container) {
        Tree tree = new Tree(container, 67584);
        TreeColumn nameColumn = new TreeColumn(tree, 0);
        nameColumn.setWidth(200);
        TreeColumn valueColumn = new TreeColumn(tree, 0);
        valueColumn.setWidth(200);
        tree.addListener(13, (Listener)new TreeEditListener(tree, this.modifyListener, 1));
        List sortedServices = this.getServiceConfiguration().getAvailable().stream().sorted(Comparator.comparing(Service::getName)).collect(Collectors.toList());
        for (Service service : sortedServices) {
            TreeItem serviceItem = new TreeItem(tree, 0);
            serviceItem.setText(0, service.getClass().getSimpleName());
            this.addCheckboxTo(serviceItem, service);
            if (service.getConfigurationKeys() == null) continue;
            String serviceId = service.getID();
            this.configTreeItems.putIfAbsent(serviceId, new HashMap());
            for (String configKey : service.getConfigurationKeys()) {
                TreeItem propertyItem = new TreeItem(serviceItem, 0);
                propertyItem.setText(0, configKey);
                this.configTreeItems.get(serviceId).put(configKey, propertyItem);
            }
        }
    }

    private void addCheckboxTo(TreeItem item, T service) {
        Tree tree = item.getParent();
        TreeEditor editor = new TreeEditor(tree);
        Button checkbox = new Button((Composite)tree, 32);
        checkbox.addSelectionListener(new SelectionListener((Service)service){
            private final /* synthetic */ Service val$service;
            {
                this.val$service = service;
            }

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.getSource()).getSelection()) {
                    ServiceConfigurationView.this.getServiceConfiguration().select(this.val$service);
                } else {
                    ServiceConfigurationView.this.getServiceConfiguration().deselect(this.val$service);
                }
                ServiceConfigurationView.this.modifyListener.modifyText(null);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        checkbox.pack();
        this.serviceCheckboxes.put(service.getID(), checkbox);
        editor.minimumWidth = checkbox.getSize().x;
        editor.horizontalAlignment = 16384;
        editor.setEditor((Control)checkbox, item, 1);
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        for (Service service : this.getServiceConfiguration().getAvailable()) {
            String id = service.getID();
            this.initializeCheckbox(service, this.serviceCheckboxes.get(id));
            this.initializeTreeItems(service, this.configTreeItems.get(id));
        }
    }

    private void initializeCheckbox(T service, Button checkbox) {
        boolean selected = this.getServiceConfiguration().isManuallySelected(service);
        checkbox.setSelection(selected);
    }

    private void initializeTreeItems(T service, Map<String, TreeItem> treeItems) {
        Map strings = this.getServiceConfiguration().getWholeConfig(service.getID());
        for (Map.Entry<String, TreeItem> entry : treeItems.entrySet()) {
            String value = (String)strings.get(entry.getKey());
            if (value == null) {
                value = "";
            }
            entry.getValue().setText(1, value);
        }
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        for (Service service : this.getServiceConfiguration().getAvailable()) {
            for (Map.Entry<String, TreeItem> entry : this.configTreeItems.get(service.getID()).entrySet()) {
                TreeItem treeItem = entry.getValue();
                String configurationValue = treeItem.getText(1);
                this.getServiceConfiguration().setConfig(service.getID(), entry.getKey(), configurationValue);
            }
        }
        super.performApply(configuration);
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        this.writeServiceConfigAttributes(configuration);
    }

    private void writeServiceConfigAttributes(ILaunchConfigurationWorkingCopy configuration) {
        Map attributes = this.getServiceConfiguration().toMap();
        for (Map.Entry attribute : attributes.entrySet()) {
            configuration.setAttribute((String)attribute.getKey(), attribute.getValue());
        }
    }
}

