package org.palladiosimulator.retriever.extraction.rules;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jdom2.Document;
import org.jdom2.Element;
import org.palladiosimulator.retriever.extraction.rules.data.GatewayRoute;
import org.palladiosimulator.retriever.extraction.rules.util.ProjectHelper;
import org.palladiosimulator.retriever.services.Rule;
import org.palladiosimulator.retriever.services.blackboard.RetrieverBlackboard;

@SuppressWarnings("all")
public class JaxRSDeploymentRules implements Rule {
  public static final String RULE_ID = "org.palladiosimulator.retriever.extraction.rules.jax_rs.deployment";

  public static final String DONE_ID = "org.palladiosimulator.retriever.extraction.rules.jax_rs.deployment.done";

  public static final String XML_DISCOVERER_ID = "org.palladiosimulator.retriever.extraction.discoverers.xml";

  public static final String JAVA_DISCOVERER_ID = "org.palladiosimulator.retriever.extraction.discoverers.java";

  public static final String ECMASCRIPT_RULE_ID = "org.palladiosimulator.retriever.extraction.rules.ecmascript";

  public static final String ECMASCRIPT_ROUTES_ID = "org.palladiosimulator.retriever.extraction.rules.ecmascript.routes";

  public static final String ECMASCRIPT_HOSTNAMES_ID = "org.palladiosimulator.retriever.extraction.rules.ecmascript.hostnames";

  @Override
  public void processRules(final RetrieverBlackboard blackboard, final Path path) {
    boolean _hasPartition = blackboard.hasPartition(JaxRSDeploymentRules.DONE_ID);
    if (_hasPartition) {
      return;
    }
    final Map<Path, Document> xmls = blackboard.<Document>getDiscoveredFiles(JaxRSDeploymentRules.XML_DISCOVERER_ID, Document.class);
    Map<Path, String> hostnames = new HashMap<Path, String>();
    boolean _hasPartition_1 = blackboard.hasPartition(JaxRSDeploymentRules.RULE_ID);
    if (_hasPartition_1) {
      Object _partition = blackboard.getPartition(JaxRSDeploymentRules.RULE_ID);
      hostnames = ((Map<Path, String>) _partition);
    }
    final List<GatewayRoute> routes = new ArrayList<GatewayRoute>();
    Set<Map.Entry<Path, Document>> _entrySet = xmls.entrySet();
    for (final Map.Entry<Path, Document> xmlEntry : _entrySet) {
      {
        final Path xmlPath = xmlEntry.getKey();
        final Document xml = xmlEntry.getValue();
        boolean _endsWith = xmlPath.endsWith("WEB-INF/web.xml");
        if (_endsWith) {
          final Function<Element, String> _function = (Element servlet) -> {
            final String classTag = servlet.getChildTextTrim("servlet-class", servlet.getNamespace());
            if ((classTag != null)) {
              return classTag;
            } else {
              return servlet.getChildTextTrim("servlet-name", servlet.getNamespace());
            }
          };
          final Function<Element, String> _function_1 = (Element servlet) -> {
            return servlet.getChildTextTrim("servlet-name", servlet.getNamespace());
          };
          final Map<String, String> servlets = xml.getRootElement().getChildren("servlet", xml.getRootElement().getNamespace()).stream().collect(
            Collectors.<Element, String, String>toMap(_function, _function_1));
          final Function<Element, String> _function_2 = (Element servlet) -> {
            return servlet.getChildTextTrim("servlet-name", servlet.getNamespace());
          };
          final Function<Element, String> _function_3 = (Element servlet) -> {
            return servlet.getChildTextTrim("url-pattern", servlet.getNamespace());
          };
          final Map<String, String> servletMappings = xml.getRootElement().getChildren("servlet-mapping", xml.getRootElement().getNamespace()).stream().collect(
            Collectors.<Element, String, String>toMap(_function_2, _function_3));
          Collection<String> _values = servlets.values();
          for (final String servletName : _values) {
            String _get = servletMappings.get(servletName);
            GatewayRoute _gatewayRoute = new GatewayRoute(_get, servletName, true);
            routes.add(_gatewayRoute);
          }
          final HashMap<String, Path> nameToPath = new HashMap<String, Path>();
          final Map<Path, CompilationUnit> compilationUnits = blackboard.<CompilationUnit>getDiscoveredFiles(JaxRSDeploymentRules.JAVA_DISCOVERER_ID, CompilationUnit.class);
          Set<Map.Entry<Path, CompilationUnit>> _entrySet_1 = compilationUnits.entrySet();
          for (final Map.Entry<Path, CompilationUnit> entry : _entrySet_1) {
            {
              final Path compilationUnitPath = entry.getKey();
              final CompilationUnit compilationUnit = entry.getValue();
              final List types = compilationUnit.types();
              boolean _isEmpty = types.isEmpty();
              boolean _not = (!_isEmpty);
              if (_not) {
                Object _get_1 = types.get(0);
                final String name = ((AbstractTypeDeclaration) _get_1).resolveBinding().getQualifiedName();
                nameToPath.put(name, compilationUnitPath);
              }
            }
          }
          Set<Map.Entry<String, String>> _entrySet_2 = servlets.entrySet();
          for (final Map.Entry<String, String> servlet : _entrySet_2) {
            {
              final Path servletPath = nameToPath.get(servlet.getKey());
              hostnames.put(servletPath, servlet.getValue());
            }
          }
        }
      }
    }
    boolean _hasPartition_2 = blackboard.hasPartition(JaxRSDeploymentRules.RULE_ID);
    boolean _not = (!_hasPartition_2);
    if (_not) {
      blackboard.addPartition(JaxRSDeploymentRules.RULE_ID, hostnames);
    }
    final Path projectRoot = ProjectHelper.findProjectRoot(path, "pom.xml", "build.gradle");
    boolean _hasPartition_3 = blackboard.hasPartition(JaxRSDeploymentRules.ECMASCRIPT_ROUTES_ID);
    if (_hasPartition_3) {
      Object _partition_1 = blackboard.getPartition(JaxRSDeploymentRules.ECMASCRIPT_ROUTES_ID);
      final Map<Path, List<GatewayRoute>> ecmaScriptRouteMap = ((Map<Path, List<GatewayRoute>>) _partition_1);
      boolean _containsKey = ecmaScriptRouteMap.containsKey(projectRoot);
      if (_containsKey) {
        ecmaScriptRouteMap.get(projectRoot).addAll(routes);
      } else {
        ecmaScriptRouteMap.put(projectRoot, routes);
      }
    } else {
      final HashMap<Path, List<GatewayRoute>> routeMap = new HashMap<Path, List<GatewayRoute>>();
      routeMap.put(projectRoot, routes);
      blackboard.addPartition(JaxRSDeploymentRules.ECMASCRIPT_ROUTES_ID, routeMap);
    }
    Map<Path, String> hostnameMap = new HashMap<Path, String>();
    boolean _hasPartition_4 = blackboard.hasPartition(JaxRSDeploymentRules.ECMASCRIPT_HOSTNAMES_ID);
    if (_hasPartition_4) {
      Object _partition_2 = blackboard.getPartition(JaxRSDeploymentRules.ECMASCRIPT_HOSTNAMES_ID);
      hostnameMap = ((Map<Path, String>) _partition_2);
    }
    hostnameMap.putAll(hostnames);
    boolean _hasPartition_5 = blackboard.hasPartition(JaxRSDeploymentRules.ECMASCRIPT_HOSTNAMES_ID);
    boolean _not_1 = (!_hasPartition_5);
    if (_not_1) {
      blackboard.addPartition(JaxRSDeploymentRules.ECMASCRIPT_HOSTNAMES_ID, hostnameMap);
    }
    blackboard.addPartition(JaxRSDeploymentRules.DONE_ID, Boolean.valueOf(true));
  }

  @Override
  public boolean isBuildRule() {
    return false;
  }

  @Override
  public Set<String> getConfigurationKeys() {
    return Set.<String>of();
  }

  @Override
  public String getID() {
    return JaxRSDeploymentRules.RULE_ID;
  }

  @Override
  public String getName() {
    return "JAX RS Deployment Rules";
  }

  @Override
  public Set<String> getRequiredServices() {
    return Set.<String>of(JaxRSDeploymentRules.XML_DISCOVERER_ID, JaxRSDeploymentRules.JAVA_DISCOVERER_ID);
  }

  @Override
  public Set<String> getDependentServices() {
    return Set.<String>of(JaxRSDeploymentRules.ECMASCRIPT_RULE_ID);
  }
}
