package org.palladiosimulator.retriever.extraction.rules.data;

import java.util.List;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.palladiosimulator.retriever.extraction.commonalities.RESTName;

@SuppressWarnings("all")
public class GatewayRoute {
  private static final String TRAILING_WILDCARD = "/**";

  private String pathPattern;

  private String targetHost;

  private int stripPrefixLength;

  public GatewayRoute(final String path, final String serviceId, final boolean stripPrefix) {
    this.pathPattern = path;
    this.targetHost = serviceId;
    int _xifexpression = (int) 0;
    if (stripPrefix) {
      _xifexpression = GatewayRoute.calculateStripPrefixLength(this.pathPattern);
    } else {
      _xifexpression = 0;
    }
    this.stripPrefixLength = _xifexpression;
  }

  public GatewayRoute(final String path, final String serviceId, final int stripPrefixLength) {
    this.pathPattern = path;
    this.targetHost = serviceId;
    this.stripPrefixLength = stripPrefixLength;
  }

  public String getPath() {
    return this.pathPattern;
  }

  public String getTargetHost() {
    return this.targetHost;
  }

  public boolean matches(final String url) {
    boolean _endsWith = this.pathPattern.endsWith(GatewayRoute.TRAILING_WILDCARD);
    if (_endsWith) {
      int _length = this.pathPattern.length();
      int _length_1 = GatewayRoute.TRAILING_WILDCARD.length();
      int _minus = (_length - _length_1);
      final String prefix = this.pathPattern.substring(0, _minus);
      return url.startsWith(prefix);
    }
    return this.pathPattern.equals(url);
  }

  public RESTName applyTo(final String url) {
    final String[] urlSegments = GatewayRoute.toSegments(url);
    String newUrl = "";
    int _length = urlSegments.length;
    boolean _lessThan = (this.stripPrefixLength < _length);
    if (_lessThan) {
      final List<String> newUrlSegments = ((List<String>)Conversions.doWrapArray(urlSegments)).subList(this.stripPrefixLength, urlSegments.length);
      newUrl = GatewayRoute.toPath(((String[])Conversions.unwrapArray(newUrlSegments, String.class)));
    }
    return new RESTName(this.targetHost, newUrl);
  }

  private static int calculateStripPrefixLength(final String pathPattern) {
    boolean _endsWith = pathPattern.endsWith(GatewayRoute.TRAILING_WILDCARD);
    if (_endsWith) {
      return GatewayRoute.toSegments(pathPattern).length;
    } else {
      return 0;
    }
  }

  private static String[] toSegments(final String path) {
    final String[] segments = path.split("/");
    if (((segments.length > 0) && (segments[0]).isEmpty())) {
      return ((String[])Conversions.unwrapArray(((List<String>)Conversions.doWrapArray(segments)).subList(1, segments.length), String.class));
    }
    return segments;
  }

  private static String toPath(final String[] segments) {
    String _join = IterableExtensions.join(((Iterable<?>)Conversions.doWrapArray(segments)), "/");
    return ("/" + _join);
  }
}
