package org.palladiosimulator.retriever.extraction.rules.util;

import java.nio.file.Files;
import java.nio.file.Path;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class ProjectHelper {
  public static Path findProjectRoot(final Path pathInProject, final String... projectFileNames) {
    if ((pathInProject == null)) {
      return null;
    }
    Path currentPath = pathInProject;
    while ((IterableExtensions.size(currentPath) > 0)) {
      {
        currentPath = currentPath.getParent();
        for (final String projectFileName : projectFileNames) {
          boolean _exists = Files.exists(currentPath.resolve(projectFileName));
          if (_exists) {
            return currentPath;
          }
        }
      }
    }
    return null;
  }
}
