/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.extraction.engine;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.palladiosimulator.retriever.extraction.commonalities.CompUnitOrName;
import org.palladiosimulator.retriever.extraction.engine.PCMDetector;

public class DockerParser {
    private static final String FILE_NAME = "docker-compose";
    private final Path path;
    private final PCMDetector pcmDetector;
    private final Map<String, Set<CompilationUnit>> mapping;
    private static final Logger LOG = Logger.getLogger(DockerParser.class);

    public DockerParser(Path path, PCMDetector pcmDetector) {
        LOG.info((Object)"starting docker process");
        this.path = path;
        this.pcmDetector = pcmDetector;
        InputStream input = this.getDockerFile();
        List<String> services = DockerParser.extractServiceNames(input);
        this.mapping = this.createServiceComponentMapping(services);
    }

    private InputStream getDockerFile() {
        List<Object> paths = new ArrayList();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Stream<Path> files = Files.walk(this.path, new FileVisitOption[0]);){
                paths = files.filter(f -> f.getFileName().toString().contains(FILE_NAME)).collect(Collectors.toList());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (paths.isEmpty()) {
            LOG.info((Object)"No docker compose file detected.");
            return null;
        }
        Path firstPath = (Path)paths.get(0);
        File initialFile = firstPath.toFile();
        try {
            return new FileInputStream(initialFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static List<String> extractServiceNames(InputStream stream) {
        HashMap object = new HashMap();
        if (!object.containsKey("services")) {
            LOG.info((Object)"No property with name 'services' in docker compose file. File not usable");
            return new ArrayList<String>();
        }
        return new ArrayList<String>(((Map)object.get("services")).keySet());
    }

    private Map<String, Set<CompilationUnit>> createServiceComponentMapping(List<String> serviceNames) {
        Set<CompUnitOrName> components = this.pcmDetector.getCompilationUnits();
        HashMap<String, Set<CompilationUnit>> serviceToCompMapping = new HashMap<String, Set<CompilationUnit>>();
        components.forEach(compUnitOrName -> {
            if (!compUnitOrName.isUnit()) {
                return;
            }
            CompilationUnit comp = compUnitOrName.compilationUnit().get();
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (Stream<Path> files = Files.walk(this.path, new FileVisitOption[0]);){
                    List foundPaths = files.filter(f -> f.toString().contains(((AbstractTypeDeclaration)comp.types().get(0)).getName().getIdentifier())).collect(Collectors.toList());
                    if (!foundPaths.isEmpty()) {
                        serviceNames.forEach(serviceName -> {
                            if (((Path)foundPaths.get(0)).toString().contains((CharSequence)serviceName)) {
                                if (!serviceToCompMapping.containsKey(serviceName)) {
                                    serviceToCompMapping.put((String)serviceName, new HashSet());
                                }
                                ((Set)serviceToCompMapping.get(serviceName)).add(comp);
                            }
                        });
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return serviceToCompMapping;
    }

    public Map<String, Set<CompilationUnit>> getMapping() {
        return this.mapping;
    }
}

