package org.palladiosimulator.retriever.vulnerability.analyst;

import java.nio.file.Path;
import java.util.Map;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.CommonPlugin;
import org.palladiosimulator.retriever.services.Analyst;
import org.palladiosimulator.retriever.services.RetrieverConfiguration;
import org.palladiosimulator.retriever.services.blackboard.RetrieverBlackboard;
import org.palladiosimulator.retriever.vulnerability.core.SnykCLIStaticCodeAnalyst;

import de.uka.ipd.sdq.workflow.jobs.AbstractBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;

public class SnykCodeAnalystJob extends AbstractBlackboardInteractingJob<RetrieverBlackboard> {
    private final RetrieverConfiguration configuration;

    public SnykCodeAnalystJob(RetrieverConfiguration configuration, RetrieverBlackboard blackboard) {
        this.configuration = configuration;
        setBlackboard(blackboard);
    }

    @Override
    public void execute(IProgressMonitor monitor) {
        Map<String, String> snykAnalystConfig = configuration.getConfig(Analyst.class)
            .getWholeConfig(SnykCodeAnalyst.ANALYST_ID);
        String snykExeLocation = snykAnalystConfig.get(SnykCodeAnalyst.SNYK_EXE_LOCATION_KEY);
        if (snykExeLocation != null) {
            Path snykExePath = Path.of(snykExeLocation);
            Path outputPath = Path.of(CommonPlugin.asLocalURI(configuration.getOutputFolder())
                .devicePath());
            String apiKey = snykAnalystConfig.get(SnykCodeAnalyst.DATABASE_API_KEY);
            String snykToken = snykAnalystConfig.get(SnykCodeAnalyst.SNYK_TOKEN_KEY);
            SnykCLIStaticCodeAnalyst analyst = new SnykCLIStaticCodeAnalyst(snykExePath, outputPath, apiKey, snykToken);
            analyst.analyze(getBlackboard().getSystemPaths());
        }
    }

    @Override
    public void cleanup(IProgressMonitor arg0) throws CleanupFailedException {
    }

    @Override
    public String getName() {
        return "Snyk Code Analyst Job";
    }
}
