
package org.palladiosimulator.retriever.vulnerability.core.nvd;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;


/**
 * JSON Schema for Common Vulnerability Scoring System version 3.0
 * <p>
 * 
 * 
 */
@Generated("jsonschema2pojo")
public class CvssV30Data {

    /**
     * CVSS Version
     * (Required)
     * 
     */
    @SerializedName("version")
    @Expose
    private CvssV30Data .Version version;
    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("vectorString")
    @Expose
    private String vectorString;
    @SerializedName("attackVector")
    @Expose
    private CvssV30Data .AttackVectorType attackVector;
    @SerializedName("attackComplexity")
    @Expose
    private CvssV30Data .AttackComplexityType attackComplexity;
    @SerializedName("privilegesRequired")
    @Expose
    private CvssV30Data .PrivilegesRequiredType privilegesRequired;
    @SerializedName("userInteraction")
    @Expose
    private CvssV30Data .UserInteractionType userInteraction;
    @SerializedName("scope")
    @Expose
    private CvssV30Data .ScopeType scope;
    @SerializedName("confidentialityImpact")
    @Expose
    private CvssV30Data .CiaType confidentialityImpact;
    @SerializedName("integrityImpact")
    @Expose
    private CvssV30Data .CiaType integrityImpact;
    @SerializedName("availabilityImpact")
    @Expose
    private CvssV30Data .CiaType availabilityImpact;
    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("baseScore")
    @Expose
    private Double baseScore;
    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("baseSeverity")
    @Expose
    private CvssV30Data .SeverityType baseSeverity;
    @SerializedName("exploitCodeMaturity")
    @Expose
    private CvssV30Data .ExploitCodeMaturityType exploitCodeMaturity;
    @SerializedName("remediationLevel")
    @Expose
    private CvssV30Data .RemediationLevelType remediationLevel;
    @SerializedName("reportConfidence")
    @Expose
    private CvssV30Data .ConfidenceType reportConfidence;
    @SerializedName("temporalScore")
    @Expose
    private Double temporalScore;
    @SerializedName("temporalSeverity")
    @Expose
    private CvssV30Data .SeverityType temporalSeverity;
    @SerializedName("confidentialityRequirement")
    @Expose
    private CvssV30Data .CiaRequirementType confidentialityRequirement;
    @SerializedName("integrityRequirement")
    @Expose
    private CvssV30Data .CiaRequirementType integrityRequirement;
    @SerializedName("availabilityRequirement")
    @Expose
    private CvssV30Data .CiaRequirementType availabilityRequirement;
    @SerializedName("modifiedAttackVector")
    @Expose
    private CvssV30Data .ModifiedAttackVectorType modifiedAttackVector;
    @SerializedName("modifiedAttackComplexity")
    @Expose
    private CvssV30Data .ModifiedAttackComplexityType modifiedAttackComplexity;
    @SerializedName("modifiedPrivilegesRequired")
    @Expose
    private CvssV30Data .ModifiedPrivilegesRequiredType modifiedPrivilegesRequired;
    @SerializedName("modifiedUserInteraction")
    @Expose
    private CvssV30Data .ModifiedUserInteractionType modifiedUserInteraction;
    @SerializedName("modifiedScope")
    @Expose
    private CvssV30Data .ModifiedScopeType modifiedScope;
    @SerializedName("modifiedConfidentialityImpact")
    @Expose
    private CvssV30Data .ModifiedCiaType modifiedConfidentialityImpact;
    @SerializedName("modifiedIntegrityImpact")
    @Expose
    private CvssV30Data .ModifiedCiaType modifiedIntegrityImpact;
    @SerializedName("modifiedAvailabilityImpact")
    @Expose
    private CvssV30Data .ModifiedCiaType modifiedAvailabilityImpact;
    @SerializedName("environmentalScore")
    @Expose
    private Double environmentalScore;
    @SerializedName("environmentalSeverity")
    @Expose
    private CvssV30Data .SeverityType environmentalSeverity;

    /**
     * CVSS Version
     * (Required)
     * 
     */
    public CvssV30Data .Version getVersion() {
        return version;
    }

    /**
     * CVSS Version
     * (Required)
     * 
     */
    public void setVersion(CvssV30Data .Version version) {
        this.version = version;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getVectorString() {
        return vectorString;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setVectorString(String vectorString) {
        this.vectorString = vectorString;
    }

    public CvssV30Data .AttackVectorType getAttackVector() {
        return attackVector;
    }

    public void setAttackVector(CvssV30Data .AttackVectorType attackVector) {
        this.attackVector = attackVector;
    }

    public CvssV30Data .AttackComplexityType getAttackComplexity() {
        return attackComplexity;
    }

    public void setAttackComplexity(CvssV30Data .AttackComplexityType attackComplexity) {
        this.attackComplexity = attackComplexity;
    }

    public CvssV30Data .PrivilegesRequiredType getPrivilegesRequired() {
        return privilegesRequired;
    }

    public void setPrivilegesRequired(CvssV30Data .PrivilegesRequiredType privilegesRequired) {
        this.privilegesRequired = privilegesRequired;
    }

    public CvssV30Data .UserInteractionType getUserInteraction() {
        return userInteraction;
    }

    public void setUserInteraction(CvssV30Data .UserInteractionType userInteraction) {
        this.userInteraction = userInteraction;
    }

    public CvssV30Data .ScopeType getScope() {
        return scope;
    }

    public void setScope(CvssV30Data .ScopeType scope) {
        this.scope = scope;
    }

    public CvssV30Data .CiaType getConfidentialityImpact() {
        return confidentialityImpact;
    }

    public void setConfidentialityImpact(CvssV30Data .CiaType confidentialityImpact) {
        this.confidentialityImpact = confidentialityImpact;
    }

    public CvssV30Data .CiaType getIntegrityImpact() {
        return integrityImpact;
    }

    public void setIntegrityImpact(CvssV30Data .CiaType integrityImpact) {
        this.integrityImpact = integrityImpact;
    }

    public CvssV30Data .CiaType getAvailabilityImpact() {
        return availabilityImpact;
    }

    public void setAvailabilityImpact(CvssV30Data .CiaType availabilityImpact) {
        this.availabilityImpact = availabilityImpact;
    }

    /**
     * 
     * (Required)
     * 
     */
    public Double getBaseScore() {
        return baseScore;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setBaseScore(Double baseScore) {
        this.baseScore = baseScore;
    }

    /**
     * 
     * (Required)
     * 
     */
    public CvssV30Data .SeverityType getBaseSeverity() {
        return baseSeverity;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setBaseSeverity(CvssV30Data .SeverityType baseSeverity) {
        this.baseSeverity = baseSeverity;
    }

    public CvssV30Data .ExploitCodeMaturityType getExploitCodeMaturity() {
        return exploitCodeMaturity;
    }

    public void setExploitCodeMaturity(CvssV30Data .ExploitCodeMaturityType exploitCodeMaturity) {
        this.exploitCodeMaturity = exploitCodeMaturity;
    }

    public CvssV30Data .RemediationLevelType getRemediationLevel() {
        return remediationLevel;
    }

    public void setRemediationLevel(CvssV30Data .RemediationLevelType remediationLevel) {
        this.remediationLevel = remediationLevel;
    }

    public CvssV30Data .ConfidenceType getReportConfidence() {
        return reportConfidence;
    }

    public void setReportConfidence(CvssV30Data .ConfidenceType reportConfidence) {
        this.reportConfidence = reportConfidence;
    }

    public Double getTemporalScore() {
        return temporalScore;
    }

    public void setTemporalScore(Double temporalScore) {
        this.temporalScore = temporalScore;
    }

    public CvssV30Data .SeverityType getTemporalSeverity() {
        return temporalSeverity;
    }

    public void setTemporalSeverity(CvssV30Data .SeverityType temporalSeverity) {
        this.temporalSeverity = temporalSeverity;
    }

    public CvssV30Data .CiaRequirementType getConfidentialityRequirement() {
        return confidentialityRequirement;
    }

    public void setConfidentialityRequirement(CvssV30Data .CiaRequirementType confidentialityRequirement) {
        this.confidentialityRequirement = confidentialityRequirement;
    }

    public CvssV30Data .CiaRequirementType getIntegrityRequirement() {
        return integrityRequirement;
    }

    public void setIntegrityRequirement(CvssV30Data .CiaRequirementType integrityRequirement) {
        this.integrityRequirement = integrityRequirement;
    }

    public CvssV30Data .CiaRequirementType getAvailabilityRequirement() {
        return availabilityRequirement;
    }

    public void setAvailabilityRequirement(CvssV30Data .CiaRequirementType availabilityRequirement) {
        this.availabilityRequirement = availabilityRequirement;
    }

    public CvssV30Data .ModifiedAttackVectorType getModifiedAttackVector() {
        return modifiedAttackVector;
    }

    public void setModifiedAttackVector(CvssV30Data .ModifiedAttackVectorType modifiedAttackVector) {
        this.modifiedAttackVector = modifiedAttackVector;
    }

    public CvssV30Data .ModifiedAttackComplexityType getModifiedAttackComplexity() {
        return modifiedAttackComplexity;
    }

    public void setModifiedAttackComplexity(CvssV30Data .ModifiedAttackComplexityType modifiedAttackComplexity) {
        this.modifiedAttackComplexity = modifiedAttackComplexity;
    }

    public CvssV30Data .ModifiedPrivilegesRequiredType getModifiedPrivilegesRequired() {
        return modifiedPrivilegesRequired;
    }

    public void setModifiedPrivilegesRequired(CvssV30Data .ModifiedPrivilegesRequiredType modifiedPrivilegesRequired) {
        this.modifiedPrivilegesRequired = modifiedPrivilegesRequired;
    }

    public CvssV30Data .ModifiedUserInteractionType getModifiedUserInteraction() {
        return modifiedUserInteraction;
    }

    public void setModifiedUserInteraction(CvssV30Data .ModifiedUserInteractionType modifiedUserInteraction) {
        this.modifiedUserInteraction = modifiedUserInteraction;
    }

    public CvssV30Data .ModifiedScopeType getModifiedScope() {
        return modifiedScope;
    }

    public void setModifiedScope(CvssV30Data .ModifiedScopeType modifiedScope) {
        this.modifiedScope = modifiedScope;
    }

    public CvssV30Data .ModifiedCiaType getModifiedConfidentialityImpact() {
        return modifiedConfidentialityImpact;
    }

    public void setModifiedConfidentialityImpact(CvssV30Data .ModifiedCiaType modifiedConfidentialityImpact) {
        this.modifiedConfidentialityImpact = modifiedConfidentialityImpact;
    }

    public CvssV30Data .ModifiedCiaType getModifiedIntegrityImpact() {
        return modifiedIntegrityImpact;
    }

    public void setModifiedIntegrityImpact(CvssV30Data .ModifiedCiaType modifiedIntegrityImpact) {
        this.modifiedIntegrityImpact = modifiedIntegrityImpact;
    }

    public CvssV30Data .ModifiedCiaType getModifiedAvailabilityImpact() {
        return modifiedAvailabilityImpact;
    }

    public void setModifiedAvailabilityImpact(CvssV30Data .ModifiedCiaType modifiedAvailabilityImpact) {
        this.modifiedAvailabilityImpact = modifiedAvailabilityImpact;
    }

    public Double getEnvironmentalScore() {
        return environmentalScore;
    }

    public void setEnvironmentalScore(Double environmentalScore) {
        this.environmentalScore = environmentalScore;
    }

    public CvssV30Data .SeverityType getEnvironmentalSeverity() {
        return environmentalSeverity;
    }

    public void setEnvironmentalSeverity(CvssV30Data .SeverityType environmentalSeverity) {
        this.environmentalSeverity = environmentalSeverity;
    }

    @Generated("jsonschema2pojo")
    public enum AttackComplexityType {

        @SerializedName("HIGH")
        HIGH("HIGH"),
        @SerializedName("LOW")
        LOW("LOW");
        private final String value;
        private final static Map<String, CvssV30Data .AttackComplexityType> CONSTANTS = new HashMap<String, CvssV30Data .AttackComplexityType>();

        static {
            for (CvssV30Data .AttackComplexityType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        AttackComplexityType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV30Data .AttackComplexityType fromValue(String value) {
            CvssV30Data .AttackComplexityType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum AttackVectorType {

        @SerializedName("NETWORK")
        NETWORK("NETWORK"),
        @SerializedName("ADJACENT_NETWORK")
        ADJACENT_NETWORK("ADJACENT_NETWORK"),
        @SerializedName("LOCAL")
        LOCAL("LOCAL"),
        @SerializedName("PHYSICAL")
        PHYSICAL("PHYSICAL");
        private final String value;
        private final static Map<String, CvssV30Data .AttackVectorType> CONSTANTS = new HashMap<String, CvssV30Data .AttackVectorType>();

        static {
            for (CvssV30Data .AttackVectorType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        AttackVectorType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV30Data .AttackVectorType fromValue(String value) {
            CvssV30Data .AttackVectorType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum CiaRequirementType {

        @SerializedName("LOW")
        LOW("LOW"),
        @SerializedName("MEDIUM")
        MEDIUM("MEDIUM"),
        @SerializedName("HIGH")
        HIGH("HIGH"),
        @SerializedName("NOT_DEFINED")
        NOT_DEFINED("NOT_DEFINED");
        private final String value;
        private final static Map<String, CvssV30Data .CiaRequirementType> CONSTANTS = new HashMap<String, CvssV30Data .CiaRequirementType>();

        static {
            for (CvssV30Data .CiaRequirementType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        CiaRequirementType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV30Data .CiaRequirementType fromValue(String value) {
            CvssV30Data .CiaRequirementType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum CiaType {

        @SerializedName("NONE")
        NONE("NONE"),
        @SerializedName("LOW")
        LOW("LOW"),
        @SerializedName("HIGH")
        HIGH("HIGH");
        private final String value;
        private final static Map<String, CvssV30Data .CiaType> CONSTANTS = new HashMap<String, CvssV30Data .CiaType>();

        static {
            for (CvssV30Data .CiaType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        CiaType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV30Data .CiaType fromValue(String value) {
            CvssV30Data .CiaType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ConfidenceType {

        @SerializedName("UNKNOWN")
        UNKNOWN("UNKNOWN"),
        @SerializedName("REASONABLE")
        REASONABLE("REASONABLE"),
        @SerializedName("CONFIRMED")
        CONFIRMED("CONFIRMED"),
        @SerializedName("NOT_DEFINED")
        NOT_DEFINED("NOT_DEFINED");
        private final String value;
        private final static Map<String, CvssV30Data .ConfidenceType> CONSTANTS = new HashMap<String, CvssV30Data .ConfidenceType>();

        static {
            for (CvssV30Data .ConfidenceType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ConfidenceType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV30Data .ConfidenceType fromValue(String value) {
            CvssV30Data .ConfidenceType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ExploitCodeMaturityType {

        @SerializedName("UNPROVEN")
        UNPROVEN("UNPROVEN"),
        @SerializedName("PROOF_OF_CONCEPT")
        PROOF_OF_CONCEPT("PROOF_OF_CONCEPT"),
        @SerializedName("FUNCTIONAL")
        FUNCTIONAL("FUNCTIONAL"),
        @SerializedName("HIGH")
        HIGH("HIGH"),
        @SerializedName("NOT_DEFINED")
        NOT_DEFINED("NOT_DEFINED");
        private final String value;
        private final static Map<String, CvssV30Data .ExploitCodeMaturityType> CONSTANTS = new HashMap<String, CvssV30Data .ExploitCodeMaturityType>();

        static {
            for (CvssV30Data .ExploitCodeMaturityType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ExploitCodeMaturityType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV30Data .ExploitCodeMaturityType fromValue(String value) {
            CvssV30Data .ExploitCodeMaturityType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ModifiedAttackComplexityType {

        @SerializedName("HIGH")
        HIGH("HIGH"),
        @SerializedName("LOW")
        LOW("LOW"),
        @SerializedName("NOT_DEFINED")
        NOT_DEFINED("NOT_DEFINED");
        private final String value;
        private final static Map<String, CvssV30Data .ModifiedAttackComplexityType> CONSTANTS = new HashMap<String, CvssV30Data .ModifiedAttackComplexityType>();

        static {
            for (CvssV30Data .ModifiedAttackComplexityType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ModifiedAttackComplexityType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV30Data .ModifiedAttackComplexityType fromValue(String value) {
            CvssV30Data .ModifiedAttackComplexityType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ModifiedAttackVectorType {

        @SerializedName("NETWORK")
        NETWORK("NETWORK"),
        @SerializedName("ADJACENT_NETWORK")
        ADJACENT_NETWORK("ADJACENT_NETWORK"),
        @SerializedName("LOCAL")
        LOCAL("LOCAL"),
        @SerializedName("PHYSICAL")
        PHYSICAL("PHYSICAL"),
        @SerializedName("NOT_DEFINED")
        NOT_DEFINED("NOT_DEFINED");
        private final String value;
        private final static Map<String, CvssV30Data .ModifiedAttackVectorType> CONSTANTS = new HashMap<String, CvssV30Data .ModifiedAttackVectorType>();

        static {
            for (CvssV30Data .ModifiedAttackVectorType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ModifiedAttackVectorType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV30Data .ModifiedAttackVectorType fromValue(String value) {
            CvssV30Data .ModifiedAttackVectorType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ModifiedCiaType {

        @SerializedName("NONE")
        NONE("NONE"),
        @SerializedName("LOW")
        LOW("LOW"),
        @SerializedName("HIGH")
        HIGH("HIGH"),
        @SerializedName("NOT_DEFINED")
        NOT_DEFINED("NOT_DEFINED");
        private final String value;
        private final static Map<String, CvssV30Data .ModifiedCiaType> CONSTANTS = new HashMap<String, CvssV30Data .ModifiedCiaType>();

        static {
            for (CvssV30Data .ModifiedCiaType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ModifiedCiaType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV30Data .ModifiedCiaType fromValue(String value) {
            CvssV30Data .ModifiedCiaType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ModifiedPrivilegesRequiredType {

        @SerializedName("HIGH")
        HIGH("HIGH"),
        @SerializedName("LOW")
        LOW("LOW"),
        @SerializedName("NONE")
        NONE("NONE"),
        @SerializedName("NOT_DEFINED")
        NOT_DEFINED("NOT_DEFINED");
        private final String value;
        private final static Map<String, CvssV30Data .ModifiedPrivilegesRequiredType> CONSTANTS = new HashMap<String, CvssV30Data .ModifiedPrivilegesRequiredType>();

        static {
            for (CvssV30Data .ModifiedPrivilegesRequiredType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ModifiedPrivilegesRequiredType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV30Data .ModifiedPrivilegesRequiredType fromValue(String value) {
            CvssV30Data .ModifiedPrivilegesRequiredType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ModifiedScopeType {

        @SerializedName("UNCHANGED")
        UNCHANGED("UNCHANGED"),
        @SerializedName("CHANGED")
        CHANGED("CHANGED"),
        @SerializedName("NOT_DEFINED")
        NOT_DEFINED("NOT_DEFINED");
        private final String value;
        private final static Map<String, CvssV30Data .ModifiedScopeType> CONSTANTS = new HashMap<String, CvssV30Data .ModifiedScopeType>();

        static {
            for (CvssV30Data .ModifiedScopeType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ModifiedScopeType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV30Data .ModifiedScopeType fromValue(String value) {
            CvssV30Data .ModifiedScopeType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ModifiedUserInteractionType {

        @SerializedName("NONE")
        NONE("NONE"),
        @SerializedName("REQUIRED")
        REQUIRED("REQUIRED"),
        @SerializedName("NOT_DEFINED")
        NOT_DEFINED("NOT_DEFINED");
        private final String value;
        private final static Map<String, CvssV30Data .ModifiedUserInteractionType> CONSTANTS = new HashMap<String, CvssV30Data .ModifiedUserInteractionType>();

        static {
            for (CvssV30Data .ModifiedUserInteractionType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ModifiedUserInteractionType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV30Data .ModifiedUserInteractionType fromValue(String value) {
            CvssV30Data .ModifiedUserInteractionType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum PrivilegesRequiredType {

        @SerializedName("HIGH")
        HIGH("HIGH"),
        @SerializedName("LOW")
        LOW("LOW"),
        @SerializedName("NONE")
        NONE("NONE");
        private final String value;
        private final static Map<String, CvssV30Data .PrivilegesRequiredType> CONSTANTS = new HashMap<String, CvssV30Data .PrivilegesRequiredType>();

        static {
            for (CvssV30Data .PrivilegesRequiredType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        PrivilegesRequiredType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV30Data .PrivilegesRequiredType fromValue(String value) {
            CvssV30Data .PrivilegesRequiredType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum RemediationLevelType {

        @SerializedName("OFFICIAL_FIX")
        OFFICIAL_FIX("OFFICIAL_FIX"),
        @SerializedName("TEMPORARY_FIX")
        TEMPORARY_FIX("TEMPORARY_FIX"),
        @SerializedName("WORKAROUND")
        WORKAROUND("WORKAROUND"),
        @SerializedName("UNAVAILABLE")
        UNAVAILABLE("UNAVAILABLE"),
        @SerializedName("NOT_DEFINED")
        NOT_DEFINED("NOT_DEFINED");
        private final String value;
        private final static Map<String, CvssV30Data .RemediationLevelType> CONSTANTS = new HashMap<String, CvssV30Data .RemediationLevelType>();

        static {
            for (CvssV30Data .RemediationLevelType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        RemediationLevelType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV30Data .RemediationLevelType fromValue(String value) {
            CvssV30Data .RemediationLevelType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ScopeType {

        @SerializedName("UNCHANGED")
        UNCHANGED("UNCHANGED"),
        @SerializedName("CHANGED")
        CHANGED("CHANGED");
        private final String value;
        private final static Map<String, CvssV30Data .ScopeType> CONSTANTS = new HashMap<String, CvssV30Data .ScopeType>();

        static {
            for (CvssV30Data .ScopeType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ScopeType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV30Data .ScopeType fromValue(String value) {
            CvssV30Data .ScopeType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum SeverityType {

        @SerializedName("NONE")
        NONE("NONE"),
        @SerializedName("LOW")
        LOW("LOW"),
        @SerializedName("MEDIUM")
        MEDIUM("MEDIUM"),
        @SerializedName("HIGH")
        HIGH("HIGH"),
        @SerializedName("CRITICAL")
        CRITICAL("CRITICAL");
        private final String value;
        private final static Map<String, CvssV30Data .SeverityType> CONSTANTS = new HashMap<String, CvssV30Data .SeverityType>();

        static {
            for (CvssV30Data .SeverityType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        SeverityType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV30Data .SeverityType fromValue(String value) {
            CvssV30Data .SeverityType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum UserInteractionType {

        @SerializedName("NONE")
        NONE("NONE"),
        @SerializedName("REQUIRED")
        REQUIRED("REQUIRED");
        private final String value;
        private final static Map<String, CvssV30Data .UserInteractionType> CONSTANTS = new HashMap<String, CvssV30Data .UserInteractionType>();

        static {
            for (CvssV30Data .UserInteractionType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        UserInteractionType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV30Data .UserInteractionType fromValue(String value) {
            CvssV30Data .UserInteractionType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }


    /**
     * CVSS Version
     * 
     */
    @Generated("jsonschema2pojo")
    public enum Version {

        @SerializedName("3.0")
        _3_0("3.0");
        private final String value;
        private final static Map<String, CvssV30Data .Version> CONSTANTS = new HashMap<String, CvssV30Data .Version>();

        static {
            for (CvssV30Data .Version c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Version(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV30Data .Version fromValue(String value) {
            CvssV30Data .Version constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
