/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.events;

import de.uka.ipd.sdq.workflow.launchconfig.tabs.TabHelper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.palladiosimulator.analyzer.workflow.core.ConstantsContainer;
import org.palladiosimulator.simulizar.events.Activator;

public class EventsTransformationExtensionTab
extends AbstractLaunchConfigurationTab {
    private static final Boolean DEFAULT_SIMULATE_EVENTS = false;
    private Image infoImage;
    private Button simulateFailuresButton;
    private Text eventMiddlewareRepository;
    private Button storeTransformedModelsButton;
    private Text storeTransformedModelsProject;

    public final void createControl(Composite parent) {
        this.infoImage = EventsTransformationExtensionTab.getImage("information.png");
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                EventsTransformationExtensionTab.this.setDirty(true);
                EventsTransformationExtensionTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetSelected(SelectionEvent e) {
                EventsTransformationExtensionTab.this.setDirty(true);
                EventsTransformationExtensionTab.this.updateLaunchConfigurationDialog();
            }
        };
        ModifyListener modifyListener = e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        };
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout());
        CLabel lblChooseEventSimInfo = new CLabel(container, 0);
        lblChooseEventSimInfo.setText("These settings are only effective when using SimuLizar.");
        lblChooseEventSimInfo.setImage(this.infoImage);
        Group eventGroup = new Group(container, 0);
        eventGroup.setText("Events");
        GridData gdReliabilityGroup = new GridData(4, 0x1000000, true, false);
        eventGroup.setLayoutData((Object)gdReliabilityGroup);
        eventGroup.setLayout((Layout)new GridLayout());
        this.simulateFailuresButton = new Button((Composite)eventGroup, 32);
        GridData gdSimulateEventsButton = new GridData(4, 0x1000000, true, false);
        this.simulateFailuresButton.setLayoutData((Object)gdSimulateEventsButton);
        this.simulateFailuresButton.setText("Simulate Events");
        this.simulateFailuresButton.addSelectionListener(selectionListener);
        this.eventMiddlewareRepository = new Text(container, 2052);
        TabHelper.createFileInputSection((Composite)container, (ModifyListener)modifyListener, (String)"Event Middleware Repository File", (String[])ConstantsContainer.REPOSITORY_EXTENSION, (Text)this.eventMiddlewareRepository, (String)"Select Event Middleware Repository File", (Shell)this.getShell(), (String)"pathmap://PCM_MODELS/default_event_middleware.repository");
        Group temporaryGroup = new Group(container, 0);
        temporaryGroup.setText("Storage");
        GridData gdTemporaryGroup = new GridData(4, 0x1000000, true, false);
        temporaryGroup.setLayoutData((Object)gdTemporaryGroup);
        temporaryGroup.setLayout((Layout)new GridLayout());
        this.storeTransformedModelsButton = new Button((Composite)temporaryGroup, 32);
        this.storeTransformedModelsButton.setText("Store Transformed Models");
        this.storeTransformedModelsButton.addSelectionListener(selectionListener);
        this.storeTransformedModelsProject = new Text((Composite)temporaryGroup, 2052);
        this.storeTransformedModelsProject.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.storeTransformedModelsProject.addModifyListener(modifyListener);
    }

    private static Image getImage(String file) {
        return Activator.imageDescriptorFromPlugin((String)"org.palladiosimulator.simulizar.events", (String)("icons/" + file)).createImage();
    }

    public final String getName() {
        return "Events Transformation";
    }

    public final void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.simulateFailuresButton.setSelection(configuration.getAttribute("simulateEvents", true));
            this.eventMiddlewareRepository.setText(configuration.getAttribute("eventMiddleware", "pathmap://PCM_MODELS/default_event_middleware.repository"));
            this.storeTransformedModelsButton.setSelection(configuration.getAttribute("storeTransformedModels", true));
            this.storeTransformedModelsProject.setText(configuration.getAttribute("storageProject", "org.palladiosimulator.temporary"));
        }
        catch (CoreException e) {
            this.simulateFailuresButton.setSelection(false);
            this.eventMiddlewareRepository.setText("pathmap://PCM_MODELS/default_event_middleware.repository");
            this.storeTransformedModelsButton.setSelection(true);
            this.storeTransformedModelsProject.setText("org.palladiosimulator.temporary");
        }
    }

    public final void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("simulateEvents", this.simulateFailuresButton.getSelection());
        configuration.setAttribute("eventMiddleware", this.eventMiddlewareRepository.getText());
        configuration.setAttribute("storeTransformedModels", this.storeTransformedModelsButton.getSelection());
        configuration.setAttribute("storageProject", this.storeTransformedModelsProject.getText());
    }

    public final void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("simulateEvents", (Object)DEFAULT_SIMULATE_EVENTS);
        configuration.setAttribute("eventMiddleware", "pathmap://PCM_MODELS/default_event_middleware.repository");
        configuration.setAttribute("storeTransformedModels", true);
        configuration.setAttribute("storageProject", "org.palladiosimulator.temporary");
    }
}

