/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.interpreter.listener;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.util.MetricDescriptionUtility;
import org.palladiosimulator.measurementframework.listener.IMeasurementSourceListener;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.probeframework.calculator.Calculator;
import org.palladiosimulator.probeframework.calculator.CalculatorRegistryListener;
import org.palladiosimulator.probeframework.calculator.IObservableCalculatorRegistry;

public abstract class DeferredMeasurementInitialization {
    private static final Logger LOGGER = Logger.getLogger(DeferredMeasurementInitialization.class);

    public static DeferredMeasurementInitialization forCalculatorFactoryDecorator(IObservableCalculatorRegistry registryAccess) {
        return registryAccess.getObservers().stream().filter(DeferredMeasurementInitializationImpl.class::isInstance).map(DeferredMeasurementInitializationImpl.class::cast).filter(dmi -> dmi.registryAccess.equals(registryAccess)).findAny().orElseGet(() -> new DeferredMeasurementInitializationImpl(registryAccess));
    }

    public abstract void onMetricDescriptionAndMeasuringPoint(MetricDescription var1, MeasuringPoint var2, Supplier<IMeasurementSourceListener> var3);

    private static final class DeferredMeasurementInitializationImpl
    extends DeferredMeasurementInitialization
    implements CalculatorRegistryListener {
        private final IObservableCalculatorRegistry registryAccess;
        private final Map<String, Map<MetricDescription, Set<Supplier<IMeasurementSourceListener>>>> deferredInitializations = new HashMap<String, Map<MetricDescription, Set<Supplier<IMeasurementSourceListener>>>>();

        private DeferredMeasurementInitializationImpl(IObservableCalculatorRegistry registryAccess) {
            this.registryAccess = registryAccess;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyCalculatorRegistration(Calculator calculator) {
            Map<String, Map<MetricDescription, Set<Supplier<IMeasurementSourceListener>>>> map = this.deferredInitializations;
            synchronized (map) {
                if (this.deferredInitializations.containsKey(calculator.getMeasuringPoint().getStringRepresentation())) {
                    Map<MetricDescription, Set<Supplier<IMeasurementSourceListener>>> callbacks = this.deferredInitializations.get(calculator.getMeasuringPoint().getStringRepresentation());
                    callbacks.keySet().stream().filter(metricDesc -> {
                        block3: {
                            block2: {
                                if (metricDesc.getId().equals(calculator.getMetricDesciption().getId())) break block2;
                                if (!(metricDesc instanceof BaseMetricDescription) || !MetricDescriptionUtility.isBaseMetricDescriptionSubsumedByMetricDescription((BaseMetricDescription)((BaseMetricDescription)metricDesc), (MetricDescription)calculator.getMetricDesciption())) break block3;
                            }
                            this.deferredInitializations.get(calculator.getMeasuringPoint().getStringRepresentation()).get(metricDesc).stream().map(Supplier::get).forEach(arg_0 -> ((Calculator)calculator).addObserver(arg_0));
                            return true;
                        }
                        return false;
                    }).collect(Collectors.toList()).forEach(callbacks::remove);
                    if (callbacks.isEmpty()) {
                        this.deferredInitializations.remove(calculator.getMeasuringPoint().getStringRepresentation());
                    }
                    if (this.deferredInitializations.isEmpty()) {
                        this.registryAccess.removeObserver((Object)this);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMetricDescriptionAndMeasuringPoint(MetricDescription desc, MeasuringPoint mp, Supplier<IMeasurementSourceListener> supplier) {
            Objects.requireNonNull(desc);
            Objects.requireNonNull(mp);
            Objects.requireNonNull(supplier);
            Map<String, Map<MetricDescription, Set<Supplier<IMeasurementSourceListener>>>> map = this.deferredInitializations;
            synchronized (map) {
                Optional<Calculator> baseCalculator = this.getBaseCalculator(desc, mp);
                if (baseCalculator.isPresent()) {
                    baseCalculator.get().addObserver(supplier.get());
                } else {
                    if (this.deferredInitializations.isEmpty()) {
                        if (this.registryAccess.getObservers().contains(this)) {
                            LOGGER.warn((Object)String.format("Deferred initialization is already registered as a listener. Metric: %s MeasuringPoint: %s", desc.getName(), mp.getStringRepresentation()));
                        } else {
                            this.registryAccess.addObserver((Object)this);
                        }
                    }
                    this.deferredInitializations.computeIfAbsent(mp.getStringRepresentation(), s -> new HashMap()).computeIfAbsent(desc, d -> new HashSet()).add(supplier);
                }
            }
        }

        private Optional<Calculator> getBaseCalculator(MetricDescription metric, MeasuringPoint measuringPoint) {
            Calculator baseCalculator = this.registryAccess.getCalculatorByMeasuringPointAndMetricDescription(measuringPoint, metric);
            if (baseCalculator == null && metric instanceof BaseMetricDescription) {
                return this.registryAccess.getCalculatorsForMeasuringPoint(measuringPoint).stream().filter(calc -> MetricDescriptionUtility.isBaseMetricDescriptionSubsumedByMetricDescription((BaseMetricDescription)((BaseMetricDescription)metric), (MetricDescription)calc.getMetricDesciption())).findAny();
            }
            return Optional.ofNullable(baseCalculator);
        }
    }
}

