/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.launcher;

import de.uka.ipd.sdq.codegen.simucontroller.core.runconfig.SimuComWorkflowConfiguration;
import de.uka.ipd.sdq.codegen.simucontroller.runconfig.SimuComWorkflowLauncher;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.launchconfig.core.AbstractWorkflowBasedRunConfiguration;
import de.uka.ipd.sdq.workflow.logging.console.LoggerAppenderStruct;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.log4j.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.palladiosimulator.analyzer.workflow.core.configurations.PCMWorkflowConfigurationBuilder;
import org.palladiosimulator.simulizar.SimuLizarPlatform;
import org.palladiosimulator.simulizar.core.runconfig.SimuLizarWorkflowConfiguration;
import org.palladiosimulator.simulizar.di.component.core.SimuLizarRootComponent;
import org.palladiosimulator.simulizar.runconfig.SimuLizarLaunchConfigurationBasedConfigBuilder;

public class PCMInterpreterLauncher
extends SimuComWorkflowLauncher {
    private Optional<MDSDBlackboard> blackboard = Optional.empty();

    protected MDSDBlackboard createBlackboard() {
        return this.blackboard.orElseGet(() -> super.createBlackboard());
    }

    protected IJob createWorkflowJob(SimuComWorkflowConfiguration config, ILaunch launch) throws CoreException {
        if (!(config instanceof SimuLizarWorkflowConfiguration)) {
            throw new IllegalArgumentException("SimuLizarWorkflowConfiguration expected for PCMInterpreterLauncher");
        }
        SimuLizarRootComponent rootComponent = SimuLizarPlatform.getPlatformComponent().analysisFactory().create((SimuLizarWorkflowConfiguration)config);
        this.blackboard = Optional.of(rootComponent.blackboard());
        return rootComponent.rootJob();
    }

    protected List<LoggerAppenderStruct> setupLogging(Level logLevel) throws CoreException {
        ArrayList<LoggerAppenderStruct> result = new ArrayList<LoggerAppenderStruct>(super.setupLogging(logLevel));
        result.add(this.setupLogger("org.palladiosimulator.simulizar", logLevel, Level.DEBUG == logLevel ? "%-8r [%-10t] %-5p: %m [%c]%n" : "[%-10t] %-5p: %m%n"));
        result.add(this.setupLogger("de.uka.ipd.sdq.probfunction.math.apache.impl", logLevel, Level.DEBUG == logLevel ? "%-8r [%-10t] %-5p: %m [%c]%n" : "[%-10t] %-5p: %m%n"));
        return result;
    }

    protected SimuLizarWorkflowConfiguration deriveConfiguration(ILaunchConfiguration configuration, String mode) throws CoreException {
        SimuLizarWorkflowConfiguration config = new SimuLizarWorkflowConfiguration(configuration.getAttributes());
        Object builder = new PCMWorkflowConfigurationBuilder(configuration, mode);
        builder.fillConfiguration((AbstractWorkflowBasedRunConfiguration)config);
        builder = new SimuLizarLaunchConfigurationBasedConfigBuilder(configuration, mode);
        builder.fillConfiguration((AbstractWorkflowBasedRunConfiguration)config);
        return config;
    }
}

