/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.builder;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.pcm.core.composition.ComposedStructure;
import org.palladiosimulator.pcm.core.composition.CompositionFactory;
import org.palladiosimulator.pcm.core.composition.ProvidedDelegationConnector;
import org.palladiosimulator.pcm.core.composition.RequiredDelegationConnector;
import org.palladiosimulator.pcm.core.entity.InterfaceRequiringEntity;
import org.palladiosimulator.pcm.repository.CompositeComponent;
import org.palladiosimulator.pcm.repository.Interface;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.RepositoryFactory;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.Role;
import org.somox.analyzer.AnalysisResult;
import org.somox.analyzer.simplemodelanalyzer.builder.AbstractBuilder;
import org.somox.analyzer.simplemodelanalyzer.builder.ComponentAndTypeNaming;
import org.somox.analyzer.simplemodelanalyzer.builder.IRoleBuilderStrategy;
import org.somox.analyzer.simplemodelanalyzer.builder.util.EndpointInformation;
import org.somox.analyzer.simplemodelanalyzer.builder.util.InterfacePortBuilderHelper;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.kdmhelper.metamodeladdition.Root;
import org.somox.sourcecodedecorator.ComponentImplementingClassesLink;
import org.somox.sourcecodedecorator.InterfaceSourceCodeLink;
import org.somox.sourcecodedecorator.SourceCodeDecoratorRepository;
import org.somox.sourcecodedecorator.SourcecodedecoratorFactory;

public class NonDuplicatingInterfacePortBuilder
extends AbstractBuilder
implements IRoleBuilderStrategy {
    private static final Logger logger = Logger.getLogger(NonDuplicatingInterfacePortBuilder.class);
    private final ComponentAndTypeNaming componentTypeNaming;

    public NonDuplicatingInterfacePortBuilder(Root gastModel, SoMoXConfiguration somoxConfiguration, AnalysisResult analysisResult, ComponentAndTypeNaming componentTypeNaming) {
        super(gastModel, somoxConfiguration, analysisResult);
        this.componentTypeNaming = componentTypeNaming;
    }

    @Override
    public List<OperationProvidedRole> buildProvidedRole(ComponentImplementingClassesLink componentLink) {
        assert (componentLink.isIsCompositeComponent());
        LinkedList<OperationProvidedRole> roles = new LinkedList<OperationProvidedRole>();
        if (!(componentLink.getComponent() instanceof ComposedStructure)) {
            throw new IllegalArgumentException("Only composite components should use this builder.");
        }
        ComposedStructure resultCompositeComponent = (ComposedStructure)componentLink.getComponent();
        Iterable<EndpointInformation> interfaceLinksNotUsedInConnectors = InterfacePortBuilderHelper.collectInformationOnNonBoundInterfaces(componentLink, resultCompositeComponent, true);
        for (EndpointInformation currentInterfaceLink : interfaceLinksNotUsedInConnectors) {
            roles.add(this.createProvidedRoleAndConnector(componentLink, currentInterfaceLink));
        }
        return roles;
    }

    @Override
    public List<OperationRequiredRole> buildRequiredRole(ComponentImplementingClassesLink componentLink) {
        assert (componentLink.isIsCompositeComponent());
        LinkedList<OperationRequiredRole> roles = new LinkedList<OperationRequiredRole>();
        if (!(componentLink.getComponent() instanceof ComposedStructure)) {
            throw new IllegalArgumentException("Only composite components should use this builder.");
        }
        ComposedStructure resultCompositeComponent = (ComposedStructure)componentLink.getComponent();
        Iterable<EndpointInformation> interfaceLinksNotUsedInConnectors = InterfacePortBuilderHelper.collectInformationOnNonBoundInterfaces(componentLink, resultCompositeComponent, false);
        for (EndpointInformation currentInterfaceLink : interfaceLinksNotUsedInConnectors) {
            roles.add(this.createRequiredRoleAndConnector(componentLink, currentInterfaceLink));
        }
        return roles;
    }

    private OperationProvidedRole createProvidedRoleAndConnector(ComponentImplementingClassesLink compositeComponentLink, EndpointInformation subComponentInformation) {
        if (!(compositeComponentLink.getComponent() instanceof CompositeComponent)) {
            throw new RuntimeException("must be a composite component");
        }
        Interface searchedInterface = subComponentInformation.getInterfaceSourceCodeLink().getInterface();
        OperationProvidedRole providedRole = this.findProvidedRoleInComponent(compositeComponentLink.getComponent(), searchedInterface);
        if (providedRole == null) {
            providedRole = RepositoryFactory.eINSTANCE.createOperationProvidedRole();
            providedRole.setEntityName(this.componentTypeNaming.createProvidedPortName(searchedInterface, compositeComponentLink.getComponent()));
            if (searchedInterface instanceof OperationInterface) {
                providedRole.setProvidedInterface__OperationProvidedRole((OperationInterface)searchedInterface);
            } else {
                logger.error((Object)("interface type not yet supported: " + searchedInterface.getClass().getSimpleName()));
            }
            compositeComponentLink.getComponent().getProvidedRoles_InterfaceProvidingEntity().add((Object)providedRole);
            this.createDelegationConnector(compositeComponentLink, providedRole, subComponentInformation);
            if (subComponentInformation.getInterfaceSourceCodeLink().getInterface() != null) {
                InterfaceSourceCodeLink newInterfaceLink = SourcecodedecoratorFactory.eINSTANCE.createInterfaceSourceCodeLink();
                newInterfaceLink.setInterface(subComponentInformation.getInterfaceSourceCodeLink().getInterface());
                newInterfaceLink.setGastClass(subComponentInformation.getInterfaceSourceCodeLink().getGastClass());
                compositeComponentLink.getProvidedInterfaces().add((Object)newInterfaceLink);
                SourceCodeDecoratorRepository parentRepository = (SourceCodeDecoratorRepository)compositeComponentLink.eContainer();
                parentRepository.getInterfaceSourceCodeLink().add((Object)newInterfaceLink);
            } else {
                logger.warn((Object)"Source code decorator: InterfaceLink had no interface or class set.");
            }
        }
        return providedRole;
    }

    private OperationRequiredRole createRequiredRoleAndConnector(ComponentImplementingClassesLink compositeComponentLink, EndpointInformation subComponentInformation) {
        OperationRequiredRole requiredRole = null;
        Set<Interface> allRequiredInterfaces = this.collectInterfacesForComponent(compositeComponentLink, false);
        if (!allRequiredInterfaces.contains(linkedInterface = subComponentInformation.getInterfaceSourceCodeLink().getInterface())) {
            requiredRole = RepositoryFactory.eINSTANCE.createOperationRequiredRole();
            if (linkedInterface == null) {
                logger.warn((Object)"Source code decorator: InterfaceLink had no interface or class set.");
            } else if (linkedInterface instanceof OperationInterface) {
                requiredRole.setRequiredInterface__OperationRequiredRole((OperationInterface)linkedInterface);
                requiredRole.setEntityName(this.componentTypeNaming.createRequiredPortName(subComponentInformation.getInterfaceSourceCodeLink().getInterface(), compositeComponentLink.getComponent()));
                requiredRole.setRequiringEntity_RequiredRole((InterfaceRequiringEntity)compositeComponentLink.getComponent());
                compositeComponentLink.getComponent().getRequiredRoles_InterfaceRequiringEntity().add((Object)requiredRole);
                InterfaceSourceCodeLink newInterfaceLink = SourcecodedecoratorFactory.eINSTANCE.createInterfaceSourceCodeLink();
                newInterfaceLink.setInterface(subComponentInformation.getInterfaceSourceCodeLink().getInterface());
                newInterfaceLink.setGastClass(subComponentInformation.getInterfaceSourceCodeLink().getGastClass());
                compositeComponentLink.getRequiredInterfaces().add((Object)newInterfaceLink);
                SourceCodeDecoratorRepository parentRepository = (SourceCodeDecoratorRepository)compositeComponentLink.eContainer();
                parentRepository.getInterfaceSourceCodeLink().add((Object)newInterfaceLink);
            } else {
                logger.warn((Object)("Interface type yet not supported: " + linkedInterface.getClass().getSimpleName()));
            }
        } else {
            for (RequiredRole currentRequiredRole : compositeComponentLink.getComponent().getRequiredRoles_InterfaceRequiringEntity()) {
                if (currentRequiredRole instanceof OperationRequiredRole var8_10) {
                    if (!opReqRole.getRequiredInterface__OperationRequiredRole().equals(linkedInterface)) continue;
                    requiredRole = opReqRole;
                    continue;
                }
                logger.warn((Object)("Required role type yet not supported: " + currentRequiredRole.getClass().getSimpleName()));
            }
        }
        if (requiredRole != null) {
            this.createDelegationConnector(compositeComponentLink, requiredRole, subComponentInformation);
        } else {
            logger.warn((Object)"Could not find a required interface port which should have existed.");
        }
        return requiredRole;
    }

    private void createDelegationConnector(ComponentImplementingClassesLink compositeComponentLink, OperationProvidedRole outerRole, EndpointInformation subComponentInformation) {
        ProvidedDelegationConnector delegationConnector = CompositionFactory.eINSTANCE.createProvidedDelegationConnector();
        ((CompositeComponent)compositeComponentLink.getComponent()).getConnectors__ComposedStructure().add((Object)delegationConnector);
        delegationConnector.setOuterProvidedRole_ProvidedDelegationConnector(outerRole);
        Role innerRole = subComponentInformation.getRole();
        if (innerRole instanceof OperationProvidedRole) {
            delegationConnector.setInnerProvidedRole_ProvidedDelegationConnector((OperationProvidedRole)innerRole);
            delegationConnector.setAssemblyContext_ProvidedDelegationConnector(subComponentInformation.getAssemblyContext());
        } else {
            logger.warn((Object)("Role not supported yet: " + innerRole.getClass().getSimpleName()));
        }
        this.componentTypeNaming.createProvidedDelegationConnectorName(delegationConnector);
    }

    private void createDelegationConnector(ComponentImplementingClassesLink compositeComponentLink, OperationRequiredRole outerRole, EndpointInformation subComponentInformation) {
        RequiredDelegationConnector delegationConnector = CompositionFactory.eINSTANCE.createRequiredDelegationConnector();
        delegationConnector.setOuterRequiredRole_RequiredDelegationConnector(outerRole);
        Role innerRole = subComponentInformation.getRole();
        if (innerRole instanceof OperationRequiredRole) {
            delegationConnector.setInnerRequiredRole_RequiredDelegationConnector((OperationRequiredRole)innerRole);
            delegationConnector.setAssemblyContext_RequiredDelegationConnector(subComponentInformation.getAssemblyContext());
        } else {
            logger.warn((Object)("Role not supported yet: " + innerRole.getClass().getSimpleName()));
        }
        this.componentTypeNaming.createRequiredDelegationConnectorName(delegationConnector);
        ((CompositeComponent)compositeComponentLink.getComponent()).getConnectors__ComposedStructure().add((Object)delegationConnector);
    }

    /*
     * WARNING - void declaration
     */
    private OperationProvidedRole findProvidedRoleInComponent(RepositoryComponent component, Interface searchedInterface) {
        for (ProvidedRole existingRole : component.getProvidedRoles_InterfaceProvidingEntity()) {
            void opProvRole;
            OperationProvidedRole operationProvidedRole;
            ProvidedRole providedRole = existingRole;
            if (!(providedRole instanceof OperationProvidedRole) || (operationProvidedRole = (OperationProvidedRole)providedRole) != (OperationProvidedRole)providedRole || opProvRole.getProvidedInterface__OperationProvidedRole() == null || !opProvRole.getProvidedInterface__OperationProvidedRole().equals(searchedInterface)) continue;
            return opProvRole;
        }
        return null;
    }

    private Set<Interface> collectInterfacesForComponent(ComponentImplementingClassesLink compositeComponentLink, boolean collectProvided) {
        HashSet<Interface> returnInterfaces = new HashSet<Interface>();
        EList ifLinks = collectProvided ? compositeComponentLink.getProvidedInterfaces() : compositeComponentLink.getRequiredInterfaces();
        for (InterfaceSourceCodeLink currentIfLink : ifLinks) {
            returnInterfaces.add(currentIfLink.getInterface());
        }
        return returnInterfaces;
    }
}

