/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.palladiosimulator.pcm.core.entity.ComposedProvidingRequiringEntity;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.Interface;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.RepositoryFactory;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.Role;
import org.somox.analyzer.AnalysisResult;
import org.somox.analyzer.simplemodelanalyzer.builder.AbstractBuilder;
import org.somox.analyzer.simplemodelanalyzer.builder.AssemblyConnectorsInsideCompositeComponentStrategy;
import org.somox.analyzer.simplemodelanalyzer.builder.ComponentAndTypeNaming;
import org.somox.analyzer.simplemodelanalyzer.builder.OperationBuilder;
import org.somox.analyzer.simplemodelanalyzer.builder.Seff2JavaASTBuilder;
import org.somox.analyzer.simplemodelanalyzer.builder.util.InterfacePortBuilderHelper;
import org.somox.analyzer.simplemodelanalyzer.detection.ComponentInterfaceStrategy;
import org.somox.analyzer.simplemodelanalyzer.detection.IComponentInterfaceStrategy;
import org.somox.analyzer.simplemodelanalyzer.detection.util.AccessFilter;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.filter.EClassBasedFilter;
import org.somox.kdmhelper.KDMHelper;
import org.somox.kdmhelper.metamodeladdition.Root;
import org.somox.sourcecodedecorator.ComponentImplementingClassesLink;
import org.somox.sourcecodedecorator.InterfaceSourceCodeLink;
import org.somox.sourcecodedecorator.SourcecodedecoratorFactory;
import tools.mdsd.jamopp.model.java.classifiers.Classifier;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.types.ClassifierReference;
import tools.mdsd.jamopp.model.java.types.Type;
import tools.mdsd.jamopp.model.java.types.TypeReference;

public class InterfaceBuilder
extends AbstractBuilder {
    private final Map<Type, OperationInterface> alreadyCreatedInterfaces = new HashMap<Type, OperationInterface>();
    private static Logger logger = Logger.getLogger(InterfaceBuilder.class);
    private OperationBuilder operationBuilder = null;
    private Seff2JavaASTBuilder behaviourBuilder = null;
    private ComponentAndTypeNaming naming = null;
    private IComponentInterfaceStrategy interfaceStrategy = null;
    public static final boolean PROVIDED_INTERFACE = true;

    public InterfaceBuilder(Root gastModel, SoMoXConfiguration configuration, AnalysisResult result) {
        super(gastModel, configuration, result);
        logger.debug((Object)"Interface builder initialised");
        this.operationBuilder = new OperationBuilder(gastModel, configuration, result);
        this.behaviourBuilder = new Seff2JavaASTBuilder(gastModel, configuration, result);
        this.naming = new ComponentAndTypeNaming();
        this.interfaceStrategy = new ComponentInterfaceStrategy(result.getSourceCodeDecoratorRepository());
    }

    public boolean findAndAddRequiredInterfaces(ComponentImplementingClassesLink componentCandidate) {
        boolean addedARequiredInterface = false;
        EClassBasedFilter accessFilter = new EClassBasedFilter(new EClass[0]);
        LinkedList<ConcreteClassifier> filteredAccessedClasses = new LinkedList<ConcreteClassifier>();
        LinkedList<ConcreteClassifier> componentClasses = new LinkedList<ConcreteClassifier>();
        for (ConcreteClassifier clazz : componentCandidate.getImplementingClasses()) {
            List<ConcreteClassifier> filteredAccessList = AccessFilter.filterAccessList(KDMHelper.getAllAccesses((Commentable)clazz), (EClassBasedFilter<TypeReference>)accessFilter);
            filteredAccessedClasses.addAll(filteredAccessList);
            componentClasses.add(clazz);
        }
        filteredAccessedClasses.removeAll(componentClasses);
        for (ConcreteClassifier accessedClass : this.somoxConfiguration.getClassifierFilter().filter(filteredAccessedClasses)) {
            OperationInterface reqInterface;
            if (!this.interfaceStrategy.isComponentInterface(accessedClass) || this.doesComponentAlreadyRequireInterface((Interface)(reqInterface = this.createInterface(null, accessedClass)), componentCandidate.getComponent())) continue;
            this.createRequiredPort(componentCandidate.getComponent(), reqInterface);
            this.updateInterfacesInSourceCodeDecorator(componentCandidate, (Interface)reqInterface, accessedClass, false);
            addedARequiredInterface = true;
        }
        if (!componentCandidate.isIsCompositeComponent()) {
            this.removeInterfaceSelfAccesses(componentCandidate);
        }
        return addedARequiredInterface;
    }

    public void addProvidedInterfaces(ComponentImplementingClassesLink componentCandidate) {
        if (componentCandidate.isIsCompositeComponent()) {
            throw new IllegalArgumentException("This method can only be called on primitive components");
        }
        for (ConcreteClassifier gastClass : componentCandidate.getImplementingClasses()) {
            List superTypes = KDMHelper.getSuperTypes((ConcreteClassifier)gastClass);
            for (ConcreteClassifier superType : this.somoxConfiguration.getClassifierFilter().filter((Iterable)superTypes)) {
                this.createInterfaceForSupertype(componentCandidate, gastClass, superType);
            }
        }
        if (componentCandidate.getComponent().getProvidedRoles_InterfaceProvidingEntity().isEmpty()) {
            this.assignPublicMethodsAsInterfaceForComponentsWithoutInterface(componentCandidate);
        }
    }

    private void createRequiredPort(RepositoryComponent component, OperationInterface reqInterface) {
        OperationRequiredRole requiredRole = RepositoryFactory.eINSTANCE.createOperationRequiredRole();
        requiredRole.setEntityName(this.naming.createRequiredPortName((Interface)reqInterface, component));
        requiredRole.setRequiredInterface__OperationRequiredRole(reqInterface);
        component.getRequiredRoles_InterfaceRequiringEntity().add((Object)requiredRole);
    }

    private ProvidedRole createProvidedPort(OperationInterface theInterface, RepositoryComponent component) {
        OperationProvidedRole providedRole = RepositoryFactory.eINSTANCE.createOperationProvidedRole();
        providedRole.setEntityName(this.naming.createProvidedPortName((Interface)theInterface, component));
        providedRole.setProvidedInterface__OperationProvidedRole(theInterface);
        component.getProvidedRoles_InterfaceProvidingEntity().add((Object)providedRole);
        return providedRole;
    }

    private boolean doesComponentAlreadyRequireInterface(Interface theInterface, RepositoryComponent component) {
        for (RequiredRole role : component.getRequiredRoles_InterfaceRequiringEntity()) {
            if (role instanceof OperationRequiredRole var5_5) {
                OperationInterface opInterface = opReqRole.getRequiredInterface__OperationRequiredRole();
                if (!opInterface.equals(theInterface)) continue;
                return true;
            }
            logger.warn((Object)("Role type not yet supported: " + role.getClass().getSimpleName()));
        }
        return false;
    }

    private boolean componentProvidesInterface(Interface theInterface, RepositoryComponent component) {
        for (ProvidedRole provRole : component.getProvidedRoles_InterfaceProvidingEntity()) {
            if (!provRole.getId().equals(theInterface.getId())) continue;
            return true;
        }
        return false;
    }

    private void createInterfaceForSupertype(ComponentImplementingClassesLink componentCandidate, ConcreteClassifier gastClass, ConcreteClassifier superType) {
        for (ConcreteClassifier ownSuperType : this.somoxConfiguration.getClassifierFilter().filter((Iterable)KDMHelper.getSuperTypes((ConcreteClassifier)superType))) {
            this.createInterfaceForSupertype(componentCandidate, gastClass, ownSuperType);
        }
        if (this.interfaceStrategy.isComponentInterface(superType)) {
            logger.debug((Object)("Found interface " + KDMHelper.computeFullQualifiedName((Commentable)superType) + " for component " + componentCandidate.getComponent().getEntityName()));
            OperationInterface providedInterface = this.createInterface(gastClass, superType);
            if (!this.componentProvidesInterface((Interface)providedInterface, componentCandidate.getComponent())) {
                this.createProvidedPortAndBehaviour(componentCandidate, providedInterface, superType);
            }
        }
    }

    private void createProvidedPortAndBehaviour(ComponentImplementingClassesLink componentCandidate, OperationInterface providedInterface, ConcreteClassifier gastClass) {
        ProvidedRole providedRole = this.createProvidedPort(providedInterface, componentCandidate.getComponent());
        this.updateInterfacesInSourceCodeDecorator(componentCandidate, (Interface)providedInterface, gastClass, true);
        if (!componentCandidate.isIsCompositeComponent()) {
            this.behaviourBuilder.addSeffsToBasicComponent((BasicComponent)componentCandidate.getComponent(), providedRole);
        }
    }

    private void assignPublicMethodsAsInterfaceForComponentsWithoutInterface(ComponentImplementingClassesLink componentCandidate) {
        logger.debug((Object)"Assigning public methods as interfaces");
        EList gastClasses = componentCandidate.getImplementingClasses();
        if (!gastClasses.isEmpty()) {
            for (ConcreteClassifier gastClass : gastClasses) {
                OperationInterface compInterface = this.createInterfaceBasedOnPublicMethods(gastClass);
                if (compInterface != null) {
                    this.createProvidedPortAndBehaviour(componentCandidate, compInterface, gastClass);
                    continue;
                }
                logger.warn((Object)"Failed to create interface by using public methods for class without real interfaces");
            }
        } else {
            logger.warn((Object)("No gast classes found for component: " + componentCandidate.getComponent().getEntityName() + " id: " + componentCandidate.getComponent().getId()));
        }
    }

    private OperationInterface createInterfaceBasedOnPublicMethods(ConcreteClassifier gastClass) {
        if (this.interfaceStrategy.isComponentInterface(gastClass)) {
            logger.info((Object)(String.valueOf(KDMHelper.computeFullQualifiedName((Commentable)gastClass)) + " used as interface but is a pseudo-interface."));
        }
        if (this.alreadyCreatedInterfaces.containsKey(gastClass)) {
            return this.alreadyCreatedInterfaces.get(gastClass);
        }
        OperationInterface compInterface = RepositoryFactory.eINSTANCE.createOperationInterface();
        compInterface.setEntityName(this.naming.createInterfaceNameForClass((Type)gastClass));
        this.operationBuilder.createOperations(gastClass, gastClass, compInterface);
        this.alreadyCreatedInterfaces.put((Type)gastClass, compInterface);
        this.analysisResult.getInternalArchitectureModel().getInterfaces__Repository().add((Object)compInterface);
        return compInterface;
    }

    private OperationInterface createInterface(ConcreteClassifier implementingClass, ConcreteClassifier interfaceClass) {
        OperationInterface operationInterface = this.getExistingInterface((Type)interfaceClass);
        if (operationInterface == null) {
            operationInterface = RepositoryFactory.eINSTANCE.createOperationInterface();
            for (ClassifierReference inheritanceTypeAccess : KDMHelper.getInheritanceTypeAccesses((ConcreteClassifier)interfaceClass)) {
                Classifier superType = inheritanceTypeAccess.getTarget();
                if (!(superType instanceof ConcreteClassifier) || !this.somoxConfiguration.getClassifierFilter().passes((Object)((ConcreteClassifier)superType)) || !this.interfaceStrategy.isComponentInterface((ConcreteClassifier)superType)) continue;
                OperationInterface parentInterface = this.createInterface(implementingClass, (ConcreteClassifier)superType);
                operationInterface.getParentInterfaces__Interface().add((Object)parentInterface);
            }
            operationInterface.setEntityName(this.naming.createInterfaceName((Type)interfaceClass));
            this.operationBuilder.createOperations(implementingClass, interfaceClass, operationInterface);
            this.alreadyCreatedInterfaces.put((Type)interfaceClass, operationInterface);
            this.analysisResult.getInternalArchitectureModel().getInterfaces__Repository().add((Object)operationInterface);
        }
        return operationInterface;
    }

    private OperationInterface getExistingInterface(Type gastClass) {
        OperationInterface returnInterface = null;
        if (this.alreadyCreatedInterfaces.containsKey(gastClass)) {
            returnInterface = this.alreadyCreatedInterfaces.get(gastClass);
        }
        return returnInterface;
    }

    private void updateInterfacesInSourceCodeDecorator(ComponentImplementingClassesLink component, Interface interf, ConcreteClassifier gastClass, boolean isProvidedInterface) {
        InterfaceSourceCodeLink interfaceLink = SourcecodedecoratorFactory.eINSTANCE.createInterfaceSourceCodeLink();
        if (gastClass != null) {
            interfaceLink.setGastClass(gastClass);
        }
        interfaceLink.setInterface(interf);
        this.analysisResult.getSourceCodeDecoratorRepository().getInterfaceSourceCodeLink().add((Object)interfaceLink);
        if (isProvidedInterface) {
            component.getProvidedInterfaces().add((Object)interfaceLink);
        } else {
            component.getRequiredInterfaces().add((Object)interfaceLink);
        }
    }

    public void updateRequiredInterfacesOfExistingPrimitiveComponents() {
        boolean addedANewInterface = false;
        for (ComponentImplementingClassesLink compLink : this.analysisResult.getSourceCodeDecoratorRepository().getComponentImplementingClassesLink()) {
            if (compLink.isIsCompositeComponent()) continue;
            addedANewInterface = this.findAndAddRequiredInterfaces(compLink);
            addedANewInterface = true;
        }
        AssemblyConnectorsInsideCompositeComponentStrategy assemblyConnectorStrategy = new AssemblyConnectorsInsideCompositeComponentStrategy();
        if (addedANewInterface) {
            for (ComponentImplementingClassesLink compLink : this.analysisResult.getSourceCodeDecoratorRepository().getComponentImplementingClassesLink()) {
                if (!compLink.isIsCompositeComponent()) continue;
                ComposedProvidingRequiringEntity composite = (ComposedProvidingRequiringEntity)compLink.getComponent();
                assemblyConnectorStrategy.buildAssemblyConnectors(composite, (List<ComponentImplementingClassesLink>)compLink.getSubComponents());
            }
        }
    }

    public void reverseEngineerRemainingInterfacesAsFreeFloatingInterfaces(AnalysisResult analysisResult, Root gastModel) {
        analysisResult.getSourceCodeDecoratorRepository();
        for (ConcreteClassifier currentClass : gastModel.getNormalClasses()) {
            if (!this.interfaceStrategy.isComponentInterface(currentClass) || this.alreadyCreatedInterfaces.containsKey(currentClass)) continue;
            OperationInterface newInterface = this.createInterface(currentClass, currentClass);
            analysisResult.getInternalArchitectureModel().getInterfaces__Repository().add((Object)newInterface);
            InterfaceSourceCodeLink ifLink = SourcecodedecoratorFactory.eINSTANCE.createInterfaceSourceCodeLink();
            ifLink.setGastClass(currentClass);
            analysisResult.getSourceCodeDecoratorRepository().getInterfaceSourceCodeLink().add((Object)ifLink);
        }
    }

    public void removeInterfaceSelfAccesses(ComponentImplementingClassesLink primitiveComponent) {
        List<InterfaceSourceCodeInterfacePortTuple> requiredIfToRemove = this.identifyComponentInterfaceSelfAccess(primitiveComponent);
        for (InterfaceSourceCodeInterfacePortTuple currentIfTupleToRemove : requiredIfToRemove) {
            logger.trace((Object)("removing self-access component interface " + currentIfTupleToRemove.interfaceSourceCodeLink.getInterface().getEntityName() + " of component " + primitiveComponent.getComponent().getEntityName()));
            primitiveComponent.getComponent().getRequiredRoles_InterfaceRequiringEntity().remove((Object)currentIfTupleToRemove.role);
            EcoreUtil.delete((EObject)currentIfTupleToRemove.role);
            primitiveComponent.getRequiredInterfaces().remove((Object)currentIfTupleToRemove.interfaceSourceCodeLink);
            EcoreUtil.delete((EObject)currentIfTupleToRemove.interfaceSourceCodeLink);
        }
    }

    private List<InterfaceSourceCodeInterfacePortTuple> identifyComponentInterfaceSelfAccess(ComponentImplementingClassesLink primitiveComponent) {
        ArrayList<InterfaceSourceCodeInterfacePortTuple> requiredIfToRemove = new ArrayList<InterfaceSourceCodeInterfacePortTuple>();
        for (InterfaceSourceCodeLink providedInterfaceLink : primitiveComponent.getProvidedInterfaces()) {
            for (InterfaceSourceCodeLink requiredInterfaceLink : primitiveComponent.getRequiredInterfaces()) {
                if (!providedInterfaceLink.getInterface().equals(requiredInterfaceLink.getInterface())) continue;
                InterfaceSourceCodeInterfacePortTuple ifToRemoveTuple = new InterfaceSourceCodeInterfacePortTuple();
                ifToRemoveTuple.role = InterfacePortBuilderHelper.getInterfacePort(primitiveComponent, requiredInterfaceLink, false);
                ifToRemoveTuple.interfaceSourceCodeLink = requiredInterfaceLink;
                requiredIfToRemove.add(ifToRemoveTuple);
            }
        }
        return requiredIfToRemove;
    }

    private static class InterfaceSourceCodeInterfacePortTuple {
        public InterfaceSourceCodeLink interfaceSourceCodeLink;
        public Role role;

        private InterfaceSourceCodeInterfacePortTuple() {
        }
    }
}

