/*
 * Decompiled with CFR 0.152.
 */
package org.somox.configuration;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.somox.configuration.AbstractMoxConfiguration;
import org.somox.configuration.ClusteringConfiguration;
import org.somox.filter.BaseFilter;
import org.somox.filter.BlacklistFilter;
import org.somox.filter.ComposedFilter;
import org.somox.filter.tests.TestFileFilter;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;

public class SoMoXConfiguration
extends AbstractMoxConfiguration {
    public static final String BLACKLIST_CONFIGURATION_WILDCARDS_ADDITIONAL = "org.somox.metrics.wildcards.additional";
    public static final String SOMOX_ANALYZER_WILDCARD_KEY = "org.somox.metrics.wildcards";
    public static final String SOMOX_EXCLUDED_PREFIXES = "org.somox.metrics.nameResemblance.excludedPrefixes";
    public static final String SOMOX_EXCLUDED_SUFFIXES = "org.somox.metrics.nameResemblance.excludedSuffixes";
    public static final String SOMOX_WEIGHT_CLUSTERING_THRESHOLD_DECREMENT_COMPOSE = "org.somox.clusteringThresholdDecrement.Compose";
    public static final String SOMOX_WEIGHT_CLUSTERING_THRESHOLD_DECREMENT_MERGE = "org.somox.clusteringThresholdDecrement.Merge";
    public static final String SOMOX_WEIGHT_CLUSTERING_THRESHOLD_MAX_COMPOSE = "org.somox.clusteringThresholdMax.Compose";
    public static final String SOMOX_WEIGHT_CLUSTERING_THRESHOLD_MAX_MERGE = "org.somox.clusteringThresholdMax.Merge";
    public static final String SOMOX_WEIGHT_CLUSTERING_THRESHOLD_MIN_COMPOSE = "org.somox.clusteringThresholdMin.Compose";
    public static final String SOMOX_WEIGHT_CLUSTERING_THRESHOLD_MIN_MERGE = "org.somox.clusteringThresholdMin.Merge";
    public static final String SOMOX_WEIGHT_DIRECTORY_MAPPING = "org.somox.directoryMapping.weightDirectoryMapping";
    public static final String SOMOX_WEIGHT_DMS = "org.somox.dms.weightDMS";
    public static final String SOMOX_WEIGHT_HIGH_COUPLING = "org.somox.nameResemblance.weightHighCoupling";
    public static final String SOMOX_WEIGHT_HIGH_NAME_RESEMBLANCE = "org.somox.nameResemblance.weightHighNameResemblance";
    public static final String SOMOX_WEIGHT_HIGH_SLAQ = "org.somox.subsystemComponent.weightHighSLAQ";
    public static final String SOMOX_WEIGHT_HIGHEST_NAME_RESEMBLANCE = "org.somox.nameResemblance.weightHighestNameResemblance";
    public static final String SOMOX_WEIGHT_INTERFACE_VIOLATION_IRRELEVANT = "org.somox.interfaceViolation.weightInterfaceViolationIrrelevant";
    public static final String SOMOX_WEIGHT_INTERFACE_VIOLATION_RELEVANT = "org.somox.interfaceViolation.weightInterfaceViolationRelevant";
    public static final String SOMOX_WEIGHT_LOW_COUPLING = "org.somox.nameResemblance.weightLowCoupling";
    public static final String SOMOX_WEIGHT_LOW_NAME_RESEMBLANCE = "org.somox.nameResemblance.weightLowNameResemblance";
    public static final String SOMOX_WEIGHT_LOW_SLAQ = "org.somox.subsystemComponent.weightLowSLAQ";
    public static final String SOMOX_WEIGHT_MID_NAME_RESEMBLANCE = "org.somox.nameResemblance.weightMidNameResemblance";
    public static final String SOMOX_WEIGHT_PACKAGE_MAPPING = "org.somox.packageMapping.weightPackageMapping";
    public static final String SOMOX_WILDCARD_DELIMITER = "\u00a7";
    private String additionalWildcards = "";
    private final BlacklistFilter blacklistFilter = new BlacklistFilter();
    private final ComposedFilter<ConcreteClassifier> classifierFilter = new ComposedFilter(new BaseFilter[]{new TestFileFilter(), this.blacklistFilter});
    private final ClusteringConfiguration clusteringConfig = new ClusteringConfiguration();
    private String excludedPrefixesForNameResemblance = "";
    private String excludedSuffixesForNameResemblance = "";
    private double weightDirectoryMapping = 70.0;
    private double weightDMS = 5.0;
    private double weightHighCoupling = 15.0;
    private double weightHighestNameResemblance = 45.0;
    private double weightHighNameResemblance = 30.0;
    private double weightHighSLAQ = 22.0;
    private double weightInterfaceViolationIrrelevant = 10.0;
    private double weightInterfaceViolationRelevant = 40.0;
    private double weightLowCoupling = 0.0;
    private double weightLowNameResemblance = 5.0;
    private double weightLowSLAQ = 0.0;
    private double weightMidNameResemblance = 15.0;
    private double weightPackageMapping = 70.0;
    private String wildcardKey = "";

    public SoMoXConfiguration() {
        this.getFileLocations().setOutputFolder("/model");
        this.updateBlacklistFilter();
    }

    public SoMoXConfiguration(Map<String, Object> attributeMap) {
        this();
        this.applyAttributeMap(attributeMap);
    }

    @Override
    public void applyAttributeMap(Map<String, Object> attributeMap) {
        if (attributeMap == null) {
            return;
        }
        super.applyAttributeMap(attributeMap);
        if (attributeMap.get(SOMOX_ANALYZER_WILDCARD_KEY) != null) {
            this.setWildcardKey((String)attributeMap.get(SOMOX_ANALYZER_WILDCARD_KEY));
        }
        if (attributeMap.get(BLACKLIST_CONFIGURATION_WILDCARDS_ADDITIONAL) != null) {
            this.setAdditionalWildcards((String)attributeMap.get(BLACKLIST_CONFIGURATION_WILDCARDS_ADDITIONAL));
        }
        if (attributeMap.get(SOMOX_EXCLUDED_PREFIXES) != null) {
            this.setExcludedPrefixesForNameResemblance((String)attributeMap.get(SOMOX_EXCLUDED_PREFIXES));
        }
        if (attributeMap.get(SOMOX_EXCLUDED_SUFFIXES) != null) {
            this.setExcludedSuffixesForNameResemblance((String)attributeMap.get(SOMOX_EXCLUDED_SUFFIXES));
        }
        if (attributeMap.get(SOMOX_WEIGHT_DIRECTORY_MAPPING) != null) {
            this.setWeightDirectoryMapping((Double)attributeMap.get(SOMOX_WEIGHT_DIRECTORY_MAPPING));
        }
        if (attributeMap.get(SOMOX_WEIGHT_DMS) != null) {
            this.setWeightDMS((Double)attributeMap.get(SOMOX_WEIGHT_DMS));
        }
        if (attributeMap.get(SOMOX_WEIGHT_HIGH_COUPLING) != null) {
            this.setWeightHighCoupling((Double)attributeMap.get(SOMOX_WEIGHT_HIGH_COUPLING));
        }
        if (attributeMap.get(SOMOX_WEIGHT_HIGHEST_NAME_RESEMBLANCE) != null) {
            this.setWeightHighestNameResemblance((Double)attributeMap.get(SOMOX_WEIGHT_HIGHEST_NAME_RESEMBLANCE));
        }
        if (attributeMap.get(SOMOX_WEIGHT_HIGH_NAME_RESEMBLANCE) != null) {
            this.setWeightHighNameResemblance((Double)attributeMap.get(SOMOX_WEIGHT_HIGH_NAME_RESEMBLANCE));
        }
        if (attributeMap.get(SOMOX_WEIGHT_HIGH_SLAQ) != null) {
            this.setWeightHighSLAQ((Double)attributeMap.get(SOMOX_WEIGHT_HIGH_SLAQ));
        }
        if (attributeMap.get(SOMOX_WEIGHT_INTERFACE_VIOLATION_IRRELEVANT) != null) {
            this.setWeightInterfaceViolationIrrelevant((Double)attributeMap.get(SOMOX_WEIGHT_INTERFACE_VIOLATION_IRRELEVANT));
        }
        if (attributeMap.get(SOMOX_WEIGHT_INTERFACE_VIOLATION_RELEVANT) != null) {
            this.setWeightInterfaceViolationRelevant((Double)attributeMap.get(SOMOX_WEIGHT_INTERFACE_VIOLATION_RELEVANT));
        }
        if (attributeMap.get(SOMOX_WEIGHT_LOW_COUPLING) != null) {
            this.setWeightLowCoupling((Double)attributeMap.get(SOMOX_WEIGHT_LOW_COUPLING));
        }
        if (attributeMap.get(SOMOX_WEIGHT_LOW_NAME_RESEMBLANCE) != null) {
            this.setWeightLowNameResemblance((Double)attributeMap.get(SOMOX_WEIGHT_LOW_NAME_RESEMBLANCE));
        }
        if (attributeMap.get(SOMOX_WEIGHT_LOW_SLAQ) != null) {
            this.setWeightLowSLAQ((Double)attributeMap.get(SOMOX_WEIGHT_LOW_SLAQ));
        }
        if (attributeMap.get(SOMOX_WEIGHT_MID_NAME_RESEMBLANCE) != null) {
            this.setWeightMidNameResemblance((Double)attributeMap.get(SOMOX_WEIGHT_MID_NAME_RESEMBLANCE));
        }
        if (attributeMap.get(SOMOX_WEIGHT_PACKAGE_MAPPING) != null) {
            this.setWeightPackageMapping((Double)attributeMap.get(SOMOX_WEIGHT_PACKAGE_MAPPING));
        }
        ClusteringConfiguration clusteringConfiguration = this.getClusteringConfig();
        if (attributeMap.get(SOMOX_WEIGHT_CLUSTERING_THRESHOLD_MAX_COMPOSE) != null) {
            clusteringConfiguration.setMaxComposeClusteringThreshold((Double)attributeMap.get(SOMOX_WEIGHT_CLUSTERING_THRESHOLD_MAX_COMPOSE));
        }
        if (attributeMap.get(SOMOX_WEIGHT_CLUSTERING_THRESHOLD_MIN_COMPOSE) != null) {
            clusteringConfiguration.setMinComposeClusteringThreshold((Double)attributeMap.get(SOMOX_WEIGHT_CLUSTERING_THRESHOLD_MIN_COMPOSE));
        }
        if (attributeMap.get(SOMOX_WEIGHT_CLUSTERING_THRESHOLD_DECREMENT_COMPOSE) != null) {
            clusteringConfiguration.setClusteringComposeThresholdDecrement((Double)attributeMap.get(SOMOX_WEIGHT_CLUSTERING_THRESHOLD_DECREMENT_COMPOSE));
        }
        if (attributeMap.get(SOMOX_WEIGHT_CLUSTERING_THRESHOLD_MAX_MERGE) != null) {
            clusteringConfiguration.setMaxMergeClusteringThreshold((Double)attributeMap.get(SOMOX_WEIGHT_CLUSTERING_THRESHOLD_MAX_MERGE));
        }
        if (attributeMap.get(SOMOX_WEIGHT_CLUSTERING_THRESHOLD_MIN_MERGE) != null) {
            clusteringConfiguration.setMinMergeClusteringThreshold((Double)attributeMap.get(SOMOX_WEIGHT_CLUSTERING_THRESHOLD_MIN_MERGE));
        }
        if (attributeMap.get(SOMOX_WEIGHT_CLUSTERING_THRESHOLD_DECREMENT_MERGE) != null) {
            clusteringConfiguration.setClusteringMergeThresholdDecrement((Double)attributeMap.get(SOMOX_WEIGHT_CLUSTERING_THRESHOLD_DECREMENT_MERGE));
        }
    }

    public String getAdditionalWildcards() {
        return this.additionalWildcards;
    }

    public Set<String> getBlacklist() {
        String wildcardString = this.wildcardKey;
        StringTokenizer tokenizer = new StringTokenizer(wildcardString, SOMOX_WILDCARD_DELIMITER);
        HashSet<String> blacklist = new HashSet<String>();
        while (tokenizer.hasMoreElements()) {
            blacklist.add(tokenizer.nextToken());
        }
        return blacklist;
    }

    public BaseFilter<ConcreteClassifier> getClassifierFilter() {
        return this.classifierFilter;
    }

    public ClusteringConfiguration getClusteringConfig() {
        return this.clusteringConfig;
    }

    public String getErrorMessage() {
        return "An error in SoMoX occured";
    }

    public String getExcludedPrefixesForNameResemblance() {
        return this.excludedPrefixesForNameResemblance;
    }

    public String getExcludedSuffixesForNameResemblance() {
        return this.excludedSuffixesForNameResemblance;
    }

    public double getWeightDirectoryMapping() {
        return this.weightDirectoryMapping;
    }

    public double getWeightDMS() {
        return this.weightDMS;
    }

    public double getWeightHighCoupling() {
        return this.weightHighCoupling;
    }

    public double getWeightHighestNameResemblance() {
        return this.weightHighestNameResemblance;
    }

    public double getWeightHighNameResemblance() {
        return this.weightHighNameResemblance;
    }

    public double getWeightHighSLAQ() {
        return this.weightHighSLAQ;
    }

    public double getWeightInterfaceViolationIrrelevant() {
        return this.weightInterfaceViolationIrrelevant;
    }

    public double getWeightInterfaceViolationRelevant() {
        return this.weightInterfaceViolationRelevant;
    }

    public double getWeightLowCoupling() {
        return this.weightLowCoupling;
    }

    public double getWeightLowNameResemblance() {
        return this.weightLowNameResemblance;
    }

    public double getWeightLowSLAQ() {
        return this.weightLowSLAQ;
    }

    public double getWeightMidNameResemblance() {
        return this.weightMidNameResemblance;
    }

    public double getWeightPackageMapping() {
        return this.weightPackageMapping;
    }

    public String getWildcardKey() {
        return this.wildcardKey;
    }

    public void setAdditionalWildcards(String additionalWildcards) {
        this.additionalWildcards = additionalWildcards;
        this.updateBlacklistFilter();
    }

    public void setExcludedPrefixesForNameResemblance(String excludedPrefixesForNameResemblance) {
        this.excludedPrefixesForNameResemblance = excludedPrefixesForNameResemblance;
    }

    public void setExcludedSuffixesForNameResemblance(String excludedSuffixesForNameResemblance) {
        this.excludedSuffixesForNameResemblance = excludedSuffixesForNameResemblance;
    }

    public void setWeightDirectoryMapping(double weightDirectoryMapping) {
        this.weightDirectoryMapping = weightDirectoryMapping;
    }

    public void setWeightDMS(double weightDMS) {
        this.weightDMS = weightDMS;
    }

    public void setWeightHighCoupling(double weightHighCoupling) {
        this.weightHighCoupling = weightHighCoupling;
    }

    public void setWeightHighestNameResemblance(double weightHighestNameResemblance) {
        this.weightHighestNameResemblance = weightHighestNameResemblance;
    }

    public void setWeightHighNameResemblance(double weightHighNameResemblance) {
        this.weightHighNameResemblance = weightHighNameResemblance;
    }

    public void setWeightHighSLAQ(double weightHighSLAQ) {
        this.weightHighSLAQ = weightHighSLAQ;
    }

    public void setWeightInterfaceViolationIrrelevant(double weightInterfaceViolationIrrelevant) {
        this.weightInterfaceViolationIrrelevant = weightInterfaceViolationIrrelevant;
    }

    public void setWeightInterfaceViolationRelevant(double weightInterfaceViolationRelevant) {
        this.weightInterfaceViolationRelevant = weightInterfaceViolationRelevant;
    }

    public void setWeightLowCoupling(double weightLowCoupling) {
        this.weightLowCoupling = weightLowCoupling;
    }

    public void setWeightLowNameResemblance(double weightLowNameResemblance) {
        this.weightLowNameResemblance = weightLowNameResemblance;
    }

    public void setWeightLowSLAQ(double weightLowSLAQ) {
        this.weightLowSLAQ = weightLowSLAQ;
    }

    public void setWeightMidNameResemblance(double weightMidNameResemblance) {
        this.weightMidNameResemblance = weightMidNameResemblance;
    }

    public void setWeightPackageMapping(double weightPackageMapping) {
        this.weightPackageMapping = weightPackageMapping;
    }

    public void setWildcardKey(String wildcardKey) {
        this.wildcardKey = wildcardKey;
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> result = super.toMap();
        result.put(SOMOX_ANALYZER_WILDCARD_KEY, this.getWildcardKey());
        result.put(BLACKLIST_CONFIGURATION_WILDCARDS_ADDITIONAL, this.getAdditionalWildcards());
        result.put(SOMOX_EXCLUDED_PREFIXES, this.getExcludedPrefixesForNameResemblance());
        result.put(SOMOX_EXCLUDED_SUFFIXES, this.getExcludedSuffixesForNameResemblance());
        result.put(SOMOX_WEIGHT_DIRECTORY_MAPPING, this.getWeightDirectoryMapping());
        result.put(SOMOX_WEIGHT_DMS, this.getWeightDMS());
        result.put(SOMOX_WEIGHT_HIGH_COUPLING, this.getWeightHighCoupling());
        result.put(SOMOX_WEIGHT_HIGHEST_NAME_RESEMBLANCE, this.getWeightHighestNameResemblance());
        result.put(SOMOX_WEIGHT_HIGH_NAME_RESEMBLANCE, this.getWeightHighNameResemblance());
        result.put(SOMOX_WEIGHT_HIGH_SLAQ, this.getWeightHighSLAQ());
        result.put(SOMOX_WEIGHT_INTERFACE_VIOLATION_IRRELEVANT, this.getWeightInterfaceViolationIrrelevant());
        result.put(SOMOX_WEIGHT_INTERFACE_VIOLATION_RELEVANT, this.getWeightInterfaceViolationRelevant());
        result.put(SOMOX_WEIGHT_LOW_COUPLING, this.getWeightLowCoupling());
        result.put(SOMOX_WEIGHT_LOW_NAME_RESEMBLANCE, this.getWeightLowNameResemblance());
        result.put(SOMOX_WEIGHT_LOW_SLAQ, this.getWeightLowSLAQ());
        result.put(SOMOX_WEIGHT_MID_NAME_RESEMBLANCE, this.getWeightMidNameResemblance());
        result.put(SOMOX_WEIGHT_PACKAGE_MAPPING, this.getWeightPackageMapping());
        ClusteringConfiguration clusteringConfiguration = this.getClusteringConfig();
        result.put(SOMOX_WEIGHT_CLUSTERING_THRESHOLD_MAX_COMPOSE, clusteringConfiguration.getMaxComposeClusteringThreshold());
        result.put(SOMOX_WEIGHT_CLUSTERING_THRESHOLD_MIN_COMPOSE, clusteringConfiguration.getMinComposeClusteringThreshold());
        result.put(SOMOX_WEIGHT_CLUSTERING_THRESHOLD_DECREMENT_COMPOSE, clusteringConfiguration.getClusteringComposeThresholdDecrement());
        result.put(SOMOX_WEIGHT_CLUSTERING_THRESHOLD_MAX_MERGE, clusteringConfiguration.getMaxMergeClusteringThreshold());
        result.put(SOMOX_WEIGHT_CLUSTERING_THRESHOLD_MIN_MERGE, clusteringConfiguration.getMinMergeClusteringThreshold());
        result.put(SOMOX_WEIGHT_CLUSTERING_THRESHOLD_DECREMENT_MERGE, clusteringConfiguration.getClusteringMergeThresholdDecrement());
        return result;
    }

    private void updateBlacklistFilter() {
        Set<String> wildCardList = this.getBlacklist();
        if (this.additionalWildcards != null && this.additionalWildcards.length() > 0) {
            wildCardList.add(this.additionalWildcards);
        }
        this.blacklistFilter.setBlacklist(wildCardList);
    }
}

