/*
 * Decompiled with CFR 0.152.
 */
package org.somox.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;
import org.somox.analyzer.ModelAnalyzer;
import org.somox.controller.SoMoXCoreController;
import org.somox.core.SoMoXCore;
import org.somox.core.impl.SoMoXCoreStandard;
import org.somox.extractor.SoftwareExtractor;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.somox.core";
    public static final String EXTENSION_POINT_ID_SOFTWAREEXTRACTOR = "softwareextractor";
    public static final String EXTENSION_POINT_ID_MODELANALYZER = "modelanalyzer";
    public static final String EXTENSION_POINT_ID_CONTROLLER = "controller";
    private static Activator plugin;
    private SoMoXCore somoxCore = null;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.somoxCore = new SoMoXCoreStandard();
        this.connectCoreControllerExtensions();
        this.loadSoftwareExtractors();
        this.loadModelAnalyzers();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static void wakeUp() {
    }

    private int loadSoftwareExtractors() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(PLUGIN_ID, EXTENSION_POINT_ID_SOFTWAREEXTRACTOR);
        if (point == null) {
            return 0;
        }
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            SoftwareExtractor extractor = this.buildSoftwareExtractor(extensions[i].getConfigurationElements());
            if (extractor != null) {
                this.somoxCore.addSoftwareExtractor(extractor.getClass().getName(), extractor);
            }
            ++i;
        }
        return i;
    }

    private int loadModelAnalyzers() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(PLUGIN_ID, EXTENSION_POINT_ID_MODELANALYZER);
        if (point == null) {
            return 0;
        }
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            ModelAnalyzer analyzer = this.buildModelAnalyzer(extensions[i].getConfigurationElements());
            if (analyzer != null) {
                this.somoxCore.addModelAnalyzer(analyzer.getClass().getName(), analyzer);
            }
            ++i;
        }
        return i;
    }

    private int connectCoreControllerExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(PLUGIN_ID, EXTENSION_POINT_ID_CONTROLLER);
        if (point == null) {
            return 0;
        }
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            SoMoXCoreController controller = this.buildController(extensions[i].getConfigurationElements());
            if (controller != null) {
                controller.setSoMoXCore(this.somoxCore);
            }
            ++i;
        }
        return i;
    }

    private SoMoXCoreController buildController(IConfigurationElement[] configurations) {
        SoMoXCoreController controller = null;
        IConfigurationElement[] iConfigurationElementArray = configurations;
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configuration = iConfigurationElementArray[n2];
            if (EXTENSION_POINT_ID_CONTROLLER.equals(configuration.getName())) {
                try {
                    controller = (SoMoXCoreController)configuration.createExecutableExtension("class");
                    controller.setSoMoXCore(this.somoxCore);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            this.getLog().log((IStatus)new Status(1, PLUGIN_ID, "contoller loaded"));
            ++n2;
        }
        return controller;
    }

    private SoftwareExtractor buildSoftwareExtractor(IConfigurationElement[] configurations) {
        SoftwareExtractor extractor = null;
        IConfigurationElement[] iConfigurationElementArray = configurations;
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configuration = iConfigurationElementArray[n2];
            if (EXTENSION_POINT_ID_SOFTWAREEXTRACTOR.equals(configuration.getName())) {
                try {
                    extractor = (SoftwareExtractor)configuration.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            this.getLog().log((IStatus)new Status(1, PLUGIN_ID, "extractor loaded"));
            ++n2;
        }
        return extractor;
    }

    private ModelAnalyzer buildModelAnalyzer(IConfigurationElement[] configurations) {
        ModelAnalyzer analyzer = null;
        IConfigurationElement[] iConfigurationElementArray = configurations;
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configuration = iConfigurationElementArray[n2];
            if (EXTENSION_POINT_ID_MODELANALYZER.equals(configuration.getName())) {
                try {
                    analyzer = (ModelAnalyzer)configuration.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            } else {
                this.getLog().log((IStatus)new Status(1, PLUGIN_ID, "Tried to build a model analyzer from a non model analyzer plug-in: " + configuration.getName()));
            }
            ++n2;
        }
        return analyzer;
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static Plugin getPlugin() {
        return plugin;
    }
}

