/*
 * Decompiled with CFR 0.152.
 */
package org.somox.filter;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class BaseFilter<T> {
    public abstract boolean passes(T var1);

    public Iterator<T> filter(Iterator<T> iterator) {
        return new FilterIterator(iterator);
    }

    public Iterable<T> filter(Iterable<T> iterable) {
        return () -> this.filter(iterable.iterator());
    }

    private class FilterIterator
    implements Iterator<T> {
        private final Iterator<T> iterator;
        private T next;

        private FilterIterator(Iterator<T> iterator) {
            this.iterator = iterator;
            this.toNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Object returnValue = this.next;
            this.toNext();
            return returnValue;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void toNext() {
            this.next = null;
            while (this.iterator.hasNext()) {
                Object item = this.iterator.next();
                if (item == null || !BaseFilter.this.passes(item)) continue;
                this.next = item;
                break;
            }
        }
    }
}

