/*
 * Decompiled with CFR 0.152.
 */
package org.somox.gast2seff.visitors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ComposedSwitch;
import org.somox.gast2seff.visitors.IFunctionClassificationStrategy;
import org.somox.gast2seff.visitors.JaMoPPStatementVisitor;
import org.somox.gast2seff.visitors.MethodCallFinder;
import org.somox.gast2seff.visitors.SwitchStatementHelper;
import org.somox.kdmhelper.KDMHelper;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.expressions.util.ExpressionsSwitch;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.members.Method;
import tools.mdsd.jamopp.model.java.members.util.MembersSwitch;
import tools.mdsd.jamopp.model.java.statements.Assert;
import tools.mdsd.jamopp.model.java.statements.Block;
import tools.mdsd.jamopp.model.java.statements.CatchBlock;
import tools.mdsd.jamopp.model.java.statements.Condition;
import tools.mdsd.jamopp.model.java.statements.DoWhileLoop;
import tools.mdsd.jamopp.model.java.statements.ExpressionStatement;
import tools.mdsd.jamopp.model.java.statements.ForEachLoop;
import tools.mdsd.jamopp.model.java.statements.ForLoop;
import tools.mdsd.jamopp.model.java.statements.LocalVariableStatement;
import tools.mdsd.jamopp.model.java.statements.Statement;
import tools.mdsd.jamopp.model.java.statements.StatementListContainer;
import tools.mdsd.jamopp.model.java.statements.Switch;
import tools.mdsd.jamopp.model.java.statements.TryBlock;
import tools.mdsd.jamopp.model.java.statements.WhileLoop;
import tools.mdsd.jamopp.model.java.statements.util.StatementsSwitch;

public class FunctionCallClassificationVisitor
extends ComposedSwitch<Collection<BitSet>> {
    private static final Logger logger = Logger.getLogger(JaMoPPStatementVisitor.class);
    private final MethodCallFinder methodCallFinder;
    private final HashMap<Commentable, List<BitSet>> annotations = new HashMap();
    private IFunctionClassificationStrategy myStrategy = null;

    public FunctionCallClassificationVisitor(IFunctionClassificationStrategy strategy, MethodCallFinder methodCallFinder) {
        this.methodCallFinder = methodCallFinder;
        this.myStrategy = strategy;
        this.addSwitch((org.eclipse.emf.ecore.util.Switch)new MembersClassification());
        this.addSwitch((org.eclipse.emf.ecore.util.Switch)new StatementClassification());
        this.addSwitch((org.eclipse.emf.ecore.util.Switch)new ExpressionClassification());
    }

    private Collection<BitSet> handleStatementListContainer(StatementListContainer object) {
        if (this.annotations.containsKey(object)) {
            return this.annotations.get(object);
        }
        List<BitSet> myTypes = Arrays.asList(this.computeChildAnnotations(new BitSet(), (List<Statement>)object.getStatements()));
        this.putBitSetInAnnotations((Commentable)object, myTypes);
        return myTypes;
    }

    private Collection<BitSet> createBitSetLoop(Statement loop, Statement body) {
        if (this.annotations.containsKey(loop)) {
            return this.annotations.get(loop);
        }
        this.doSwitch((EObject)body);
        List<BitSet> myType = this.annotations.get(body);
        this.putBitSetInAnnotations((Commentable)loop, myType);
        return myType;
    }

    private List<BitSet> handleFormerSimpleStatement(Statement statement) {
        if (this.annotations.containsKey(statement)) {
            return this.annotations.get(statement);
        }
        List<BitSet> myTypes = this.myStrategy.classifySimpleStatement(statement);
        this.putBitSetInAnnotations((Commentable)statement, myTypes);
        List<Method> calledMethods = this.methodCallFinder.getMethodCalls(statement);
        int i = 0;
        while (i < myTypes.size()) {
            BitSet myType = myTypes.get(i);
            if (myType.get(FunctionCallClassificationVisitor.getIndex(FunctionCallType.INTERNAL))) {
                Method calledMethod = calledMethods.get(i);
                StatementListContainer targetFunctionBody = KDMHelper.getBody((Member)calledMethod);
                Collection internalTypes = new ArrayList();
                if (targetFunctionBody != null) {
                    logger.trace((Object)("visiting internal call. accessed class: " + calledMethod.getContainingConcreteClassifier()));
                    internalTypes = (Collection)this.doSwitch((EObject)targetFunctionBody);
                } else {
                    logger.warn((Object)("Behaviour not set in GAST for " + calledMethod.getName()));
                }
                for (BitSet internalType : internalTypes) {
                    if (!internalType.get(FunctionCallClassificationVisitor.getIndex(FunctionCallType.EXTERNAL)) && !internalType.get(FunctionCallClassificationVisitor.getIndex(FunctionCallType.EMITEVENT))) continue;
                    myType.set(FunctionCallClassificationVisitor.getIndex(FunctionCallType.INTERNAL_CALL_CONTAINING_EXTERNAL_CALL));
                }
            }
            ++i;
        }
        return myTypes;
    }

    private void putBitSetInAnnotations(Commentable object, List<BitSet> type) {
        this.annotations.put(object, type);
    }

    private BitSet computeChildAnnotations(BitSet initalValue, List<Statement> childStatements) {
        for (Statement s : childStatements) {
            if (s == null) continue;
            this.doSwitch((EObject)s);
        }
        BitSet myType = initalValue;
        for (Statement s : childStatements) {
            if (s == null) continue;
            this.myStrategy.mergeFunctionCallType(myType, (Collection<BitSet>)this.annotations.get(s));
        }
        return myType;
    }

    public static int getIndex(FunctionCallType type) {
        return switch (type) {
            case FunctionCallType.INTERNAL -> 0;
            case FunctionCallType.EXTERNAL -> 1;
            case FunctionCallType.LIBRARY -> 2;
            case FunctionCallType.VISITED -> 3;
            case FunctionCallType.INTERNAL_CALL_CONTAINING_EXTERNAL_CALL -> 4;
            case FunctionCallType.EMITEVENT -> 5;
            default -> throw new UnsupportedOperationException();
        };
    }

    public Map<Commentable, List<BitSet>> getAnnotations() {
        return Collections.unmodifiableMap(this.annotations);
    }

    public Collection<BitSet> defaultCase(EObject object) {
        logger.warn((Object)("Not handled object by function call visitor:\n  " + object));
        return (Collection)super.defaultCase(object);
    }

    private static class ExpressionClassification
    extends ExpressionsSwitch<Collection<BitSet>> {
        private ExpressionClassification() {
        }
    }

    public static enum FunctionCallType {
        EXTERNAL,
        LIBRARY,
        INTERNAL,
        VISITED,
        INTERNAL_CALL_CONTAINING_EXTERNAL_CALL,
        EMITEVENT;

    }

    private class MembersClassification
    extends MembersSwitch<Collection<BitSet>> {
        private MembersClassification() {
        }

        public Collection<BitSet> caseStatementListContainer(StatementListContainer object) {
            return FunctionCallClassificationVisitor.this.handleStatementListContainer(object);
        }
    }

    private class StatementClassification
    extends StatementsSwitch<Collection<BitSet>> {
        private StatementClassification() {
        }

        public Collection<BitSet> caseStatement(Statement object) {
            return FunctionCallClassificationVisitor.this.handleFormerSimpleStatement(object);
        }

        public Collection<BitSet> caseBlock(Block block) {
            return FunctionCallClassificationVisitor.this.handleStatementListContainer((StatementListContainer)block);
        }

        public Collection<BitSet> caseCondition(Condition condition) {
            if (FunctionCallClassificationVisitor.this.annotations.containsKey(condition)) {
                return FunctionCallClassificationVisitor.this.annotations.get(condition);
            }
            ArrayList<Statement> branchStatements = new ArrayList<Statement>();
            if (condition.getCondition() != null) {
                this.doSwitch((EObject)condition.getCondition());
            }
            if (condition.getStatement() != null) {
                this.doSwitch((EObject)condition.getStatement());
                branchStatements.add(condition.getStatement());
            }
            if (condition.getElseStatement() != null) {
                this.doSwitch((EObject)condition.getElseStatement());
                branchStatements.add(condition.getElseStatement());
            }
            List<BitSet> myType = Arrays.asList(FunctionCallClassificationVisitor.this.computeChildAnnotations(new BitSet(), branchStatements));
            FunctionCallClassificationVisitor.this.putBitSetInAnnotations((Commentable)condition, myType);
            return myType;
        }

        public Collection<BitSet> caseSwitch(Switch switchStatement) {
            if (FunctionCallClassificationVisitor.this.annotations.containsKey(switchStatement)) {
                return FunctionCallClassificationVisitor.this.annotations.get(switchStatement);
            }
            List<List<Statement>> branches = SwitchStatementHelper.createBlockListFromSwitchStatement(switchStatement);
            for (List<Statement> branch : branches) {
                FunctionCallClassificationVisitor.this.computeChildAnnotations(new BitSet(), branch);
            }
            ArrayList<Statement> branchStatements = new ArrayList<Statement>();
            for (List<Statement> branch : branches) {
                branchStatements.addAll(branch);
            }
            List<BitSet> myType = Arrays.asList(FunctionCallClassificationVisitor.this.computeChildAnnotations(new BitSet(), branchStatements));
            FunctionCallClassificationVisitor.this.putBitSetInAnnotations((Commentable)switchStatement, myType);
            return myType;
        }

        public Collection<BitSet> caseForLoop(ForLoop object) {
            return FunctionCallClassificationVisitor.this.createBitSetLoop((Statement)object, object.getStatement());
        }

        public Collection<BitSet> caseForEachLoop(ForEachLoop object) {
            return FunctionCallClassificationVisitor.this.createBitSetLoop((Statement)object, object.getStatement());
        }

        public Collection<BitSet> caseWhileLoop(WhileLoop object) {
            return FunctionCallClassificationVisitor.this.createBitSetLoop((Statement)object, object.getStatement());
        }

        public Collection<BitSet> caseDoWhileLoop(DoWhileLoop object) {
            return FunctionCallClassificationVisitor.this.createBitSetLoop((Statement)object, object.getStatement());
        }

        public Collection<BitSet> caseTryBlock(TryBlock object) {
            if (FunctionCallClassificationVisitor.this.annotations.containsKey(object)) {
                return FunctionCallClassificationVisitor.this.annotations.get(object);
            }
            FunctionCallClassificationVisitor.this.handleStatementListContainer((StatementListContainer)object);
            ArrayList<Statement> allChildStatements = new ArrayList<Statement>((Collection<Statement>)object.getStatements());
            for (CatchBlock catchBlock : object.getCatcheBlocks()) {
                this.doSwitch((EObject)catchBlock);
                allChildStatements.addAll((Collection<Statement>)catchBlock.getStatements());
            }
            if (object.getFinallyBlock() != null) {
                this.doSwitch((EObject)object.getFinallyBlock());
                allChildStatements.addAll((Collection<Statement>)object.getFinallyBlock().getStatements());
            }
            List<BitSet> myType = Arrays.asList(FunctionCallClassificationVisitor.this.computeChildAnnotations(new BitSet(), allChildStatements));
            FunctionCallClassificationVisitor.this.putBitSetInAnnotations((Commentable)object, myType);
            return myType;
        }

        public Collection<BitSet> caseAssert(Assert object) {
            return FunctionCallClassificationVisitor.this.handleFormerSimpleStatement((Statement)object);
        }

        public Collection<BitSet> caseExpressionStatement(ExpressionStatement object) {
            return FunctionCallClassificationVisitor.this.handleFormerSimpleStatement((Statement)object);
        }

        public Collection<BitSet> caseLocalVariableStatement(LocalVariableStatement object) {
            return FunctionCallClassificationVisitor.this.handleFormerSimpleStatement((Statement)object);
        }
    }
}

