/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics.hierarchy;

import java.util.Set;
import org.apache.log4j.Logger;
import org.somox.metrics.ClusteringRelation;
import org.somox.metrics.abstractmetrics.AbstractMetric;
import org.somox.metrics.hierarchy.DirectoryMapping;
import org.somox.metrics.hierarchy.PackageMapping;
import org.somox.metrics.hierarchy.TreeNode;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.types.Type;

public abstract class AbstractHierarchyMapping<T>
extends AbstractMetric {
    private static final double MINIMUM_PACKAGE_DIRECTORY_FITTING = 0.2;
    private final Logger logger = Logger.getLogger(PackageMapping.class);

    @Override
    public boolean isCommutative() {
        return true;
    }

    @Override
    protected void internalComputeDirected(ClusteringRelation relationToCompute) {
        int maxHeight;
        Set<ConcreteClassifier> classes1 = this.getComponentToClassHelper().deriveImplementingClasses(relationToCompute.getSourceComponent());
        Set<ConcreteClassifier> classes2 = this.getComponentToClassHelper().deriveImplementingClasses(relationToCompute.getTargetComponent());
        TreeNode<T> element1RootPackagesPath = this.collectPaths(classes1);
        TreeNode<T> element2RootPackagesPath = this.collectPaths(classes2);
        int maxCommonPackageDirectoryHeigthOfElements = this.getMaxCommonPackageDirectory(element1RootPackagesPath, element2RootPackagesPath);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("maxCommonPackageHeigth: " + maxCommonPackageDirectoryHeigthOfElements));
        }
        if ((maxHeight = Math.max(element1RootPackagesPath.getHeight(), element2RootPackagesPath.getHeight())) == 0) {
            relationToCompute.setResultMetric(this.getMID(), 0.0);
        } else {
            assert (maxCommonPackageDirectoryHeigthOfElements <= maxHeight);
            double rawMeasure = this instanceof DirectoryMapping ? (double)(maxCommonPackageDirectoryHeigthOfElements + 3) / (double)(maxHeight + 3) : (double)maxCommonPackageDirectoryHeigthOfElements / (double)maxHeight;
            relationToCompute.setResultMetric(this.getMID(), this.convertToNonLinearWeight(rawMeasure));
        }
    }

    protected abstract T getPath(Type var1);

    protected abstract T getPath(T var1);

    private double convertToNonLinearWeight(double rawMeasure) {
        if (rawMeasure < 0.2) {
            return 0.0;
        }
        return rawMeasure;
    }

    private int getMaxCommonPackageDirectory(TreeNode<T> tree1, TreeNode<T> tree2) {
        if (tree1.isRoot() && !tree2.isRoot() || !tree1.isRoot() && tree2.isRoot()) {
            throw new IllegalArgumentException("Both tree nodes have to be root or non-root");
        }
        if (tree1.isRoot() && tree2.isRoot()) {
            if (tree1.getChildren().size() == 0 || tree2.getChildren().size() == 0) {
                return 0;
            }
            return this.getMaxCommonPackageDirectory(tree1.getChildren().get(0), tree2.getChildren().get(0));
        }
        if (tree1.getChildren().size() > 1 || tree2.getChildren().size() > 1 || tree1.getElement() != tree2.getElement()) {
            return 0;
        }
        if (tree1.getChildren().size() == 0 || tree2.getChildren().size() == 0) {
            return 1;
        }
        return 1 + this.getMaxCommonPackageDirectory(tree1.getChildren().get(0), tree2.getChildren().get(0));
    }

    private TreeNode<T> collectPaths(Set<ConcreteClassifier> elements) {
        TreeNode root = new TreeNode();
        for (ConcreteClassifier currentClass : elements) {
            this.addToTree(root, this.getPath(currentClass));
        }
        return root;
    }

    private TreeNode<T> addToTree(TreeNode<T> root, T element) {
        if (element == null) {
            return root;
        }
        TreeNode<T> parent = this.addToTree(root, this.getPath(element));
        for (TreeNode<T> child : parent.getChildren()) {
            if (child.getElement() != element) continue;
            return child;
        }
        TreeNode<T> newChild = new TreeNode<T>(element);
        parent.addChild(newChild);
        return newChild;
    }

    @Override
    public boolean isNormalised() {
        return true;
    }
}

