/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.core.expressions.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ComparingOperator implements Enumerator
{
    LESS(0, "LESS", "LESS"),
    LESS_OR_EQUAL(1, "LESS_OR_EQUAL", "LESS_OR_EQUAL"),
    EQUAL(2, "EQUAL", "EQUAL"),
    GREATER_OR_EQUAL(3, "GREATER_OR_EQUAL", "GREATER_OR_EQUAL"),
    GREATER(4, "GREATER", "GREATER"),
    UNEQUAL(5, "UNEQUAL", "UNEQUAL"),
    REGULAR_EXPRESSION(6, "REGULAR_EXPRESSION", "REGULAR_EXPRESSION");

    public static final int LESS_VALUE = 0;
    public static final int LESS_OR_EQUAL_VALUE = 1;
    public static final int EQUAL_VALUE = 2;
    public static final int GREATER_OR_EQUAL_VALUE = 3;
    public static final int GREATER_VALUE = 4;
    public static final int UNEQUAL_VALUE = 5;
    public static final int REGULAR_EXPRESSION_VALUE = 6;
    private static final ComparingOperator[] VALUES_ARRAY;
    public static final List<ComparingOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ComparingOperator[]{LESS, LESS_OR_EQUAL, EQUAL, GREATER_OR_EQUAL, GREATER, UNEQUAL, REGULAR_EXPRESSION};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ComparingOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ComparingOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ComparingOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ComparingOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ComparingOperator get(int value) {
        switch (value) {
            case 0: {
                return LESS;
            }
            case 1: {
                return LESS_OR_EQUAL;
            }
            case 2: {
                return EQUAL;
            }
            case 3: {
                return GREATER_OR_EQUAL;
            }
            case 4: {
                return GREATER;
            }
            case 5: {
                return UNEQUAL;
            }
            case 6: {
                return REGULAR_EXPRESSION;
            }
        }
        return null;
    }

    private ComparingOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

