/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.core.util;

import java.lang.reflect.Array;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EGenericTypeImpl;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.DelegatingEcoreEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;

public abstract class GenericTypeListHandler<C extends EClassifier> {
    private final InternalEObject owner;
    private final EReference genericTypesFeature;
    private final EReference rawTypesFeature;
    private EList<C> rawTypes;
    private EList<EGenericType> genericTypes;

    protected GenericTypeListHandler(InternalEObject owner, EReference rawTypeFeature, EReference genericTypeFeature) {
        this.owner = owner;
        this.genericTypesFeature = genericTypeFeature;
        this.rawTypesFeature = rawTypeFeature;
    }

    public EList<C> getRawTypes() {
        if (this.rawTypes == null) {
            this.rawTypes = new DelegatingEcoreEList<C>(this.owner){
                private static final long serialVersionUID = 1L;

                protected List<C> delegateList() {
                    return null;
                }

                protected List<C> delegateBasicList() {
                    return new AbstractSequentialList<C>(){

                        @Override
                        public ListIterator<C> listIterator(int index) {
                            return this.basicListIterator();
                        }

                        @Override
                        public int size() {
                            return this.delegateSize();
                        }
                    };
                }

                protected Iterator<C> delegateIterator() {
                    return this.iterator();
                }

                protected ListIterator<C> delegateListIterator() {
                    return this.listIterator();
                }

                protected void delegateAdd(int index, C eClass) {
                    GenericTypeListHandler.this.getGenericTypes().add(index, (Object)GenericTypeListHandler.this.wrap(eClass));
                }

                protected void delegateClear() {
                    GenericTypeListHandler.this.getGenericTypes().clear();
                }

                protected void delegateAdd(C eClass) {
                    GenericTypeListHandler.this.getGenericTypes().add((Object)GenericTypeListHandler.this.wrap(eClass));
                }

                protected boolean delegateContains(Object object) {
                    Iterator iterator = this.iterator();
                    while (iterator.hasNext()) {
                        EClassifier eClass = (EClassifier)iterator.next();
                        if (object != eClass) continue;
                        return true;
                    }
                    return false;
                }

                protected boolean delegateContainsAll(Collection<?> collection) {
                    for (Object object : collection) {
                        if (this.delegateContains(object)) continue;
                        return false;
                    }
                    return true;
                }

                protected boolean delegateEquals(Object object) {
                    List list;
                    if (object instanceof List && (list = (List)object).size() == this.delegateSize()) {
                        Iterator i = list.iterator();
                        Iterator j = this.iterator();
                        while (i.hasNext()) {
                            if (i.next() == j.next()) continue;
                            return false;
                        }
                        return true;
                    }
                    return false;
                }

                protected C delegateGet(int index) {
                    EGenericType eGenericType = (EGenericType)GenericTypeListHandler.this.getGenericTypes().get(index);
                    return GenericTypeListHandler.this.unwrap(eGenericType);
                }

                protected int delegateHashCode() {
                    int hashCode = 1;
                    for (EGenericType eGenericType : GenericTypeListHandler.this.getGenericTypes()) {
                        Object object = GenericTypeListHandler.this.unwrap(eGenericType);
                        hashCode = 31 * hashCode + (object == null ? 0 : object.hashCode());
                    }
                    return hashCode;
                }

                protected int delegateIndexOf(Object object) {
                    int index = 0;
                    for (EGenericType eGenericType : GenericTypeListHandler.this.getGenericTypes()) {
                        if (object == GenericTypeListHandler.this.unwrap(eGenericType)) {
                            return index;
                        }
                        ++index;
                    }
                    return -1;
                }

                protected boolean delegateIsEmpty() {
                    return GenericTypeListHandler.this.getGenericTypes().isEmpty();
                }

                protected int delegateLastIndexOf(Object object) {
                    EList<EGenericType> eGenericSuperTypes = GenericTypeListHandler.this.getGenericTypes();
                    int i = eGenericSuperTypes.size() - 1;
                    while (i >= 0) {
                        if (GenericTypeListHandler.this.unwrap((EGenericType)eGenericSuperTypes.get(i)) == object) {
                            return i;
                        }
                        --i;
                    }
                    return -1;
                }

                protected C delegateRemove(int index) {
                    EGenericType eGenericType = (EGenericType)GenericTypeListHandler.this.getGenericTypes().remove(index);
                    return GenericTypeListHandler.this.unwrap(eGenericType);
                }

                protected C delegateSet(int index, C eClass) {
                    EGenericType eGenericType = (EGenericType)GenericTypeListHandler.this.getGenericTypes().get(index);
                    Object result = GenericTypeListHandler.this.unwrap(eGenericType);
                    if (this.resolveProxy((EObject)result) == eClass) {
                        eGenericType.getERawType();
                    } else {
                        eGenericType.setEClassifier(eClass);
                    }
                    return result;
                }

                protected int delegateSize() {
                    return GenericTypeListHandler.this.getGenericTypes().size();
                }

                protected Object[] delegateToArray() {
                    int size = this.delegateSize();
                    Object[] result = new Object[size];
                    int index = 0;
                    for (EGenericType eGenericType : GenericTypeListHandler.this.getGenericTypes()) {
                        result[index++] = GenericTypeListHandler.this.unwrap(eGenericType);
                    }
                    return result;
                }

                protected <T> T[] delegateToArray(T[] array) {
                    int size = this.delegateSize();
                    if (array.length < size) {
                        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
                        array = newArray;
                    }
                    if (array.length > size) {
                        array[size] = null;
                    }
                    int index = 0;
                    for (EGenericType eGenericType : GenericTypeListHandler.this.getGenericTypes()) {
                        Object rawType = GenericTypeListHandler.this.unwrap(eGenericType);
                        array[index++] = rawType;
                    }
                    return array;
                }

                protected String delegateToString() {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("[");
                    EList<EGenericType> eGenericSuperTypes = GenericTypeListHandler.this.getGenericTypes();
                    int i = 0;
                    int size = this.delegateSize();
                    while (i < size) {
                        stringBuffer.append(String.valueOf(GenericTypeListHandler.this.unwrap((EGenericType)eGenericSuperTypes.get(i))));
                        if (++i >= size) continue;
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append("]");
                    return stringBuffer.toString();
                }

                protected boolean isInstance(Object object) {
                    return GenericTypeListHandler.this.isRawInstance(object);
                }

                public int getFeatureID() {
                    return GenericTypeListHandler.this.rawTypesFeature.getFeatureID();
                }

                protected boolean useEquals() {
                    return true;
                }

                protected boolean canContainNull() {
                    return false;
                }

                protected boolean isUnique() {
                    return true;
                }

                protected boolean hasInverse() {
                    return false;
                }

                protected boolean hasManyInverse() {
                    return false;
                }

                protected boolean hasNavigableInverse() {
                    return false;
                }

                protected boolean isEObject() {
                    return true;
                }

                protected boolean isContainment() {
                    return false;
                }

                protected boolean hasProxies() {
                    return true;
                }

                protected boolean hasInstanceClass() {
                    return true;
                }

                public boolean isSet() {
                    return GenericTypeListHandler.this.isSetGenericTypes();
                }

                protected NotificationImpl createNotification(int eventType, Object oldObject, Object newObject, int index, boolean wasSet) {
                    return null;
                }

                protected void dispatchNotification(Notification notification) {
                }
            };
        }
        return this.rawTypes;
    }

    public EList<EGenericType> getGenericTypes() {
        if (this.genericTypes == null) {
            this.genericTypes = new EObjectContainmentEList.Unsettable<EGenericType>(EGenericType.class, this.owner, this.genericTypesFeature.getFeatureID()){
                private static final long serialVersionUID = 1L;

                public boolean isSet() {
                    return GenericTypeListHandler.this.isSetGenericTypes();
                }

                protected boolean hasShadow() {
                    return true;
                }

                protected NotificationChain shadowAdd(EGenericType eGenericType, NotificationChain notifications) {
                    ENotificationImpl notification = new ENotificationImpl(this.owner, 3, (EStructuralFeature)GenericTypeListHandler.this.rawTypesFeature, null, GenericTypeListHandler.this.unwrap(eGenericType), this.indexOf(eGenericType), false);
                    if (notifications == null) {
                        notifications = notification;
                    } else {
                        notifications.add((Notification)notification);
                    }
                    return notifications;
                }

                protected NotificationChain shadowRemove(EGenericType eGenericType, NotificationChain notifications) {
                    ENotificationImpl notification = new ENotificationImpl(this.owner, 4, (EStructuralFeature)GenericTypeListHandler.this.rawTypesFeature, GenericTypeListHandler.this.unwrap(eGenericType), null, this.indexOf(eGenericType), false);
                    if (notifications == null) {
                        notifications = notification;
                    } else {
                        notifications.add((Notification)notification);
                    }
                    return notifications;
                }

                protected NotificationChain shadowSet(EGenericType oldEGenericType, EGenericType newEGenericType, NotificationChain notifications) {
                    ENotificationImpl notification = new ENotificationImpl(this.owner, 1, (EStructuralFeature)GenericTypeListHandler.this.rawTypesFeature, GenericTypeListHandler.this.unwrap(oldEGenericType), GenericTypeListHandler.this.unwrap(newEGenericType), this.indexOf(oldEGenericType), false);
                    if (notifications == null) {
                        notifications = notification;
                    } else {
                        notifications.add((Notification)notification);
                    }
                    return notifications;
                }

                public EGenericType move(int targetIndex, int sourceIndex) {
                    EGenericType result = (EGenericType)super.move(targetIndex, sourceIndex);
                    if (this.isNotificationRequired()) {
                        this.dispatchNotification((Notification)new ENotificationImpl(GenericTypeListHandler.this.owner, 7, (EStructuralFeature)GenericTypeListHandler.this.rawTypesFeature, (Object)sourceIndex, GenericTypeListHandler.this.unwrap(result), targetIndex));
                    }
                    return result;
                }

                public void unset() {
                    this.clear();
                }

                protected NotificationImpl createNotification(int eventType, Object oldObject, Object newObject, int index, boolean wasSet) {
                    switch (eventType) {
                        case 3: {
                            return super.createNotification(eventType, oldObject, newObject, index, this.size > 1);
                        }
                        case 5: {
                            return super.createNotification(eventType, oldObject, newObject, index, this.size - ((List)newObject).size() > 0);
                        }
                    }
                    return super.createNotification(eventType, oldObject, newObject, index, true);
                }
            };
            this.getRawTypes();
        }
        return this.genericTypes;
    }

    public boolean isSetGenericTypes() {
        for (EGenericType eGenericType : this.getGenericTypes()) {
            if (eGenericType.getETypeParameter() == null && eGenericType.getETypeArguments().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean isSetRawTypes() {
        return this.rawTypes != null && !this.rawTypes.isEmpty() && !this.isSetGenericTypes();
    }

    protected abstract boolean isRawInstance(Object var1);

    protected C unwrap(EGenericType genericType) {
        EClassifier rawType = ((EGenericTypeImpl)genericType).basicGetERawType();
        return this.adaptUnwrappedType(rawType);
    }

    protected abstract C adaptUnwrappedType(EClassifier var1);

    protected EGenericType wrap(C eClassifier) {
        EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
        eGenericType.setEClassifier(eClassifier);
        return eGenericType;
    }

    public static class EClasses
    extends GenericTypeListHandler<EClass> {
        public EClasses(InternalEObject owner, EReference rawTypeFeature, EReference genericTypeFeature) {
            super(owner, rawTypeFeature, genericTypeFeature);
        }

        @Override
        protected boolean isRawInstance(Object object) {
            return object instanceof EClass;
        }

        @Override
        protected EClass adaptUnwrappedType(EClassifier rawType) {
            return rawType instanceof EClass ? (EClass)rawType : EcorePackage.Literals.EOBJECT;
        }
    }

    public static class EClassifiers
    extends GenericTypeListHandler<EClassifier> {
        public EClassifiers(InternalEObject owner, EReference rawTypeFeature, EReference genericTypeFeature) {
            super(owner, rawTypeFeature, genericTypeFeature);
        }

        @Override
        protected boolean isRawInstance(Object object) {
            return object instanceof EClassifier;
        }

        @Override
        protected EClassifier adaptUnwrappedType(EClassifier rawType) {
            return rawType;
        }
    }

    public static class EDataTypes
    extends GenericTypeListHandler<EDataType> {
        public EDataTypes(InternalEObject owner, EReference rawTypeFeature, EReference genericTypeFeature) {
            super(owner, rawTypeFeature, genericTypeFeature);
        }

        @Override
        protected boolean isRawInstance(Object object) {
            return object instanceof EDataType;
        }

        @Override
        protected EDataType adaptUnwrappedType(EClassifier rawType) {
            return rawType instanceof EDataType ? (EDataType)rawType : EcorePackage.Literals.EJAVA_OBJECT;
        }
    }

    public static class EEnums
    extends GenericTypeListHandler<EEnum> {
        public EEnums(InternalEObject owner, EReference rawTypeFeature, EReference genericTypeFeature) {
            super(owner, rawTypeFeature, genericTypeFeature);
        }

        @Override
        protected boolean isRawInstance(Object object) {
            return object instanceof EEnum;
        }

        @Override
        protected EEnum adaptUnwrappedType(EClassifier rawType) {
            return rawType instanceof EEnum ? (EEnum)rawType : null;
        }
    }
}

