/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.custom.dialogs;

import de.upb.swt.core.ui.providers.ComposedAdapterFactoryLabelProvider;
import de.upb.swt.core.ui.providers.ContainmentContentProvider;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.storydriven.storydiagrams.diagram.custom.Activator;
import org.storydriven.storydiagrams.diagram.custom.dialogs.LoadResourceDialog;

public abstract class AbstractTreeSelectionDialog<T>
extends TitleAreaDialog {
    private String shellText;
    private String title;
    private String description;
    private T element;
    private Collection<T> elements;
    private Collection<T> hidden;
    private Text filterText;
    private TreeViewer elementViewer;
    private ElementViewerFilter viewerFilter;
    private LoadResourceDialog loadDialog;
    private ResourceSet resourceSet;

    public AbstractTreeSelectionDialog(String title, String description) {
        this(title, title, description);
    }

    public AbstractTreeSelectionDialog(String shellText, String title, String description) {
        super(PlatformUI.getWorkbench().getDisplay().getActiveShell());
        this.shellText = shellText;
        this.title = title;
        this.description = description;
        this.setHelpAvailable(false);
    }

    public void reset() {
        this.element = null;
        this.elements = null;
        this.hidden = null;
        if (this.viewerFilter != null) {
            this.viewerFilter.setFilterText("");
        }
        if (this.filterText != null && !this.filterText.isDisposed()) {
            this.filterText.setText("");
        }
    }

    public void setHiddenElements(Collection<T> hidden) {
        this.hidden = hidden;
    }

    public void setResourceSet(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    public T getElement() {
        return this.element;
    }

    public Collection<T> getElements() {
        return this.elements;
    }

    public void setSelectedElement(T element) {
        this.element = element;
    }

    protected boolean showTextFilter() {
        return true;
    }

    protected boolean isMulti() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        ViewerFilter customFilter;
        this.setTitle(this.title);
        this.setMessage(this.description);
        Composite areaComposite = (Composite)super.createDialogArea(parent);
        Composite mainComposite = new Composite(areaComposite, 0);
        GridLayoutFactory.fillDefaults().margins(6, 6).applyTo(mainComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)mainComposite);
        if (this.showTextFilter()) {
            this.filterText = new Text(mainComposite, 19076);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.filterText);
        }
        int style = this.isMulti() ? 2 : 4;
        this.elementViewer = new TreeViewer(mainComposite, 0x800 | style);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.elementViewer.getControl());
        this.elementViewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.elementViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.elementViewer.setComparator(this.getViewerComparator());
        if (this.showTextFilter()) {
            this.viewerFilter = new ElementViewerFilter();
            this.elementViewer.addFilter((ViewerFilter)this.viewerFilter);
        }
        if ((customFilter = this.getViewerFilter()) != null) {
            this.elementViewer.addFilter(customFilter);
        }
        this.elementViewer.setInput(this.getInput());
        this.hookListeners();
        if (this.element != null) {
            this.elementViewer.setSelection((ISelection)new StructuredSelection(this.element), true);
        }
        this.checkValidity();
        this.elementViewer.getControl().setFocus();
        return this.elementViewer.getControl();
    }

    protected Control createButtonBar(Composite parent) {
        if (this.hasLoadButton()) {
            Composite wrapperComposite = new Composite(parent, 0);
            GridLayoutFactory.fillDefaults().numColumns(2).applyTo(wrapperComposite);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)wrapperComposite);
            Composite loadButtonsComposite = new Composite(wrapperComposite, 0);
            GridLayoutFactory.fillDefaults().applyTo(loadButtonsComposite);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, true).applyTo((Control)loadButtonsComposite);
            Button button = new Button(loadButtonsComposite, 8);
            GridDataFactory.fillDefaults().align(4, 0x1000000).indent(12, 0).applyTo((Control)button);
            button.setText("Load Resource...");
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractTreeSelectionDialog.this.handleLoadButtonClicked();
                }
            });
            Composite buttonsComposite = new Composite(wrapperComposite, 0);
            GridLayoutFactory.fillDefaults().applyTo(buttonsComposite);
            super.createButtonBar(buttonsComposite);
            return wrapperComposite;
        }
        return super.createButtonBar(parent);
    }

    protected boolean hasLoadButton() {
        return false;
    }

    protected ILabelProvider getLabelProvider() {
        return new ComposedAdapterFactoryLabelProvider();
    }

    protected ITreeContentProvider getContentProvider() {
        return new ContainmentContentProvider();
    }

    protected abstract Object getInput();

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.shellText);
    }

    protected ViewerComparator getViewerComparator() {
        return new ViewerComparator();
    }

    protected ViewerFilter getViewerFilter() {
        return null;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        String sectionName = ((Object)((Object)this)).getClass().getCanonicalName();
        IDialogSettings plugin = Activator.getInstance().getDialogSettings();
        IDialogSettings dialog = plugin.getSection(sectionName);
        if (dialog == null) {
            dialog = plugin.addNewSection(sectionName);
        }
        return dialog;
    }

    protected boolean isResizable() {
        return true;
    }

    protected String getErrorMessage(Object element) {
        return null;
    }

    protected String getEmptyMessage() {
        return "You have to select an element!";
    }

    private void handleLoadButtonClicked() {
        if (this.loadDialog == null) {
            this.loadDialog = new LoadResourceDialog();
        }
        this.loadDialog.setSelectedElement(null);
        this.loadDialog.setResourceSet(this.resourceSet);
        if (this.loadDialog.open() == 0) {
            try {
                IRunnableWithProgress op = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        String path = ((IFile)AbstractTreeSelectionDialog.this.loadDialog.getElement()).getFullPath().toString();
                        URI uri = URI.createPlatformResourceURI((String)path, (boolean)true);
                        String message = String.format("Loading Resource '%1s'...", path);
                        monitor.beginTask(message, -1);
                        Resource resource = AbstractTreeSelectionDialog.this.resourceSet.getResource(uri, true);
                        try {
                            resource.load(AbstractTreeSelectionDialog.getLoadOptions(resource));
                        }
                        catch (IOException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                };
                new ProgressMonitorDialog(this.getShell()).run(true, false, op);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.elementViewer.setInput(this.getInput());
        }
    }

    private static Map<Object, Object> getLoadOptions(Resource resource) {
        Map options = resource.getResourceSet().getLoadOptions();
        options.put("DEFER_ATTACHMENT", Boolean.TRUE);
        options.put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
        options.put("USE_DEPRECATED_METHODS", Boolean.TRUE);
        options.put("USE_PARSER_POOL", new XMLParserPoolImpl());
        options.put("USE_XML_NAME_TO_FEATURE_MAP", new HashMap());
        ((ResourceImpl)resource).setIntrinsicIDToEObjectMap(new LinkedHashMap());
        return options;
    }

    private void hookListeners() {
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractTreeSelectionDialog.this.viewerFilter.setFilterText(AbstractTreeSelectionDialog.this.filterText.getText());
                AbstractTreeSelectionDialog.this.elementViewer.refresh(false);
            }
        });
        this.elementViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AbstractTreeSelectionDialog.this.checkValidity();
                if (AbstractTreeSelectionDialog.this.element != null) {
                    AbstractTreeSelectionDialog.this.okPressed();
                } else {
                    IStructuredSelection selection = (IStructuredSelection)AbstractTreeSelectionDialog.this.elementViewer.getSelection();
                    if (selection.size() == 1) {
                        Object element = selection.getFirstElement();
                        boolean expanded = AbstractTreeSelectionDialog.this.elementViewer.getExpandedState(element);
                        AbstractTreeSelectionDialog.this.elementViewer.setExpandedState(element, !expanded);
                    }
                }
            }
        });
        this.elementViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractTreeSelectionDialog.this.checkValidity();
            }
        });
    }

    private void checkValidity() {
        Button okButton;
        this.element = null;
        this.elements = new ArrayList<T>();
        IStructuredSelection selection = (IStructuredSelection)this.elementViewer.getSelection();
        String error = null;
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object selected = objectArray[n2];
            error = this.getErrorMessage(selected);
            if (error != null) break;
            this.elements.add(selected);
            this.element = selected;
            ++n2;
        }
        if (error == null && this.elements.isEmpty()) {
            error = this.getEmptyMessage();
        }
        if ((okButton = this.getButton(0)) != null) {
            okButton.setEnabled(error == null);
        }
        if (error != null) {
            this.setErrorMessage(error);
        } else {
            this.setErrorMessage(null);
            this.setMessage(this.description);
        }
    }

    private class ElementViewerFilter
    extends ViewerFilter {
        private String filterText;

        private ElementViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            if (AbstractTreeSelectionDialog.this.hidden == null || !AbstractTreeSelectionDialog.this.hidden.contains(element)) {
                if (AbstractTreeSelectionDialog.this.showTextFilter() && this.filterText != null && !this.filterText.trim().isEmpty()) {
                    ILabelProvider labelProvider = (ILabelProvider)((TreeViewer)viewer).getLabelProvider();
                    String elementString = labelProvider.getText(element).toLowerCase();
                    String filterString = this.filterText.toLowerCase();
                    return elementString.contains(filterString);
                }
                return true;
            }
            return false;
        }

        public void setFilterText(String filterText) {
            this.filterText = filterText.toLowerCase();
        }
    }
}

