/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.custom.dialogs;

import de.upb.swt.core.ui.providers.ComposedAdapterFactoryLabelProvider;
import de.upb.swt.core.ui.providers.ContainmentContentProvider;
import java.util.HashSet;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.storydriven.storydiagrams.diagram.custom.DiagramImages;
import org.storydriven.storydiagrams.diagram.custom.dialogs.AbstractTreeSelectionDialog;

public class SelectEPackageFromRegistryDialog
extends AbstractTreeSelectionDialog<EPackage> {
    private static final String TITLE = "Add Registered Packages";
    private static final String DESCRIPTION = "Select the packages that should be added to the type model.";

    public SelectEPackageFromRegistryDialog() {
        super(TITLE, DESCRIPTION);
        this.setTitleImage(DiagramImages.getImage("icons/banners/add_epackage_uri.png"));
    }

    @Override
    protected ILabelProvider getLabelProvider() {
        return new ComposedAdapterFactoryLabelProvider(){

            public String getText(Object element) {
                return ((EPackage)element).getNsURI();
            }
        };
    }

    @Override
    protected ITreeContentProvider getContentProvider() {
        return new ContainmentContentProvider(){
            private Object[] cached;

            public Object[] getElements(Object element) {
                if (this.cached == null) {
                    EPackage.Registry reg = EPackage.Registry.INSTANCE;
                    HashSet<EPackage> all = new HashSet<EPackage>();
                    Object[] objectArray = super.getElements(element);
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object child = objectArray[n2];
                        if (reg.containsKey(child)) {
                            try {
                                all.add(reg.getEPackage((String)child));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                System.out.println("Exception ignored during resolving of EPackage with namespace URI " + child);
                            }
                        }
                        ++n2;
                    }
                    this.cached = all.toArray(new Object[all.size()]);
                }
                return this.cached;
            }

            public Object[] getChildren(Object element) {
                return new Object[0];
            }
        };
    }

    @Override
    protected Object getInput() {
        return EPackage.Registry.INSTANCE.keySet();
    }
}

