/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.custom.edit.parts;

import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;
import org.storydriven.storydiagrams.diagram.custom.util.SdmUtility;
import org.storydriven.storydiagrams.diagram.edit.parts.LinkVariableEditPart;
import org.storydriven.storydiagrams.patterns.AbstractLinkVariable;
import org.storydriven.storydiagrams.patterns.BindingSemantics;
import org.storydriven.storydiagrams.patterns.LinkVariable;

public class CustomLinkVariableEditPart
extends LinkVariableEditPart {
    private PolygonDecoration cross;

    public CustomLinkVariableEditPart(View view) {
        super(view);
        PointList pl = new PointList();
        pl.addPoint(-2, -2);
        pl.addPoint(0, 0);
        pl.addPoint(2, -2);
        pl.addPoint(0, 0);
        pl.addPoint(2, 2);
        pl.addPoint(0, 0);
        pl.addPoint(-2, 2);
        pl.addPoint(0, 0);
        this.cross = new PolygonDecoration();
        this.cross.setTemplate(pl);
        this.cross.setScale((double)this.getMapMode().DPtoLP(1), (double)this.getMapMode().DPtoLP(1));
    }

    protected void handleNotificationEvent(Notification event) {
        this.updateFigure();
        super.handleNotificationEvent(event);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.updateFigure();
    }

    private void updateFigure() {
        LinkVariable link = (LinkVariable)((View)this.getModel()).getElement();
        Color color = SdmUtility.getColor((AbstractLinkVariable)link);
        RotatableDecoration targetDecoration = null;
        if (link.getSourceEnd() == null && link.getTargetEnd() != null) {
            targetDecoration = this.createTargetDecoration(color);
        }
        this.getPrimaryShape().setTargetDecoration(targetDecoration);
        RotatableDecoration sourceDecoration = null;
        if (link.getTargetEnd() != null && link.getTargetEnd().isContainment()) {
            sourceDecoration = this.createSourceDecoration(color);
        }
        this.getPrimaryShape().setSourceDecoration(sourceDecoration);
        this.getPrimaryShape().setForegroundColor(color);
        if (BindingSemantics.OPTIONAL.equals((Object)link.getBindingSemantics())) {
            this.getPrimaryShape().setLineStyle(2);
        } else {
            this.getPrimaryShape().setLineStyle(1);
        }
        if (!BindingSemantics.NEGATIVE.equals((Object)link.getBindingSemantics())) {
            this.getPrimaryShape().getChildren().contains(this.cross);
        }
    }

    private RotatableDecoration createTargetDecoration(Color color) {
        PolylineDecoration df = new PolylineDecoration();
        df.setForegroundColor(color);
        return df;
    }

    private RotatableDecoration createSourceDecoration(Color color) {
        PolygonDecoration df = new PolygonDecoration();
        df.setForegroundColor(color);
        df.setFill(true);
        PointList pl = new PointList();
        pl.addPoint(this.getMapMode().DPtoLP(0), this.getMapMode().DPtoLP(0));
        pl.addPoint(this.getMapMode().DPtoLP(-1), this.getMapMode().DPtoLP(1));
        pl.addPoint(this.getMapMode().DPtoLP(-2), this.getMapMode().DPtoLP(0));
        pl.addPoint(this.getMapMode().DPtoLP(-1), this.getMapMode().DPtoLP(-1));
        df.setTemplate(pl);
        df.setScale((double)this.getMapMode().DPtoLP(7), (double)this.getMapMode().DPtoLP(3));
        return df;
    }
}

