/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.custom.properties;

import de.upb.swt.core.ui.properties.sections.AbstractPropertySection;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.storydriven.core.expressions.Expression;
import org.storydriven.core.expressions.TextualExpression;
import org.storydriven.core.ui.IExpressionEditor;
import org.storydriven.core.ui.util.ExpressionEditorUtil;
import org.storydriven.storydiagrams.diagram.custom.util.BoundUtil;
import org.storydriven.storydiagrams.diagram.custom.util.EcoreTextUtil;

public abstract class AbstractExpressionSection
extends AbstractPropertySection {
    private IExpressionEditor provider;
    private Group group;
    private CLabel typeLabel;
    protected ISourceViewer viewer;

    public void refresh() {
        Expression expression = this.getExpression();
        if (this.getElement() != null && expression instanceof TextualExpression) {
            TextualExpression textualExpression = (TextualExpression)expression;
            this.provider = ExpressionEditorUtil.getEditor((String)textualExpression.getLanguage(), (String)textualExpression.getLanguageVersion());
            EClassifier classifier = this.getContextClassifier();
            String value = ((TextualExpression)expression).getExpressionText();
            if (this.viewer != null) {
                this.viewer.getTextWidget().dispose();
                this.viewer = null;
            }
            this.viewer = this.provider.createSourceViewer((Composite)this.group, 2816, classifier, this.getContextInformation(), value);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.viewer.getTextWidget());
            this.viewer.addTextListener(new ITextListener(){

                public void textChanged(TextEvent event) {
                    final Expression expression = AbstractExpressionSection.this.getExpression();
                    if (expression instanceof TextualExpression) {
                        RecordingCommand command = new RecordingCommand((TransactionalEditingDomain)AbstractExpressionSection.this.getEditingDomain()){

                            protected void doExecute() {
                                ((TextualExpression)expression).setExpressionText((this).AbstractExpressionSection.this.viewer.getDocument().get());
                                AbstractExpressionSection.this.postUpdate();
                            }
                        };
                        AbstractExpressionSection.this.execute((Command)command);
                    }
                }
            });
            this.typeLabel.setText(this.getTypeText(classifier));
            this.provider.setText(value);
            this.group.setVisible(true);
            this.group.layout();
        } else {
            this.group.setVisible(false);
        }
    }

    protected abstract Expression getExpression();

    protected EClassifier getContextClassifier() {
        return null;
    }

    protected Map<String, EClassifier> getContextInformation() {
        return BoundUtil.getBoundObjects((EObject)this.getElement());
    }

    private String getTypeText(EClassifier classifier) {
        StringBuilder builder = new StringBuilder();
        builder.append("Expected return type of the following OCL 1.0 constraint: '");
        builder.append(EcoreTextUtil.getText((EClassifier)classifier));
        builder.append("'.");
        return builder.toString();
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void dispose() {
        if (this.provider != null) {
            this.provider.dispose();
        }
        super.dispose();
    }

    protected void createWidgets(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        this.group = factory.createGroup(parent, this.getLabelText());
        GridLayoutFactory.fillDefaults().margins(6, 6).applyTo((Composite)this.group);
        this.typeLabel = factory.createCLabel((Composite)this.group, "", 16384);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.typeLabel);
    }

    protected String getLabelText() {
        return "Textual Expression";
    }

    protected void postUpdate() {
    }

    protected void layoutWidgets() {
        FormData data = new FormData();
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.top = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        this.group.setLayoutData((Object)data);
    }
}

