/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.custom.properties.sections;

import de.upb.swt.core.ui.properties.sections.AbstractPropertySection;
import de.upb.swt.core.ui.providers.ContainmentContentProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.storydriven.core.expressions.Expression;
import org.storydriven.core.expressions.ExpressionsFactory;
import org.storydriven.core.expressions.TextualExpression;
import org.storydriven.storydiagrams.activities.ActivityCallNode;
import org.storydriven.storydiagrams.calls.Callable;
import org.storydriven.storydiagrams.calls.CallsFactory;
import org.storydriven.storydiagrams.calls.CallsPackage;
import org.storydriven.storydiagrams.calls.ParameterBinding;
import org.storydriven.storydiagrams.diagram.custom.DiagramImages;
import org.storydriven.storydiagrams.diagram.custom.EditExpressionDialog;
import org.storydriven.storydiagrams.diagram.custom.util.ActivityUtil;
import org.storydriven.storydiagrams.diagram.custom.util.BoundUtil;
import org.storydriven.storydiagrams.diagram.custom.util.EcoreTextUtil;
import org.storydriven.storydiagrams.diagram.custom.util.TextUtil;

public abstract class AbstractActivityCallNodeArgumentsSection
extends AbstractPropertySection {
    private EditExpressionDialog dialog = new EditExpressionDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell());
    private TableViewer viewer;
    private Label label;

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.viewer.setInput(this.getInput());
    }

    protected boolean shouldRefresh(Notification msg) {
        return super.shouldRefresh(msg) && msg.getFeature() != null && msg.getFeature().equals(CallsPackage.Literals.INVOCATION__CALLEE);
    }

    public void refresh() {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.setInput(this.getInput());
        }
    }

    private Object getInput() {
        if (this.getElement() == null || this.getElement().getCallee() == null) {
            return Collections.emptyList();
        }
        return new ArrayList<EParameter>(this.getParameters());
    }

    protected abstract Collection<? extends EParameter> getParameters();

    private TextualExpression getExpression(EParameter element) {
        Expression expression = this.getBinding(element).getValueExpression();
        if (expression instanceof TextualExpression) {
            return (TextualExpression)expression;
        }
        if (expression == null) {
            TextualExpression newExpression = ExpressionsFactory.eINSTANCE.createTextualExpression();
            newExpression.setLanguage("OCL");
            newExpression.setLanguageVersion("3.0");
            EReference feature = CallsPackage.Literals.PARAMETER_BINDING__VALUE_EXPRESSION;
            Command command = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getBinding(element), (Object)feature, (Object)newExpression);
            this.execute(command);
            return newExpression;
        }
        return null;
    }

    private ParameterBinding getBinding(EParameter parameter) {
        if (parameter != null) {
            for (ParameterBinding binding : this.getElement().getOwnedParameterBindings()) {
                if (!parameter.equals(binding.getParameter())) continue;
                return binding;
            }
        }
        ArrayList<ParameterBinding> toRemove = new ArrayList<ParameterBinding>();
        for (ParameterBinding binding : this.getElement().getOwnedParameterBindings()) {
            if (!this.getParameters().contains(binding)) continue;
            toRemove.add(binding);
        }
        ActivityCallNode owner = this.getElement();
        EReference feature = CallsPackage.Literals.INVOCATION__OWNED_PARAMETER_BINDINGS;
        CompoundCommand command = new CompoundCommand();
        command.append(RemoveCommand.create((EditingDomain)this.getEditingDomain(), (Object)owner, (Object)feature, toRemove));
        for (EParameter eParameter : this.getParameters()) {
            ParameterBinding binding = CallsFactory.eINSTANCE.createParameterBinding();
            binding.setParameter(eParameter);
            command.append(AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)owner, (Object)feature, (Object)binding));
        }
        this.execute(command.unwrap());
        return this.getBinding(parameter);
    }

    protected ActivityCallNode getElement() {
        return (ActivityCallNode)super.getElement();
    }

    protected void createWidgets(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        this.label = factory.createLabel(parent, "Arguments:", 131072);
        final Table table = factory.createTable(parent, 67584);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer = new TableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new ContainmentContentProvider());
        TableViewerColumn parameterColumn = new TableViewerColumn(this.viewer, 16384);
        parameterColumn.getColumn().setText("Parameter");
        parameterColumn.getColumn().setWidth(150);
        parameterColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return EcoreTextUtil.getText((EParameter)((EParameter)element));
            }

            public Image getImage(Object element) {
                if (AbstractActivityCallNodeArgumentsSection.this.getParameters().contains(element)) {
                    return DiagramImages.getImage("icons/elements/ecore/EParameter_out.png");
                }
                return DiagramImages.getImage("icons/elements/ecore/EParameter_in.png");
            }
        });
        TableViewerColumn argumentColumn = new TableViewerColumn(this.viewer, 16384);
        argumentColumn.getColumn().setText("Argument");
        argumentColumn.getColumn().setWidth(200);
        argumentColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ParameterBinding binding = AbstractActivityCallNodeArgumentsSection.this.getBinding((EParameter)element);
                return TextUtil.getText((Expression)binding.getValueExpression());
            }
        });
        EditingSupport editingSupport = new EditingSupport((ColumnViewer)this.viewer){

            protected void setValue(Object element, Object value) {
                AbstractActivityCallNodeArgumentsSection.this.viewer.refresh();
                Callable callee = AbstractActivityCallNodeArgumentsSection.this.getElement().getCallee();
                ActivityCallNode owner = AbstractActivityCallNodeArgumentsSection.this.getElement();
                EReference feature = CallsPackage.Literals.INVOCATION__CALLEE;
                Command command = SetCommand.create((EditingDomain)AbstractActivityCallNodeArgumentsSection.this.getEditingDomain(), (Object)owner, (Object)feature, null);
                command.chain(SetCommand.create((EditingDomain)AbstractActivityCallNodeArgumentsSection.this.getEditingDomain(), (Object)owner, (Object)feature, (Object)callee));
                AbstractActivityCallNodeArgumentsSection.this.execute(command);
            }

            protected Object getValue(Object element) {
                ParameterBinding binding = AbstractActivityCallNodeArgumentsSection.this.getBinding((EParameter)element);
                return TextUtil.getText((Expression)binding.getValueExpression());
            }

            protected CellEditor getCellEditor(final Object element) {
                final TextualExpression expression = AbstractActivityCallNodeArgumentsSection.this.getExpression((EParameter)element);
                if (expression != null) {
                    return new DialogCellEditor((Composite)table){

                        protected Object openDialogBox(Control control) {
                            AbstractActivityCallNodeArgumentsSection.this.dialog.setExpression(expression);
                            AbstractActivityCallNodeArgumentsSection.this.dialog.setContextInformation(BoundUtil.getBoundObjects((EObject)AbstractActivityCallNodeArgumentsSection.this.getElement()));
                            AbstractActivityCallNodeArgumentsSection.this.dialog.setExpectedReturnType(((EParameter)element).getEType());
                            AbstractActivityCallNodeArgumentsSection.this.dialog.setActivity(ActivityUtil.getActivity((Object)AbstractActivityCallNodeArgumentsSection.this.getElement()));
                            AbstractActivityCallNodeArgumentsSection.this.dialog.setChangeAttributeCommand(null, AbstractActivityCallNodeArgumentsSection.this.getEditingDomain());
                            if (AbstractActivityCallNodeArgumentsSection.this.dialog.open() == 0) {
                                return AbstractActivityCallNodeArgumentsSection.this.dialog.getExpression();
                            }
                            return null;
                        }
                    };
                }
                return null;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        };
        argumentColumn.setEditingSupport(editingSupport);
    }

    protected void layoutWidgets() {
        Table table = this.viewer.getTable();
        FormData data = new FormData();
        data.left = new FormAttachment(0, 120);
        data.right = new FormAttachment(100);
        data.top = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        table.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0);
        data.right = new FormAttachment((Control)table);
        data.top = new FormAttachment((Control)table, 0, 128);
        data.bottom = new FormAttachment((Control)table, 0, 1024);
        this.label.setLayoutData((Object)data);
    }
}

