/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.custom.util;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.storydriven.storydiagrams.activities.ActivitiesFactory;
import org.storydriven.storydiagrams.activities.Activity;
import org.storydriven.storydiagrams.diagram.part.StorydiagramsDiagramEditorPlugin;

public class StoryDiagramsUtil {
    private static final String ACTIVITIES = "http://www.storydriven.org/storydiagrams/activities";
    private static final String ACTIVITY = "http://www.storydriven.org/storydiagrams/activity";
    private static final String CONTAINER = "http://www.storydriven.org/storydiagrams/container";
    private static final String DIAGRAMS = "http://www.storydriven.org/storydiagrams/diagrams";
    public static final String SD_FILE_EXTENSION = "sd";
    public static final String SD_DIAGRAM_FILE_EXTENSION = "sd_diagrams";

    public static EAnnotation findPointerToActivity(EOperation eOperation) {
        return eOperation.getEAnnotation(ACTIVITY);
    }

    private static EAnnotation findOrCreatePointerToActivity(EOperation eOperation) {
        EAnnotation pointerToActivity = StoryDiagramsUtil.findPointerToActivity(eOperation);
        if (pointerToActivity == null) {
            pointerToActivity = EcoreFactory.eINSTANCE.createEAnnotation();
            pointerToActivity.setSource(ACTIVITY);
            pointerToActivity.setEModelElement((EModelElement)eOperation);
        }
        return pointerToActivity;
    }

    public static Activity findActivity(EOperation eOperation) {
        EAnnotation pointerToActivity = StoryDiagramsUtil.findPointerToActivity(eOperation);
        if (pointerToActivity != null) {
            for (EObject reference : pointerToActivity.getReferences()) {
                if (!(reference instanceof Activity)) continue;
                return (Activity)reference;
            }
        }
        return null;
    }

    public static EAnnotation findPointerToAllActivitiesContainer(EOperation eOperation) {
        for (EObject rootElement : eOperation.eResource().getContents()) {
            if (!(rootElement instanceof EModelElement)) continue;
            return ((EModelElement)rootElement).getEAnnotation(ACTIVITIES);
        }
        return null;
    }

    private static EAnnotation findOrCreatePointerToAllActivitiesContainer(EOperation eOperation) {
        EAnnotation pointerToAllActivitiesContainer = StoryDiagramsUtil.findPointerToAllActivitiesContainer(eOperation);
        if (pointerToAllActivitiesContainer == null) {
            pointerToAllActivitiesContainer = EcoreFactory.eINSTANCE.createEAnnotation();
            pointerToAllActivitiesContainer.setSource(ACTIVITIES);
            for (EObject rootElement : eOperation.eResource().getContents()) {
                if (!(rootElement instanceof EModelElement)) continue;
                pointerToAllActivitiesContainer.setEModelElement((EModelElement)rootElement);
                break;
            }
        }
        return pointerToAllActivitiesContainer;
    }

    public static EAnnotation findAllActivitiesContainer(EOperation eOperation) {
        EAnnotation pointerToActivitiesContainer = StoryDiagramsUtil.findPointerToAllActivitiesContainer(eOperation);
        if (pointerToActivitiesContainer != null) {
            for (EObject reference : pointerToActivitiesContainer.getReferences()) {
                if (!(reference instanceof EAnnotation) || !((EAnnotation)reference).getSource().equals(CONTAINER)) continue;
                return (EAnnotation)reference;
            }
        }
        return null;
    }

    private static EAnnotation findOrCreateAllActivitiesContainer(EOperation eOperation) {
        EAnnotation allActivitiesContainer = StoryDiagramsUtil.findAllActivitiesContainer(eOperation);
        if (allActivitiesContainer == null) {
            EAnnotation pointerToAllActivitiesContainer = StoryDiagramsUtil.findOrCreatePointerToAllActivitiesContainer(eOperation);
            allActivitiesContainer = EcoreFactory.eINSTANCE.createEAnnotation();
            allActivitiesContainer.setSource(CONTAINER);
            pointerToAllActivitiesContainer.getReferences().add((Object)allActivitiesContainer);
            URI baseUri = eOperation.eResource().getURI().trimFileExtension();
            URI activitiesUri = baseUri.appendFileExtension(SD_FILE_EXTENSION);
            Resource activitiesResource = eOperation.eResource().getResourceSet().createResource(activitiesUri);
            activitiesResource.getContents().add((Object)allActivitiesContainer);
        }
        return allActivitiesContainer;
    }

    public static EAnnotation findPointerToAllActivityDiagramsContainer(EOperation eOperation) {
        EAnnotation activitiesContainer = StoryDiagramsUtil.findAllActivitiesContainer(eOperation);
        if (activitiesContainer != null) {
            return activitiesContainer.getEAnnotation(DIAGRAMS);
        }
        return null;
    }

    private static EAnnotation findOrCreatePointerToAllActivityDiagramsContainer(EOperation eOperation) {
        EAnnotation pointerToAllActivityDiagramsContainer = StoryDiagramsUtil.findPointerToAllActivityDiagramsContainer(eOperation);
        if (pointerToAllActivityDiagramsContainer == null) {
            EAnnotation activitiesContainer = StoryDiagramsUtil.findOrCreateAllActivitiesContainer(eOperation);
            pointerToAllActivityDiagramsContainer = EcoreFactory.eINSTANCE.createEAnnotation();
            pointerToAllActivityDiagramsContainer.setSource(DIAGRAMS);
            activitiesContainer.getEAnnotations().add((Object)pointerToAllActivityDiagramsContainer);
        }
        return pointerToAllActivityDiagramsContainer;
    }

    public static EAnnotation findAllActivityDiagramsContainer(EOperation eOperation) {
        EAnnotation pointerToAllActivityDiagramsContainer = StoryDiagramsUtil.findPointerToAllActivityDiagramsContainer(eOperation);
        if (pointerToAllActivityDiagramsContainer != null) {
            for (EObject reference : pointerToAllActivityDiagramsContainer.getReferences()) {
                if (!(reference instanceof EAnnotation) || !((EAnnotation)reference).getSource().equals(CONTAINER)) continue;
                return (EAnnotation)reference;
            }
        }
        return null;
    }

    private static EAnnotation findOrCreateAllActivityDiagramsContainer(EOperation eOperation) {
        EAnnotation activityDiagramsContainer = StoryDiagramsUtil.findAllActivityDiagramsContainer(eOperation);
        if (activityDiagramsContainer == null) {
            EAnnotation pointerToAllActivityDiagramsContainer = StoryDiagramsUtil.findOrCreatePointerToAllActivityDiagramsContainer(eOperation);
            activityDiagramsContainer = EcoreFactory.eINSTANCE.createEAnnotation();
            activityDiagramsContainer.setSource(CONTAINER);
            pointerToAllActivityDiagramsContainer.getReferences().add((Object)activityDiagramsContainer);
            URI baseUri = eOperation.eResource().getURI().trimFileExtension();
            URI activityDiagramsUri = baseUri.appendFileExtension(SD_DIAGRAM_FILE_EXTENSION);
            Resource activityDiagramsResource = eOperation.eResource().getResourceSet().createResource(activityDiagramsUri);
            activityDiagramsResource.getContents().add((Object)activityDiagramsContainer);
        }
        return activityDiagramsContainer;
    }

    public static Diagram findActivityDiagram(EOperation eOperation) {
        EAnnotation activityDiagramsContainer = StoryDiagramsUtil.findAllActivityDiagramsContainer(eOperation);
        Activity activity = StoryDiagramsUtil.findActivity(eOperation);
        if (activity != null && activityDiagramsContainer != null) {
            for (EObject content : activityDiagramsContainer.getContents()) {
                if (!(content instanceof Diagram) || !((Diagram)content).getElement().equals(activity)) continue;
                return (Diagram)content;
            }
        }
        return null;
    }

    public static Activity createNewActivityFor(EOperation eOperation) {
        if (StoryDiagramsUtil.findActivity(eOperation) != null) {
            throw new IllegalStateException("The EOperation has already an activity!, EOperation: " + eOperation.toString());
        }
        Activity newActivity = ActivitiesFactory.eINSTANCE.createActivity();
        EAnnotation pointerToActivity = StoryDiagramsUtil.findOrCreatePointerToActivity(eOperation);
        pointerToActivity.getReferences().add((Object)newActivity);
        EAnnotation allActivitiesContainer = StoryDiagramsUtil.findOrCreateAllActivitiesContainer(eOperation);
        allActivitiesContainer.getContents().add((Object)newActivity);
        newActivity.setName(eOperation.getName());
        EAnnotation typesAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        typesAnnotation.setSource("http://www.storydriven.org/storydiagrams/types");
        typesAnnotation.getReferences().add((Object)eOperation.getEContainingClass().getEPackage());
        newActivity.getAnnotations().add((Object)typesAnnotation);
        if (eOperation.getEType() != null) {
            EParameter outParameter = EcoreFactory.eINSTANCE.createEParameter();
            outParameter.setEType(eOperation.getEType());
            newActivity.getContainedParameters().add((Object)outParameter);
            newActivity.getOutParameters().add((Object)outParameter);
            typesAnnotation.getReferences().add((Object)eOperation.getEType().getEPackage());
        }
        for (EParameter parameter : eOperation.getEParameters()) {
            newActivity.getInParameters().add((Object)parameter);
            typesAnnotation.getReferences().add((Object)parameter.getEType().getEPackage());
        }
        return newActivity;
    }

    public static Diagram createNewActivityDiagramFor(EOperation eOperation) {
        Diagram diagram;
        Activity activity = StoryDiagramsUtil.findActivity(eOperation);
        if (activity == null) {
            activity = StoryDiagramsUtil.createNewActivityFor(eOperation);
        }
        if ((diagram = StoryDiagramsUtil.findActivityDiagram(eOperation)) != null) {
            throw new IllegalStateException("The EOperation has already an activity diagram!, EOperation: " + eOperation.toString());
        }
        EAnnotation activityDiagramsContainer = StoryDiagramsUtil.findOrCreateAllActivityDiagramsContainer(eOperation);
        String mid = "Storydiagrams";
        PreferencesHint phint = StorydiagramsDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT;
        diagram = ViewService.createDiagram((EObject)activity, (String)mid, (PreferencesHint)phint);
        diagram.setElement((EObject)activity);
        activityDiagramsContainer.getContents().add((Object)diagram);
        return diagram;
    }
}

