/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.custom.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EParameter;

public final class TypeUtil {
    private TypeUtil() {
    }

    public static String[] getEnumItems(Object element) {
        ArrayList<String> result = new ArrayList<String>();
        for (EEnumLiteral literal : TypeUtil.getLiterals(element)) {
            result.add(literal.getName());
        }
        return result.toArray(new String[result.size()]);
    }

    public static EEnumLiteral getFirstLiteral(Object element) {
        return TypeUtil.getLiterals(element).get(0);
    }

    public static int getIndex(Object element, Object value) {
        int index = 0;
        for (EEnumLiteral literal : TypeUtil.getLiterals(element)) {
            if (literal.equals(value)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static EEnumLiteral getLiteral(Object element, Integer value) {
        return TypeUtil.getLiterals(element).get(value);
    }

    private static List<EEnumLiteral> getLiterals(Object element) {
        EEnum eEnum = (EEnum)((EParameter)element).getEType();
        return eEnum.getELiterals();
    }

    public static Object getParsedValue(EDataType type, String value) {
        switch (TypeUtil.getType(type)) {
            case BOOLEAN: {
                try {
                    return Boolean.parseBoolean(value);
                }
                catch (Exception e) {
                    return null;
                }
            }
            case BYTE: {
                try {
                    return Byte.parseByte(value);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            case SHORT: {
                try {
                    return Short.parseShort(value);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            case CHAR: {
                if (value != null && value.length() == 1) {
                    return "'" + value.charAt(0) + "'";
                }
                return null;
            }
            case INTEGER: {
                try {
                    return Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            case LONG: {
                try {
                    return Long.parseLong(value);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            case FLOAT: {
                try {
                    return Float.valueOf(Float.parseFloat(value));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            case DOUBLE: {
                try {
                    return Double.parseDouble(value);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            case ENUM: {
                System.out.println(String.valueOf(value) + " could not be parsed");
                return null;
            }
        }
        return null;
    }

    public static Type getType(Object element) {
        EClassifier eClassifier;
        if (element instanceof EClassifier && (eClassifier = (EClassifier)element).getInstanceClass() != null) {
            if (Boolean.TYPE.isAssignableFrom(eClassifier.getInstanceClass()) || Boolean.class.isAssignableFrom(eClassifier.getInstanceClass())) {
                return Type.BOOLEAN;
            }
            if (Byte.TYPE.isAssignableFrom(eClassifier.getInstanceClass()) || Byte.class.isAssignableFrom(eClassifier.getInstanceClass())) {
                return Type.BYTE;
            }
            if (Short.TYPE.isAssignableFrom(eClassifier.getInstanceClass()) || Short.class.isAssignableFrom(eClassifier.getInstanceClass())) {
                return Type.SHORT;
            }
            if (Character.TYPE.isAssignableFrom(eClassifier.getInstanceClass()) || Character.class.isAssignableFrom(eClassifier.getInstanceClass())) {
                return Type.CHAR;
            }
            if (Integer.TYPE.isAssignableFrom(eClassifier.getInstanceClass()) || Integer.class.isAssignableFrom(eClassifier.getInstanceClass())) {
                return Type.INTEGER;
            }
            if (Float.TYPE.isAssignableFrom(eClassifier.getInstanceClass()) || Float.class.isAssignableFrom(eClassifier.getInstanceClass())) {
                return Type.FLOAT;
            }
            if (Long.TYPE.isAssignableFrom(eClassifier.getInstanceClass()) || Long.class.isAssignableFrom(eClassifier.getInstanceClass())) {
                return Type.LONG;
            }
            if (Double.TYPE.isAssignableFrom(eClassifier.getInstanceClass()) || Double.class.isAssignableFrom(eClassifier.getInstanceClass())) {
                return Type.DOUBLE;
            }
            if (String.class.isAssignableFrom(eClassifier.getInstanceClass())) {
                return Type.STRING;
            }
            if (eClassifier instanceof EEnum) {
                return Type.ENUM;
            }
        }
        if (element instanceof EParameter) {
            return TypeUtil.getType(((EParameter)element).getEType());
        }
        return Type.UNKNOWN;
    }

    public static enum Type {
        BOOLEAN,
        BYTE,
        CHAR,
        DOUBLE,
        ENUM,
        FLOAT,
        INTEGER,
        LONG,
        SHORT,
        STRING,
        UNKNOWN;

    }
}

